/*
 * Decompiled with CFR 0.152.
 */
package GiciFile;

import GiciException.WarningException;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JaiWrapper {
    static BufferedImage jaiLoad(String string) throws WarningException {
        BufferedImage bufferedImage = null;
        try {
            Method method = Class.forName("javax.media.jai.JAI").getMethod("create", String.class, Object.class);
            Method method2 = Class.forName("javax.media.jai.RenderedOp").getMethod("getAsBufferedImage", new Class[0]);
            Method method3 = Class.forName("javax.media.jai.RenderedOp").getMethod("dispose", new Class[0]);
            Object object = method.invoke(null, "FileLoad", string);
            bufferedImage = (BufferedImage)method2.invoke(object, new Object[0]);
            method3.invoke(object, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("Java Advanced Imaging API (JAI) must be installed in order to be able to operate with this specific file format.");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new WarningException(invocationTargetException.getTargetException().getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("JAI error: " + exception.getMessage());
        }
        return bufferedImage;
    }

    static Raster createRaster(int n, int n2, int n3, DataBufferFloat dataBufferFloat) throws WarningException {
        Raster raster = null;
        try {
            Method method = Class.forName("javax.media.jai.RasterFactory").getMethod("createBandedSampleModel", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Method method2 = Class.forName("javax.media.jai.RasterFactory").getMethod("createRaster", SampleModel.class, DataBuffer.class, Point.class);
            SampleModel sampleModel = (SampleModel)method.invoke(null, 4, n, n2, n3);
            raster = (Raster)method2.invoke(null, sampleModel, dataBufferFloat, new Point(0, 0));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("Java Advanced Imaging API (JAI) must be installed in order to be able to operate with this specific file format.");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new WarningException(invocationTargetException.getTargetException().getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("JAI error: " + exception.getMessage());
        }
        return raster;
    }

    static void jaiSave(BufferedImage bufferedImage, String string, String string2) throws WarningException {
        try {
            Method method = Class.forName("javax.media.jai.JAI").getMethod("create", String.class, RenderedImage.class, Object.class, Object.class);
            method.invoke(null, "filestore", bufferedImage, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("Java Advanced Imaging API (JAI) must be installed in order to be able to operate with this specific file format.");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new WarningException(invocationTargetException.getTargetException().getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("JAI error: " + exception.getMessage());
        }
    }
}

