/*
 * Decompiled with CFR 0.152.
 */
package GiciFile;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.zip.GZIPInputStream;

public class LoadRawFile {
    private static void loadRawData(String string, int n, int n2, int n3, int n4, int n5, BufferReader bufferReader, int n6) throws IOException {
        assert (string != null);
        boolean bl = false;
        int n7 = string.lastIndexOf(".");
        if (n7 >= 0) {
            bl = string.substring(n7 + 1, string.length()).compareToIgnoreCase("gz") == 0;
        }
        FilterInputStream filterInputStream = null;
        filterInputStream = bl ? new GZIPInputStream((InputStream)new FileInputStream(string), 65536) : new BufferedInputStream(new FileInputStream(string), 65536);
        DataInputStream dataInputStream = new DataInputStream(filterInputStream);
        int[] nArray = new int[]{1, 1, 2, 2, 4, 8, 4, 8};
        if (n4 < 0 || n4 >= nArray.length) {
            throw new ArrayIndexOutOfBoundsException("Sample type out of range.");
        }
        int n8 = n3 * nArray[n4];
        ByteBuffer byteBuffer = ByteBuffer.allocate(n8);
        switch (n5) {
            case 0: {
                byteBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 1: {
                byteBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
        }
        if (n6 != 0) {
            dataInputStream.skip((long)n6 * (long)n2 * (long)n8);
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n9 = 0;
                int n10 = 0;
                while ((n9 = dataInputStream.read(byteBuffer.array(), n10 += n9, n8 - n10)) >= 0 && n9 + n10 < n8) {
                }
                if (n9 >= 0) {
                    n9 += n10;
                }
                if (n9 < 0) {
                    throw new EOFException("File reading error (end of file reached before the full file has been read).");
                }
                if (n9 != n8) {
                    throw new IOException("File reading error (" + n9 + " bytes read, but " + n8 + " needed).");
                }
                bufferReader.fillLine(i, j, n3, byteBuffer, n4);
            }
        }
        ((InputStream)filterInputStream).close();
    }

    public static float[][][] loadRawDataToFloat(String string, int n, int n2, int n3, int n4, int n5, boolean bl) throws IOException {
        float[][][] fArray = new float[n][n2][n3];
        LoadRawFile.loadRawData(string, n, n2, n3, n4, n5, new FloatBufferReader(fArray), 0);
        return fArray;
    }

    public static int[][][] loadRawDataToInteger(String string, int n, int n2, int n3, int n4, int n5, boolean bl) throws IOException {
        int[][][] nArray = new int[n][n2][n3];
        LoadRawFile.loadRawData(string, n, n2, n3, n4, n5, new IntegerBufferReader(nArray), 0);
        return nArray;
    }

    public static int[][][] loadRawComponentDataToInteger(String string, int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        assert (n6 >= 0 && n6 < n);
        int[][][] nArray = new int[1][n2][n3];
        LoadRawFile.loadRawData(string, 1, n2, n3, n4, n5, new IntegerBufferReader(nArray), n6);
        return nArray;
    }

    private static class IntegerBufferReader
    extends BufferReader {
        final int[][][] imageSamples;

        IntegerBufferReader(int[][][] nArray) {
            this.imageSamples = nArray;
        }

        @Override
        public void fillLine(int n, int n2, int n3, ByteBuffer byteBuffer, int n4) {
            switch (n4) {
                case 0: {
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = byteBuffer.get(i) == 0 ? 0 : 1;
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = byteBuffer.get(i) & 0xFF;
                    }
                    break;
                }
                case 2: {
                    CharBuffer charBuffer = byteBuffer.asCharBuffer();
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = charBuffer.get(i) & 0xFFFF;
                    }
                    break;
                }
                case 3: {
                    ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = shortBuffer.get(i);
                    }
                    break;
                }
                case 4: {
                    byteBuffer.asIntBuffer().get(this.imageSamples[n][n2]);
                    break;
                }
                case 5: {
                    LongBuffer longBuffer = byteBuffer.asLongBuffer();
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = (int)longBuffer.get(i);
                    }
                    break;
                }
                case 6: {
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = (int)floatBuffer.get(i);
                    }
                    break;
                }
                case 7: {
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = (int)doubleBuffer.get(i);
                    }
                    break;
                }
            }
        }
    }

    private static class FloatBufferReader
    extends BufferReader {
        final float[][][] imageSamples;

        FloatBufferReader(float[][][] fArray) {
            this.imageSamples = fArray;
        }

        @Override
        public void fillLine(int n, int n2, int n3, ByteBuffer byteBuffer, int n4) {
            switch (n4) {
                case 0: {
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = byteBuffer.get(i) == 0 ? 0.0f : 1.0f;
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = byteBuffer.get(i) & 0xFF;
                    }
                    break;
                }
                case 2: {
                    CharBuffer charBuffer = byteBuffer.asCharBuffer();
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = charBuffer.get(i) & 0xFFFF;
                    }
                    break;
                }
                case 3: {
                    ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = shortBuffer.get(i);
                    }
                    break;
                }
                case 4: {
                    IntBuffer intBuffer = byteBuffer.asIntBuffer();
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = intBuffer.get(i);
                    }
                    break;
                }
                case 5: {
                    LongBuffer longBuffer = byteBuffer.asLongBuffer();
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = longBuffer.get(i);
                    }
                    break;
                }
                case 6: {
                    byteBuffer.asFloatBuffer().get(this.imageSamples[n][n2]);
                    break;
                }
                case 7: {
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    for (int i = 0; i < n3; ++i) {
                        this.imageSamples[n][n2][i] = (float)doubleBuffer.get(i);
                    }
                    break;
                }
            }
        }
    }

    private static abstract class BufferReader {
        private BufferReader() {
        }

        public abstract void fillLine(int var1, int var2, int var3, ByteBuffer var4, int var5);
    }
}

