/*
 * Decompiled with CFR 0.152.
 */
package GiciFile.RawImage;

import GiciFile.RawImage.LinkedElement;
import java.util.Iterator;
import java.util.NoSuchElementException;

class DoubleLinkedList<T> {
    private LinkedElement<T> head = null;
    private LinkedElement<T> tail = null;
    private int size = 0;

    public LinkedElement<T> add(T t) {
        LinkedElement<T> linkedElement = new LinkedElement<T>(t);
        if (this.head == null) {
            this.head = linkedElement;
        } else {
            this.tail.next = linkedElement;
        }
        linkedElement.prev = this.tail;
        linkedElement.next = null;
        this.tail = linkedElement;
        ++this.size;
        return linkedElement;
    }

    public LinkedElement<T> poll() throws NoSuchElementException {
        if (this.head == null) {
            throw new NoSuchElementException("Can't do poll operation in empty list");
        }
        LinkedElement<T> linkedElement = this.head;
        this.head = linkedElement.next;
        if (this.head == null) {
            this.tail = null;
        } else {
            this.head.prev = null;
        }
        --this.size;
        return linkedElement;
    }

    public void remove(LinkedElement<T> linkedElement) {
        if (linkedElement.prev != null) {
            linkedElement.prev.next = linkedElement.next;
        } else {
            this.head = linkedElement.next;
        }
        if (linkedElement.next != null) {
            linkedElement.next.prev = linkedElement.prev;
        } else {
            this.tail = linkedElement.prev;
        }
        --this.size;
    }

    public int size() {
        return this.size;
    }

    public Iterator<T> iterator() {
        return new DoubleLinkedListIterator(this.head);
    }

    class DoubleLinkedListIterator
    implements Iterator<T> {
        LinkedElement<T> element;

        DoubleLinkedListIterator(LinkedElement<T> linkedElement) {
            this.element = linkedElement;
        }

        @Override
        public boolean hasNext() {
            return this.element != null;
        }

        @Override
        public T next() throws NoSuchElementException {
            if (this.element == null) {
                throw new NoSuchElementException();
            }
            Object t = this.element.key;
            this.element = this.element.next;
            return t;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove operation is not implemented");
        }
    }
}

