/*
 * Decompiled with CFR 0.152.
 */
package GiciFile.RawImage;

import GiciFile.RawImage.Cache;
import GiciFile.RawImage.OrderConverter;
import GiciFile.RawImage.RawImage;
import GiciFile.RawImage.TypeConverter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class RawImageIterator<T>
implements ListIterator<T> {
    private int MEMORY_ALLOCATED = 0x1000000;
    private RawImage image;
    private RandomAccessFile file;
    private int mode;
    private OrderConverter oc;
    private int offset;
    private TypeConverter<T> ty;
    private int x_length;
    private int size;
    private int index;
    private int lastIndex;
    private int min;
    private int max;
    private Cache<T> cache;
    private int chunkSize;

    public RawImageIterator(RawImage rawImage, T t, File file, int[] nArray, int[] nArray2, int[] nArray3, int n, boolean bl) throws IOException, ClassCastException {
        try {
            this.init(rawImage, t, file, nArray, nArray2, nArray3, n, bl, 0, nArray[nArray2[nArray3[0]]] - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            new Error("An unexpected error was ocurred" + indexOutOfBoundsException.getMessage());
        }
    }

    public RawImageIterator(RawImage rawImage, T t, File file, int[] nArray, int[] nArray2, int[] nArray3, int n, boolean bl, int n2) throws IOException, IndexOutOfBoundsException, ClassCastException {
        this.init(rawImage, t, file, nArray, nArray2, nArray3, n, bl, n2, n2);
    }

    public RawImageIterator(RawImage rawImage, T t, File file, int[] nArray, int[] nArray2, int[] nArray3, int n, boolean bl, int n2, int n3) throws IOException, IndexOutOfBoundsException, ClassCastException {
        this.init(rawImage, t, file, nArray, nArray2, nArray3, n, bl, n2, n3);
    }

    private void init(RawImage rawImage, T t, File file, int[] nArray, int[] nArray2, int[] nArray3, int n, boolean bl, int n2, int n3) throws IOException, IndexOutOfBoundsException, ClassCastException {
        this.image = rawImage;
        this.mode = n;
        this.file = (n & 2) == 2 ? new RandomAccessFile(file, "rw") : new RandomAccessFile(file, "r");
        int[] nArray4 = new int[]{1, 1, 2, 2, 4, 8, 4, 8};
        this.size = nArray4[nArray[3]];
        int n4 = nArray[0] * nArray[1] * nArray[2];
        if ((n & 2) == 0 && file.length() < (long)(n4 * this.size)) {
            throw new IOException("File with incorrect size detected.");
        }
        if ((n & 2) == 2 && file.length() > (long)(n4 * this.size)) {
            this.file.setLength(n4 * this.size);
        }
        this.oc = new OrderConverter(nArray, nArray2, nArray3);
        this.offset = this.oc.getColumnOffset();
        this.ty = new TypeConverter<T>(t, nArray, bl);
        int n5 = nArray[nArray2[nArray3[2]]];
        int n6 = nArray[nArray2[nArray3[1]]];
        int n7 = n6 * n5;
        if (n2 > n3 || n2 < 0 || n3 >= n4 / n7) {
            throw new IndexOutOfBoundsException("Init or final band are not in range [0, " + n4 / (n7 * this.size) + ")");
        }
        this.min = n2 * n6;
        this.max = (n3 + 1) * n6;
        this.index = this.min;
        this.lastIndex = -1;
        this.x_length = nArray[nArray2[nArray3[2]]];
        int n8 = nArray[nArray2[nArray3[0]]];
        this.chunkSize = this.MEMORY_ALLOCATED / (2 * n8);
        this.chunkSize = this.chunkSize < this.x_length ? this.x_length : this.chunkSize;
        this.chunkSize += this.size - this.chunkSize % this.size;
        int n9 = this.offset * this.x_length / this.chunkSize;
        n9 = n9 < 10 ? 10 : n9;
        int n10 = this.MEMORY_ALLOCATED / this.chunkSize;
        n10 = n10 < n9 ? n9 : n10;
        this.cache = new Cache(n10);
    }

    @Override
    public void add(T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Method add is not supported");
    }

    @Override
    public boolean hasNext() {
        return this.index < this.max;
    }

    @Override
    public boolean hasPrevious() {
        return this.index > this.min;
    }

    private byte[] getElement() throws NoSuchElementException {
        if ((this.mode & 1) == 0) {
            return null;
        }
        byte[] byArray = new byte[this.x_length * this.size];
        byte[] byArray2 = new byte[this.chunkSize];
        int n = this.oc.getAddress(this.index * this.x_length) * this.size;
        int n2 = 0;
        int n3 = this.max * this.x_length * this.size;
        try {
            do {
                byte[] byArray3;
                Object t;
                int n4;
                int n5;
                Cache.Block block;
                if ((block = this.cache.get(n / this.chunkSize)) == null) {
                    Object object;
                    n5 = n - n % this.chunkSize;
                    this.file.seek(n5);
                    Arrays.fill(byArray2, (byte)0);
                    n4 = this.file.read(byArray2, 0, this.chunkSize);
                    if (n4 > n3 - n5) {
                        n4 = n3 - n5;
                    }
                    if (n4 < this.chunkSize) {
                        if (n4 < n3 - n5) {
                            if ((this.mode & 2) == 0) {
                                throw new NoSuchElementException("Can't read position " + n5);
                            }
                            n4 = this.chunkSize < n3 - n5 ? this.chunkSize : n3 - n5;
                        }
                        object = new byte[n4];
                        System.arraycopy(byArray2, 0, object, 0, n4);
                        t = this.ty.bytetoT((byte[])object);
                    } else {
                        t = this.ty.bytetoT(byArray2);
                    }
                    Cache<T> cache = this.cache;
                    Objects.requireNonNull(cache);
                    object = this.cache.set(cache.new Cache.Block(t, n / this.chunkSize, false));
                    if (object != null && object.dirty) {
                        byArray3 = this.ty.TtoByte(object.data);
                        this.file.seek(object.position * this.chunkSize);
                        this.file.write(byArray3);
                    }
                } else {
                    t = block.data;
                }
                byArray3 = this.ty.TtoByte(t);
                if (this.offset < 1) {
                    n5 = n % this.chunkSize;
                    n4 = (this.x_length - n2) * this.size;
                    n4 = n5 + n4 > this.chunkSize ? this.chunkSize - n5 : n4;
                    System.arraycopy(byArray3, n5, byArray, n2 * this.size, n4);
                    n2 += n4 / this.size;
                    n += n4;
                    continue;
                }
                n5 = n % this.chunkSize;
                do {
                    System.arraycopy(byArray3, n5, byArray, n2 * this.size, this.size);
                } while ((n5 += this.offset * this.size) < this.chunkSize && ++n2 < this.x_length);
                n += n5 - n % this.chunkSize;
            } while (n2 < this.x_length);
        }
        catch (IOException iOException) {
            throw new NoSuchElementException(iOException.getMessage());
        }
        return byArray;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Image has no next element");
        }
        byte[] byArray = this.getElement();
        this.lastIndex = this.index++;
        return byArray == null ? null : (T)this.ty.bytetoT(byArray);
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public T previous() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("Image has no previous element");
        }
        this.lastIndex = this.index--;
        byte[] byArray = this.getElement();
        return byArray == null ? null : (T)this.ty.bytetoT(this.getElement());
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Method add is not supported");
    }

    @Override
    public void set(T t) throws UnsupportedOperationException, IllegalStateException, NoSuchElementException {
        if ((this.mode & 2) == 0) {
            throw new UnsupportedOperationException("Write operations are not available in this mode");
        }
        if (this.lastIndex == -1) {
            throw new IllegalStateException("Method next hasn't been called");
        }
        byte[] byArray = this.ty.TtoByte(t);
        byte[] byArray2 = new byte[this.chunkSize];
        int n = this.oc.getAddress(this.lastIndex * this.x_length) * this.size;
        int n2 = 0;
        int n3 = this.max * this.x_length * this.size;
        try {
            do {
                byte[] byArray3;
                Object t2;
                int n4;
                int n5;
                Cache.Block block;
                if ((block = this.cache.get(n / this.chunkSize)) == null) {
                    Object object;
                    n5 = n - n % this.chunkSize;
                    this.file.seek(n5);
                    Arrays.fill(byArray2, (byte)0);
                    n4 = this.file.read(byArray2, 0, this.chunkSize);
                    if (n4 > n3 - n5) {
                        n4 = n3 - n5;
                    }
                    if (n4 < this.chunkSize) {
                        if (n4 < n3 - n5) {
                            n4 = this.chunkSize < n3 - n5 ? this.chunkSize : n3 - n5;
                        }
                        object = new byte[n4];
                        System.arraycopy(byArray2, 0, object, 0, n4);
                        t2 = this.ty.bytetoT((byte[])object);
                    } else {
                        t2 = this.ty.bytetoT(byArray2);
                    }
                    Cache<T> cache = this.cache;
                    Objects.requireNonNull(cache);
                    block = cache.new Cache.Block(t2, n / this.chunkSize, true);
                    object = this.cache.set(block);
                    if (object != null && object.dirty) {
                        byArray3 = this.ty.TtoByte(object.data);
                        this.file.seek(object.position * this.chunkSize);
                        this.file.write(byArray3);
                    }
                } else {
                    t2 = block.data;
                    block.dirty = true;
                }
                byArray3 = this.ty.TtoByte(t2);
                if (this.offset < 1) {
                    n5 = n % this.chunkSize;
                    n4 = (this.x_length - n2) * this.size;
                    n4 = n5 + n4 > this.chunkSize ? this.chunkSize - n5 : n4;
                    System.arraycopy(byArray, n2 * this.size, byArray3, n5, n4);
                    n2 += n4 / this.size;
                    n += n4;
                } else {
                    n5 = n % this.chunkSize;
                    do {
                        System.arraycopy(byArray, n2 * this.size, byArray3, n5, this.size);
                    } while ((n5 += this.offset * this.size) < this.chunkSize && ++n2 < this.x_length);
                    n += n5 - n % this.chunkSize;
                }
                block.data = this.ty.bytetoT(byArray3);
            } while (n2 < this.x_length);
        }
        catch (IOException iOException) {
            throw new NoSuchElementException(iOException.getMessage());
        }
    }

    public void close() throws IOException {
        ArrayList<Cache.Block> arrayList = this.cache.flush();
        for (Cache.Block block : arrayList) {
            byte[] byArray = this.ty.TtoByte(block.data);
            this.file.seek(block.position * this.chunkSize);
            this.file.write(byArray);
        }
        this.file.close();
        this.image = null;
    }
}

