/*
 * Decompiled with CFR 0.152.
 */
package GiciFile;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class SaveRawFile {
    private SaveRawFile() {
    }

    private static void saveRawData(BufferFiller bufferFiller, DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        int n3 = bufferFiller.getZSize();
        int n4 = bufferFiller.getYSize();
        int n5 = bufferFiller.getXSize();
        int[] nArray = new int[]{1, 1, 2, 2, 4, 8, 4, 8};
        if (n < 0 || n >= nArray.length) {
            throw new ArrayIndexOutOfBoundsException("Sample type out of range.");
        }
        int n6 = n5 * nArray[n];
        ByteBuffer byteBuffer = ByteBuffer.allocate(n6);
        switch (n2) {
            case 0: {
                byteBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 1: {
                byteBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
        }
        for (int i = 0; i < n3 * n4; ++i) {
            switch (n) {
                case 0: {
                    bufferFiller.fillBufferBoolean(byteBuffer);
                    break;
                }
                case 1: {
                    bufferFiller.fillBuffer(byteBuffer);
                    break;
                }
                case 2: {
                    bufferFiller.fillBuffer(byteBuffer.asCharBuffer());
                    break;
                }
                case 3: {
                    bufferFiller.fillBuffer(byteBuffer.asShortBuffer());
                    break;
                }
                case 4: {
                    bufferFiller.fillBuffer(byteBuffer.asIntBuffer());
                    break;
                }
                case 5: {
                    bufferFiller.fillBuffer(byteBuffer.asLongBuffer());
                    break;
                }
                case 6: {
                    bufferFiller.fillBuffer(byteBuffer.asFloatBuffer());
                    break;
                }
                case 7: {
                    bufferFiller.fillBuffer(byteBuffer.asDoubleBuffer());
                }
            }
            bufferFiller.inc();
            dataOutputStream.write(byteBuffer.array(), 0, n6);
        }
    }

    private static void saveRawData(BufferFiller bufferFiller, String string, int n, int n2) throws IOException {
        File file = new File(string);
        FileOutputStream fileOutputStream = null;
        if (file.exists()) {
            file.delete();
            file.createNewFile();
        }
        fileOutputStream = new FileOutputStream(file);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        SaveRawFile.saveRawData(bufferFiller, dataOutputStream, n, n2);
        fileOutputStream.close();
    }

    public static void saveRawData(float[][][] fArray, DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        assert (fArray != null && dataOutputStream != null);
        FloatBufferFiller floatBufferFiller = new FloatBufferFiller(fArray);
        SaveRawFile.saveRawData((BufferFiller)floatBufferFiller, dataOutputStream, n, n2);
    }

    public static void saveRawData(float[][][] fArray, String string, int n, int n2) throws IOException {
        assert (fArray != null && string != null);
        FloatBufferFiller floatBufferFiller = new FloatBufferFiller(fArray);
        SaveRawFile.saveRawData((BufferFiller)floatBufferFiller, string, n, n2);
    }

    public static void saveRawData(int[][][] nArray, String string, int n, int n2) throws IOException {
        assert (nArray != null && string != null);
        IntegerBufferFiller integerBufferFiller = new IntegerBufferFiller(nArray);
        SaveRawFile.saveRawData((BufferFiller)integerBufferFiller, string, n, n2);
    }

    private static class IntegerBufferFiller
    extends BufferFiller {
        private final int[][][] imageSamples;

        public IntegerBufferFiller(int[][][] nArray) {
            super(nArray.length, nArray[0].length, nArray[0][0].length);
            this.imageSamples = nArray;
        }

        @Override
        public void fillBufferBoolean(ByteBuffer byteBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                byteBuffer.put(i, (byte)(this.imageSamples[this.z][this.y][i] != 0 ? 1 : 0));
            }
        }

        @Override
        public void fillBuffer(ByteBuffer byteBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                if (this.imageSamples[this.z][this.y][i] > 255 || this.imageSamples[this.z][this.y][i] < 0) {
                    this.warnOutOfRange("Pixel out of range: " + this.imageSamples[this.z][this.y][i] + " not in [0, 255]");
                }
                byte by = (byte)Math.max(Math.min(this.imageSamples[this.z][this.y][i], 255), 0);
                byteBuffer.put(i, by);
            }
        }

        @Override
        public void fillBuffer(CharBuffer charBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                if (this.imageSamples[this.z][this.y][i] > 65535 || this.imageSamples[this.z][this.y][i] < 0) {
                    this.warnOutOfRange("Pixel out of range: " + this.imageSamples[this.z][this.y][i] + " not in [\u0000, \uffff]");
                }
                char c = (char)Math.max(Math.min(this.imageSamples[this.z][this.y][i], 65535), 0);
                charBuffer.put(i, c);
            }
        }

        @Override
        public void fillBuffer(ShortBuffer shortBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                if (this.imageSamples[this.z][this.y][i] > Short.MAX_VALUE || this.imageSamples[this.z][this.y][i] < Short.MIN_VALUE) {
                    this.warnOutOfRange("Pixel out of range: " + this.imageSamples[this.z][this.y][i] + " not in [-32768, 32767]");
                }
                short s = (short)Math.max(Math.min(this.imageSamples[this.z][this.y][i], Short.MAX_VALUE), Short.MIN_VALUE);
                shortBuffer.put(i, s);
            }
        }

        @Override
        public void fillBuffer(IntBuffer intBuffer) {
            intBuffer.put(this.imageSamples[this.z][this.y]);
        }

        @Override
        public void fillBuffer(LongBuffer longBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                longBuffer.put(i, this.imageSamples[this.z][this.y][i]);
            }
        }

        @Override
        public void fillBuffer(FloatBuffer floatBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                floatBuffer.put(i, this.imageSamples[this.z][this.y][i]);
            }
        }

        @Override
        public void fillBuffer(DoubleBuffer doubleBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                doubleBuffer.put(i, this.imageSamples[this.z][this.y][i]);
            }
        }
    }

    private static class FloatBufferFiller
    extends BufferFiller {
        private final float[][][] imageSamples;

        public FloatBufferFiller(float[][][] fArray) {
            super(fArray.length, fArray[0].length, fArray[0][0].length);
            this.imageSamples = fArray;
        }

        @Override
        public void fillBufferBoolean(ByteBuffer byteBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                byteBuffer.put(i, (byte)(this.imageSamples[this.z][this.y][i] != 0.0f ? 1 : 0));
            }
        }

        @Override
        public void fillBuffer(ByteBuffer byteBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                if (this.imageSamples[this.z][this.y][i] > 255.0f || this.imageSamples[this.z][this.y][i] < 0.0f) {
                    this.warnOutOfRange("Pixel out of range: " + this.imageSamples[this.z][this.y][i] + " not in [0, 255]");
                }
                byte by = (byte)Math.max(Math.min(this.imageSamples[this.z][this.y][i], 255.0f), 0.0f);
                byteBuffer.put(i, by);
            }
        }

        @Override
        public void fillBuffer(CharBuffer charBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                if (this.imageSamples[this.z][this.y][i] > 65535.0f || this.imageSamples[this.z][this.y][i] < 0.0f) {
                    this.warnOutOfRange("Pixel out of range: " + this.imageSamples[this.z][this.y][i] + " not in [\u0000, \uffff]");
                }
                char c = (char)Math.max(Math.min(this.imageSamples[this.z][this.y][i], 65535.0f), 0.0f);
                charBuffer.put(i, c);
            }
        }

        @Override
        public void fillBuffer(ShortBuffer shortBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                if (this.imageSamples[this.z][this.y][i] > 32767.0f || this.imageSamples[this.z][this.y][i] < -32768.0f) {
                    this.warnOutOfRange("Pixel out of range: " + this.imageSamples[this.z][this.y][i] + " not in [-32768, 32767]");
                }
                short s = (short)Math.max(Math.min(this.imageSamples[this.z][this.y][i], 32767.0f), -32768.0f);
                shortBuffer.put(i, s);
            }
        }

        @Override
        public void fillBuffer(IntBuffer intBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                if (this.imageSamples[this.z][this.y][i] > 2097152.0f || this.imageSamples[this.z][this.y][i] < -2097152.0f) {
                    this.warnOutOfRange("Pixel probably out of range.");
                }
                intBuffer.put(i, (int)this.imageSamples[this.z][this.y][i]);
            }
        }

        @Override
        public void fillBuffer(LongBuffer longBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                longBuffer.put(i, (long)this.imageSamples[this.z][this.y][i]);
            }
        }

        @Override
        public void fillBuffer(FloatBuffer floatBuffer) {
            floatBuffer.put(this.imageSamples[this.z][this.y]);
        }

        @Override
        public void fillBuffer(DoubleBuffer doubleBuffer) {
            for (int i = 0; i < this.xSize; ++i) {
                doubleBuffer.put(i, this.imageSamples[this.z][this.y][i]);
            }
        }
    }

    private static abstract class BufferFiller {
        protected final int zSize;
        protected final int ySize;
        protected final int xSize;
        protected int z = 0;
        protected int y = 0;
        private int outOfRangeWarnings = 0;

        protected BufferFiller(int n, int n2, int n3) {
            this.zSize = n;
            this.ySize = n2;
            this.xSize = n3;
        }

        public final void inc() {
            this.y = (this.y + 1) % this.ySize;
            if (this.y == 0) {
                this.z = (this.z + 1) % this.zSize;
            }
        }

        public final int getXSize() {
            return this.xSize;
        }

        public final int getYSize() {
            return this.ySize;
        }

        public final int getZSize() {
            return this.zSize;
        }

        protected final void warnOutOfRange(String string) {
            if (this.outOfRangeWarnings == 0) {
                System.err.println(string);
            }
            ++this.outOfRangeWarnings;
            if (this.outOfRangeWarnings == 11 || this.outOfRangeWarnings == 101 || this.outOfRangeWarnings == 1001) {
                System.err.println("[" + (this.outOfRangeWarnings - 1) + " duplicate warning messages suppressed]");
            } else if (this.outOfRangeWarnings == 10000) {
                System.err.println("[100000 reached; stopped reporting]");
            }
        }

        public abstract void fillBufferBoolean(ByteBuffer var1);

        public abstract void fillBuffer(ByteBuffer var1);

        public abstract void fillBuffer(CharBuffer var1);

        public abstract void fillBuffer(ShortBuffer var1);

        public abstract void fillBuffer(IntBuffer var1);

        public abstract void fillBuffer(LongBuffer var1);

        public abstract void fillBuffer(FloatBuffer var1);

        public abstract void fillBuffer(DoubleBuffer var1);
    }
}

