/*
 * Decompiled with CFR 0.152.
 */
package GiciImageExtension;

public class ImageExtension {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int[] imageExtensionType = null;
    int[] WTLevels = null;
    boolean parametersSet = false;
    int[] PadRows = null;

    public ImageExtension(float[][][] fArray) {
        this.imageSamples = fArray;
        this.zSize = fArray.length;
        this.ySize = fArray[0].length;
        this.xSize = fArray[0][0].length;
    }

    public void setParameters(int[] nArray, int[] nArray2) {
        this.parametersSet = true;
        this.imageExtensionType = nArray;
        this.WTLevels = nArray2;
    }

    public static boolean needImageExtension(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] == 2 || nArray2[i] == 0) continue;
            int n4 = 1 << nArray2[i];
            int n5 = 1 << nArray2[i];
            if (n2 % n4 == 0 && n % n5 == 0) continue;
            return true;
        }
        return false;
    }

    public int getExtendedIndex(int n, int n2, int n3) throws Exception {
        if (n >= 0 && n < n2) {
            return n;
        }
        if (n3 == 0) {
            return n2 - 1;
        }
        if (n3 == 1) {
            int n4 = n;
            while (n4 < 0 || n4 >= n2) {
                if (n4 < 0) {
                    n4 = -n4;
                    continue;
                }
                n4 = 2 * (n2 - 1) - n4;
            }
            return n4;
        }
        return -1;
    }

    public float[][][] run() throws Exception {
        if (!this.parametersSet) {
            throw new Exception("ImageExtension cannot run if parameters are not set.");
        }
        this.PadRows = new int[this.zSize];
        float[][][] fArrayArray = new float[this.zSize][][];
        for (int i = 0; i < this.zSize; ++i) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            int n7 = 0;
            if (this.imageExtensionType[i] != 2 && this.WTLevels[i] != 0) {
                n5 = 1 << this.WTLevels[i];
                n4 = 1 << this.WTLevels[i];
                if (this.ySize % n5 != 0) {
                    n6 = n5 - this.ySize % n5;
                }
                if (this.xSize % n4 != 0) {
                    n7 = n4 - this.xSize % n4;
                }
            }
            n5 = this.ySize + n6;
            n4 = this.xSize + n7;
            this.PadRows[i] = n6;
            fArrayArray[i] = new float[n5][n4];
            for (n3 = 0; n3 < this.ySize; ++n3) {
                for (n2 = 0; n2 < this.xSize; ++n2) {
                    fArrayArray[i][n3][n2] = this.imageSamples[i][n3][n2];
                }
                for (n2 = this.xSize; n2 < n4; ++n2) {
                    n = this.getExtendedIndex(n2, this.xSize, this.imageExtensionType[i]);
                    fArrayArray[i][n3][n2] = this.imageSamples[i][n3][n];
                }
            }
            for (n3 = this.ySize; n3 < n5; ++n3) {
                for (n2 = 0; n2 < n4; ++n2) {
                    n = this.getExtendedIndex(n2, this.xSize, this.imageExtensionType[i]);
                    int n8 = this.getExtendedIndex(n3, this.ySize, this.imageExtensionType[i]);
                    fArrayArray[i][n3][n2] = this.imageSamples[i][n8][n];
                }
            }
        }
        return fArrayArray;
    }

    public int[] getPadRows() {
        return this.PadRows;
    }
}

