/*
 * Decompiled with CFR 0.152.
 */
package GiciMask;

import GiciException.ErrorException;
import GiciException.WarningException;
import GiciStream.BitStream;

public class ArithmeticDecoding {
    protected boolean parameters = false;
    protected int numberOfSymbols = 0;
    protected int bitsSymbol = 0;
    protected int windowSize = 0;
    protected int[] cumFrequencies = null;
    protected BitStream inputBS = null;
    protected BitStream outputBS = null;
    protected BitStream arithmeticDecodedBS = null;
    protected boolean endBitStream = false;
    protected int low = 0;
    protected int high = 65535;
    protected int code = 0;
    protected int scale = 0;
    protected int[] symbolOcurrences = null;

    public ArithmeticDecoding(int n, BitStream bitStream) throws WarningException {
        this.code = bitStream.getBits(16);
        this.numberOfSymbols = n;
        this.inputBS = bitStream;
    }

    public void setParameters(int n, int[] nArray) throws ErrorException {
        int n2;
        this.parameters = true;
        if (n < 0) {
            throw new ErrorException("The window size specified for the arithmetic encoding of the mask is not correct.");
        }
        this.windowSize = n;
        this.cumFrequencies = new int[this.numberOfSymbols];
        if (nArray == null) {
            this.scale = 1001;
            nArray = new int[this.numberOfSymbols];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = (this.scale - 1) / this.numberOfSymbols;
            }
        }
        this.cumFrequencies[0] = nArray[0];
        for (n2 = 1; n2 < nArray.length; ++n2) {
            this.cumFrequencies[n2] = nArray[n2] + this.cumFrequencies[n2 - 1];
        }
        this.scale = this.cumFrequencies[this.cumFrequencies.length - 1] + 1;
        this.symbolOcurrences = new int[this.numberOfSymbols];
        if (nArray.length != this.numberOfSymbols) {
            throw new ErrorException("The probabilities vector is not complete. You must specify a probability for each symbol.");
        }
    }

    public void run() throws ErrorException {
        if (!this.parameters) {
            throw new ErrorException("You must specify the parameters.");
        }
        if (this.numberOfSymbols <= 0) {
            throw new ErrorException("The number of symbols in the class is negative.");
        }
        if (this.inputBS == null) {
            throw new ErrorException("The input bit stream is empty.");
        }
        int n = this.windowSize;
        int n2 = 0;
        this.bitsSymbol = (int)Math.ceil(Math.log(this.numberOfSymbols) / Math.log(2.0));
        this.outputBS = new BitStream();
        do {
            n2 = this.decodeSymbol();
            this.outputBS.addBits(n2, this.bitsSymbol);
            if (this.windowSize != 0) {
                --n;
                int n3 = n2;
                this.symbolOcurrences[n3] = this.symbolOcurrences[n3] + 1;
            }
            if (this.windowSize == 0 || n != 0) continue;
            this.updateTableProbabilities();
            n = this.windowSize;
        } while (!this.endBitStream);
    }

    protected int decodeSymbol() {
        int n = 0;
        long l = (long)(this.high - this.low) + 1L;
        long l2 = (long)(this.code - this.low + 1) * (long)this.scale - 1L;
        while ((long)this.cumFrequencies[n] * l <= l2) {
            ++n;
        }
        this.high = this.low + (int)(l * (long)this.cumFrequencies[n] / (long)this.scale - 1L);
        if (n != 0) {
            this.low += (int)(l * (long)this.cumFrequencies[n - 1] / (long)this.scale);
        }
        this.recalculateHLC();
        return n;
    }

    protected void recalculateHLC() {
        while (true) {
            if ((this.high & 0x8000) != (this.low & 0x8000)) {
                if ((this.low & 0x4000) == 16384 && (this.high & 0x4000) == 0) {
                    this.low &= 0x3FFF;
                    this.high |= 0x4000;
                    this.code ^= 0x4000;
                } else {
                    return;
                }
            }
            this.low <<= 1;
            this.low &= 0xFFFF;
            this.high <<= 1;
            this.high &= 0xFFFF;
            this.high |= 1;
            this.code <<= 1;
            this.code &= 0xFFFF;
            try {
                this.code |= this.inputBS.getBits(1);
                continue;
            }
            catch (WarningException warningException) {
                this.code &= 0;
                this.endBitStream = true;
                continue;
            }
            break;
        }
    }

    protected void updateTableProbabilities() {
        int n;
        int[] nArray = new int[this.cumFrequencies.length];
        nArray[0] = this.cumFrequencies[0] + this.symbolOcurrences[0];
        this.symbolOcurrences[0] = 0;
        for (n = nArray.length - 1; n > 0; --n) {
            nArray[n] = this.cumFrequencies[n] - this.cumFrequencies[n - 1];
            int n2 = n;
            nArray[n2] = nArray[n2] + this.symbolOcurrences[n];
            this.symbolOcurrences[n] = 0;
        }
        this.cumFrequencies[0] = nArray[0];
        for (n = 1; n < nArray.length; ++n) {
            this.cumFrequencies[n] = nArray[n] + this.cumFrequencies[n - 1];
        }
        if (this.cumFrequencies[this.cumFrequencies.length - 1] > 16383) {
            for (n = nArray.length - 1; n >= 0; --n) {
                int n3 = n;
                nArray[n3] = nArray[n3] / 2;
                if (nArray[n] != 0) continue;
                nArray[n] = 1;
            }
            this.cumFrequencies[0] = nArray[0];
            for (n = 1; n < nArray.length; ++n) {
                this.cumFrequencies[n] = nArray[n] + this.cumFrequencies[n - 1];
            }
        }
        this.scale = this.cumFrequencies[this.cumFrequencies.length - 1] + 1;
    }

    public BitStream getOutputBS() {
        return this.outputBS;
    }
}

