/*
 * Decompiled with CFR 0.152.
 */
package GiciMask;

import GiciException.ErrorException;
import GiciException.WarningException;
import GiciStream.BitStream;

public class ArithmeticEncoding {
    protected boolean parameters = false;
    protected int numberOfSymbols = 0;
    protected int windowSize = 0;
    protected int[] cumFrequencies = null;
    protected BitStream inputBS = null;
    protected BitStream arithmeticEncodedBS = null;
    protected int low = 0;
    protected int high = 65535;
    protected long underflow = 0L;
    protected int scale = 0;
    protected int[] symbolOcurrences = null;

    public ArithmeticEncoding(int n, BitStream bitStream) {
        this.numberOfSymbols = n;
        this.inputBS = bitStream;
    }

    public void setParameters(int n, int[] nArray) throws ErrorException {
        int n2;
        this.parameters = true;
        if (n < 0) {
            throw new ErrorException("The window size specified for the arithmetic encoding must be positive.");
        }
        this.windowSize = n;
        this.cumFrequencies = new int[this.numberOfSymbols];
        if (nArray == null) {
            this.scale = 1001;
            nArray = new int[this.numberOfSymbols];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = (this.scale - 1) / this.numberOfSymbols;
            }
        }
        this.cumFrequencies[0] = nArray[0];
        for (n2 = 1; n2 < nArray.length; ++n2) {
            this.cumFrequencies[n2] = nArray[n2] + this.cumFrequencies[n2 - 1];
        }
        this.scale = this.cumFrequencies[this.cumFrequencies.length - 1] + 1;
        this.symbolOcurrences = new int[this.numberOfSymbols];
        if (nArray.length != this.numberOfSymbols) {
            throw new ErrorException("The probabilities vector is not complete. You must specify a probability for each symbol.");
        }
    }

    public void run() throws ErrorException {
        if (!this.parameters) {
            throw new ErrorException("You must specify the parameters.");
        }
        if (this.numberOfSymbols <= 0) {
            throw new ErrorException("The number of symbols in the class is negative.");
        }
        if (this.inputBS == null) {
            throw new ErrorException("The input bitstream is empty.");
        }
        int n = this.windowSize;
        int n2 = 0;
        int n3 = (int)Math.ceil(Math.log(this.numberOfSymbols) / Math.log(2.0));
        this.arithmeticEncodedBS = new BitStream();
        int n4 = 0;
        while ((long)n4 < this.inputBS.getNumBits() / (long)n3) {
            try {
                n2 = this.inputBS.getBits(n3);
            }
            catch (WarningException warningException) {
                throw new ErrorException("The bit stream is finished unexpectly.");
            }
            this.encodeSymbol(n2);
            if (this.windowSize != 0) {
                --n;
                int n5 = n2;
                this.symbolOcurrences[n5] = this.symbolOcurrences[n5] + 1;
            }
            if (this.windowSize != 0 && n == 0) {
                this.updateTableProbabilities();
                n = this.windowSize;
            }
            ++n4;
        }
        this.arithmeticEncodedBS.addBit((this.low & 0x4000) == 16384);
        ++this.underflow;
        while (this.underflow > 0L) {
            this.arithmeticEncodedBS.addBit((~this.low & 0x4000) == 16384);
            --this.underflow;
        }
        this.arithmeticEncodedBS.addBits(0, 16);
    }

    protected void encodeSymbol(int n) {
        long l = (long)(this.high - this.low) + 1L;
        this.high = this.low + (int)(l * (long)this.cumFrequencies[n] / (long)this.scale - 1L);
        if (n != 0) {
            this.low += (int)(l * (long)this.cumFrequencies[n - 1] / (long)this.scale);
        }
        while (true) {
            if ((this.high & 0x8000) == (this.low & 0x8000)) {
                this.arithmeticEncodedBS.addBit((this.high & 0x8000) == 32768);
                while (this.underflow > 0L) {
                    this.arithmeticEncodedBS.addBit((~this.high & 0x8000) == 32768);
                    --this.underflow;
                }
            } else if ((this.low & 0x4000) == 16384 && (this.high & 0x4000) == 0) {
                ++this.underflow;
                this.low &= 0x3FFF;
                this.high |= 0x4000;
            } else {
                return;
            }
            this.low <<= 1;
            this.high <<= 1;
            this.low &= 0xFFFF;
            this.high &= 0xFFFF;
            this.high |= 1;
        }
    }

    protected void updateTableProbabilities() {
        int n;
        int[] nArray = new int[this.cumFrequencies.length];
        nArray[0] = this.cumFrequencies[0] + this.symbolOcurrences[0];
        this.symbolOcurrences[0] = 0;
        for (n = nArray.length - 1; n > 0; --n) {
            nArray[n] = this.cumFrequencies[n] - this.cumFrequencies[n - 1];
            int n2 = n;
            nArray[n2] = nArray[n2] + this.symbolOcurrences[n];
            this.symbolOcurrences[n] = 0;
        }
        this.cumFrequencies[0] = nArray[0];
        for (n = 1; n < nArray.length; ++n) {
            this.cumFrequencies[n] = nArray[n] + this.cumFrequencies[n - 1];
        }
        if (this.cumFrequencies[this.cumFrequencies.length - 1] > 16383) {
            for (n = nArray.length - 1; n >= 0; --n) {
                int n3 = n;
                nArray[n3] = nArray[n3] / 2;
                if (nArray[n] != 0) continue;
                nArray[n] = 1;
            }
            this.cumFrequencies[0] = nArray[0];
            for (n = 1; n < nArray.length; ++n) {
                this.cumFrequencies[n] = nArray[n] + this.cumFrequencies[n - 1];
            }
        }
        this.scale = this.cumFrequencies[this.cumFrequencies.length - 1] + 1;
    }

    public BitStream getArithmeticEncodedBS() {
        return this.arithmeticEncodedBS;
    }
}

