/*
 * Decompiled with CFR 0.152.
 */
package GiciMask;

import GiciException.ErrorException;
import GiciException.WarningException;
import GiciStream.BitStream;

public class QuadTreeDecoding {
    protected boolean parameters = false;
    protected int zSize = 0;
    protected int ySize = 0;
    protected int xSize = 0;
    protected int blockWidth = 0;
    protected int blockHeight = 0;
    protected byte[][][] mask = null;
    protected BitStream bs = null;

    public QuadTreeDecoding(BitStream bitStream, int n, int n2, int n3) {
        this.bs = bitStream;
        this.zSize = n;
        this.ySize = n2;
        this.xSize = n3;
        this.mask = new byte[n][n2][n3];
    }

    public void setParameters(int n, int n2) throws ErrorException {
        this.parameters = true;
        if (n < 0 || n2 < 0) {
            throw new ErrorException("Block dimensions to encoding the mask must be positives: " + n + " " + n2);
        }
        this.blockWidth = n;
        this.blockHeight = n2;
    }

    public void decodeMask() throws ErrorException {
        if (!this.parameters) {
            throw new ErrorException("Parameters must be set to encode the mask.");
        }
        int n = (int)Math.pow(2.0, this.blockWidth);
        int n2 = (int)Math.pow(2.0, this.blockHeight);
        int n3 = (int)Math.ceil((double)this.xSize / (double)n);
        int n4 = (int)Math.ceil((double)this.ySize / (double)n2);
        for (int i = 0; i < this.zSize; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n3; ++k) {
                    int n5 = k * n;
                    int n6 = j * n2;
                    this.decodeBlock(i, n5, n6, n, n2);
                }
            }
        }
    }

    protected void decodeBlock(int n, int n2, int n3, int n4, int n5) throws ErrorException {
        if (n2 >= this.xSize || n3 >= this.ySize) {
            return;
        }
        try {
            int n6 = this.bs.getBits(2);
            if (n6 == 1) {
                for (int i = n3; i < n3 + n5; ++i) {
                    for (int j = n2; j < n2 + n4; ++j) {
                        if (j >= this.xSize || i >= this.ySize) continue;
                        this.mask[n][i][j] = 1;
                    }
                }
            } else if (n6 == 2) {
                this.decodeBlock(n, n2, n3, n4 / 2, n5 / 2);
                this.decodeBlock(n, n2 + n4 / 2, n3, n4 / 2, n5 / 2);
                this.decodeBlock(n, n2, n3 + n5 / 2, n4 / 2, n5 / 2);
                this.decodeBlock(n, n2 + n4 / 2, n3 + n5 / 2, n4 / 2, n5 / 2);
            }
        }
        catch (WarningException warningException) {
            throw new ErrorException("The mask bitstream final is reached before the complete process ends.");
        }
    }

    public byte[][][] getMask() {
        return this.mask;
    }
}

