/*
 * Decompiled with CFR 0.152.
 */
package GiciMatrix;

import GiciParallel.ParallelMap;

public class MatrixAlgebra {
    protected MatrixAlgebra() {
        throw new UnsupportedOperationException();
    }

    public static float[][] transposeC(float[][] fArray) {
        float[][] fArray2 = new float[fArray[0].length][fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                assert (fArray[i].length == fArray[0].length);
                fArray2[j][i] = fArray[i][j];
            }
        }
        return fArray2;
    }

    public static double[][] transposeC(double[][] dArray) {
        double[][] dArray2 = new double[dArray[0].length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                assert (dArray[i].length == dArray[0].length);
                dArray2[j][i] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static float[][] subMultiplicationCC(float[][] fArray, float[][] fArray2) {
        int n;
        int n2;
        assert (fArray.length > 0 && fArray.length == fArray[0].length);
        assert (fArray.length <= fArray2.length);
        assert (fArray2.length > 0);
        float[][] fArray3 = new float[fArray2.length][fArray2[0].length];
        int n3 = fArray2.length - fArray.length;
        for (n2 = 0; n2 < fArray.length; ++n2) {
            assert (fArray.length == fArray[n2].length);
            assert (fArray2[0].length == fArray2[n2 + n3].length);
            for (n = 0; n < fArray2[0].length; ++n) {
                for (int i = 0; i < fArray.length; ++i) {
                    float[] fArray4 = fArray3[n2 + n3];
                    int n4 = n;
                    fArray4[n4] = fArray4[n4] + fArray[n2][i] * fArray2[i + n3][n];
                }
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            assert (fArray2[0].length == fArray2[n2].length);
            for (n = 0; n < fArray2[0].length; ++n) {
                fArray3[n2][n] = fArray2[n2][n];
            }
        }
        return fArray3;
    }

    public static float[][] multiplicationCC(final float[][] fArray, final float[][] fArray2) {
        assert (fArray.length > 0);
        assert (fArray2.length > 0);
        assert (fArray[0].length == fArray2.length);
        final float[][] fArray3 = new float[fArray.length][fArray2[0].length];
        if (fArray2.length < 512) {
            for (int i = 0; i < fArray.length; ++i) {
                assert (fArray[0].length == fArray[i].length);
                for (int j = 0; j < fArray2[0].length; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < fArray2.length; ++k) {
                        assert (fArray2[0].length == fArray2[k].length);
                        d += (double)(fArray[i][k] * fArray2[k][j]);
                    }
                    fArray3[i][j] = (float)d;
                }
            }
        } else {
            ParallelMap.map(new ParallelMap.MultidimensionalIterator(fArray.length, fArray2[0].length), new ParallelMap.MapInterface<int[]>(){

                @Override
                public void apply(int[] nArray) {
                    double d = 0.0;
                    for (int i = 0; i < fArray2.length; ++i) {
                        assert (fArray2[0].length == fArray2[i].length);
                        d += (double)(fArray[nArray[0]][i] * fArray2[i][nArray[1]]);
                    }
                    fArray3[nArray[0]][nArray[1]] = (float)d;
                }
            });
        }
        return fArray3;
    }

    public static double[][] multiplicationCC(final double[][] dArray, final double[][] dArray2) {
        assert (dArray.length > 0);
        assert (dArray2.length > 0);
        assert (dArray[0].length == dArray2.length);
        final double[][] dArray3 = new double[dArray.length][dArray2[0].length];
        if (dArray2.length < 512) {
            for (int i = 0; i < dArray.length; ++i) {
                assert (dArray[0].length == dArray[i].length);
                for (int j = 0; j < dArray2[0].length; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < dArray2.length; ++k) {
                        assert (dArray2[0].length == dArray2[k].length);
                        d += dArray[i][k] * dArray2[k][j];
                    }
                    dArray3[i][j] = d;
                }
            }
        } else {
            ParallelMap.map(new ParallelMap.MultidimensionalIterator(dArray.length, dArray2[0].length), new ParallelMap.MapInterface<int[]>(){

                @Override
                public void apply(int[] nArray) {
                    double d = 0.0;
                    for (int i = 0; i < dArray2.length; ++i) {
                        assert (dArray2[0].length == dArray2[i].length);
                        d += dArray[nArray[0]][i] * dArray2[i][nArray[1]];
                    }
                    dArray3[nArray[0]][nArray[1]] = d;
                }
            });
        }
        return dArray3;
    }

    public static float[][] multiplicationCCf(final double[][] dArray, final double[][] dArray2) {
        assert (dArray.length > 0);
        assert (dArray2.length > 0);
        assert (dArray[0].length == dArray2.length);
        final float[][] fArray = new float[dArray.length][dArray2[0].length];
        if (dArray2.length < 512) {
            for (int i = 0; i < dArray.length; ++i) {
                assert (dArray[0].length == dArray[i].length);
                for (int j = 0; j < dArray2[0].length; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < dArray2.length; ++k) {
                        assert (dArray2[0].length == dArray2[k].length);
                        d += dArray[i][k] * dArray2[k][j];
                    }
                    fArray[i][j] = (float)d;
                }
            }
        } else {
            ParallelMap.map(new ParallelMap.MultidimensionalIterator(dArray.length, dArray2[0].length), new ParallelMap.MapInterface<int[]>(){

                @Override
                public void apply(int[] nArray) {
                    double d = 0.0;
                    for (int i = 0; i < dArray2.length; ++i) {
                        assert (dArray2[0].length == dArray2[i].length);
                        d += dArray[nArray[0]][i] * dArray2[i][nArray[1]];
                    }
                    fArray[nArray[0]][nArray[1]] = (float)d;
                }
            });
        }
        return fArray;
    }

    public static void multiplicationCpaddedCInplace(final float[][] fArray, final float[][] fArray2) {
        assert (fArray.length > 0);
        assert (fArray2.length > 0);
        assert (fArray[0].length <= fArray2.length);
        final float[][] fArray3 = new float[fArray[0].length][fArray2[0].length];
        if (fArray2.length < 512) {
            for (int i = 0; i < fArray.length; ++i) {
                for (int j = 0; j < fArray2[0].length; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < fArray[0].length; ++k) {
                        assert (fArray2[0].length == fArray2[k].length);
                        d += (double)(fArray[i][k] * fArray2[k][j]);
                    }
                    fArray3[i][j] = (float)d;
                }
            }
            System.arraycopy(fArray3, 0, fArray2, 0, fArray.length);
        } else {
            ParallelMap.map(new ParallelMap.MultidimensionalIterator(fArray.length, fArray2[0].length), new ParallelMap.MapInterface<int[]>(){

                @Override
                public void apply(int[] nArray) {
                    double d = 0.0;
                    for (int i = 0; i < fArray[0].length; ++i) {
                        assert (fArray2[0].length == fArray2[i].length);
                        d += (double)(fArray[nArray[0]][i] * fArray2[i][nArray[1]]);
                    }
                    fArray3[nArray[0]][nArray[1]] = (float)d;
                }
            });
            System.arraycopy(fArray3, 0, fArray2, 0, fArray.length);
        }
    }

    public static void multiplicationCpaddedCInplace(final float[][] fArray, final double[][] dArray) {
        assert (fArray.length > 0);
        assert (dArray.length > 0);
        assert (fArray[0].length <= dArray.length);
        final double[][] dArray2 = new double[fArray[0].length][dArray[0].length];
        if (dArray.length < 512) {
            for (int i = 0; i < fArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < fArray[0].length; ++k) {
                        assert (dArray[0].length == dArray[k].length);
                        d += (double)fArray[i][k] * dArray[k][j];
                    }
                    dArray2[i][j] = d;
                }
            }
            System.arraycopy(dArray2, 0, dArray, 0, fArray.length);
        } else {
            ParallelMap.map(new ParallelMap.MultidimensionalIterator(fArray.length, dArray[0].length), new ParallelMap.MapInterface<int[]>(){

                @Override
                public void apply(int[] nArray) {
                    double d = 0.0;
                    for (int i = 0; i < fArray[0].length; ++i) {
                        assert (dArray[0].length == dArray[i].length);
                        d += (double)fArray[nArray[0]][i] * dArray[i][nArray[1]];
                    }
                    dArray2[nArray[0]][nArray[1]] = d;
                }
            });
            System.arraycopy(dArray2, 0, dArray, 0, fArray.length);
        }
    }

    public static float[][] multiplicationUTUH(float[][] fArray, float[][] fArray2) {
        assert (fArray.length > 0 && fArray.length == fArray[0].length);
        assert (fArray2.length > 0 && fArray2.length == fArray2[0].length);
        assert (fArray.length == fArray2.length);
        float[][] fArray3 = MatrixAlgebra.zeroUH(fArray.length);
        for (int i = 0; i < fArray3.length; ++i) {
            int n;
            for (int j = n = Math.max(0, i - 1); j < fArray3.length; ++j) {
                int n2;
                for (int k = n2 = i; k < Math.min(j + 2, fArray2.length); ++k) {
                    int n3 = Math.max(0, k - 1);
                    float[] fArray4 = fArray3[i];
                    int n4 = j - n;
                    fArray4[n4] = fArray4[n4] + fArray[i][k - n2] * fArray2[k][j - n3];
                }
            }
        }
        return fArray3;
    }

    public static float[][] multiplicationCUH(float[][] fArray, float[][] fArray2) {
        assert (fArray2.length > 0 && fArray2.length == fArray2[0].length);
        assert (fArray.length > 0 && fArray[0].length == fArray2.length);
        float[][] fArray3 = new float[fArray.length][fArray2.length];
        for (int i = 0; i < fArray.length; ++i) {
            assert (fArray[0].length == fArray[i].length);
            for (int j = 0; j < fArray2.length; ++j) {
                int n = Math.min(j + 2, fArray2.length);
                assert (fArray2[j].length == fArray2.length - Math.max(j - 1, 0));
                for (int k = 0; k < n; ++k) {
                    int n2 = Math.max(0, k - 1);
                    float[] fArray4 = fArray3[i];
                    int n3 = j;
                    fArray4[n3] = fArray4[n3] + fArray[i][k] * fArray2[k][j - n2];
                }
            }
        }
        return fArray3;
    }

    public static float[] multiplicationCV(float[][] fArray, float[] fArray2) {
        assert (fArray.length > 0 && fArray[0].length == fArray2.length);
        float[] fArray3 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            assert (fArray[0].length == fArray[i].length);
            double d = 0.0;
            for (int j = 0; j < fArray2.length; ++j) {
                d += (double)(fArray[i][j] * fArray2[j]);
            }
            fArray3[i] = (float)d;
        }
        return fArray3;
    }

    public static double[] multiplicationCV(double[][] dArray, float[] fArray) {
        assert (dArray.length > 0 && dArray[0].length == fArray.length);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            assert (dArray[0].length == dArray[i].length);
            double d = 0.0;
            for (int j = 0; j < fArray.length; ++j) {
                d += dArray[i][j] * (double)fArray[j];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    public static double[] multiplicationCV(double[][] dArray, double[] dArray2) {
        assert (dArray.length > 0 && dArray[0].length == dArray2.length);
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            assert (dArray[0].length == dArray[i].length);
            double d = 0.0;
            for (int j = 0; j < dArray2.length; ++j) {
                d += dArray[i][j] * dArray2[j];
            }
            dArray3[i] = d;
        }
        return dArray3;
    }

    public static float multiplicationVTV(float[] fArray, float[] fArray2) {
        assert (fArray.length == fArray2.length);
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i] * fArray2[i];
        }
        return f;
    }

    public static double multiplicationVTV(double[] dArray, double[] dArray2) {
        assert (dArray.length == dArray2.length);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double[] multiplicationSV(double d, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = d * dArray[i];
        }
        return dArray2;
    }

    public static float[][] identityC(int n) {
        assert (n > 0);
        float[][] fArray = new float[n][n];
        for (int i = 0; i < n; ++i) {
            fArray[i][i] = 1.0f;
        }
        return fArray;
    }

    public static double[][] identityCd(int n) {
        assert (n > 0);
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
        }
        return dArray;
    }

    public static float[][] identityUT(int n) {
        assert (n > 0);
        float[][] fArrayArray = new float[n][];
        for (int i = 0; i < n; ++i) {
            fArrayArray[i] = new float[n - i];
            fArrayArray[i][0] = 1.0f;
        }
        return fArrayArray;
    }

    public static float[][] zeroUT(int n) {
        assert (n > 0);
        float[][] fArrayArray = new float[n][];
        for (int i = 0; i < n; ++i) {
            fArrayArray[i] = new float[n - i];
        }
        return fArrayArray;
    }

    public static float[][] zeroUH(int n) {
        assert (n > 0);
        float[][] fArrayArray = new float[n][];
        fArrayArray[0] = new float[n];
        for (int i = 1; i < n; ++i) {
            fArrayArray[i] = new float[n - i + 1];
        }
        return fArrayArray;
    }

    public static float[][] identityUH(int n) {
        assert (n > 0);
        float[][] fArray = MatrixAlgebra.zeroUH(n);
        fArray[0][0] = 1.0f;
        for (int i = 1; i < n; ++i) {
            fArray[i][1] = 1.0f;
        }
        return fArray;
    }

    public static boolean compare(float[][] fArray, float[][] fArray2, float f) {
        assert (fArray.length == fArray2.length);
        for (int i = 0; i < fArray.length; ++i) {
            assert (fArray[i].length == fArray2[i].length);
            for (int j = 0; j < fArray[i].length; ++j) {
                if (!(Math.abs(fArray[i][j] - fArray2[i][j]) > f)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean compare(float[] fArray, float[] fArray2, float f) {
        assert (fArray.length == fArray2.length);
        for (int i = 0; i < fArray.length; ++i) {
            if (!(Math.abs(fArray[i] - fArray2[i]) > f)) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(double[] dArray, double[] dArray2, double d) {
        assert (dArray.length == dArray2.length);
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs(dArray[i] - dArray2[i]) > d)) continue;
            return false;
        }
        return true;
    }

    public static float[][] cutUHUT(float[][] fArray) {
        float[][] fArray2 = MatrixAlgebra.identityUT(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            assert (i != 0 ? fArray[i].length + i - 1 == fArray.length : fArray[i].length == fArray.length);
            fArray2[i] = new float[fArray.length - i];
            System.arraycopy(fArray[i], i == 0 ? 0 : 1, fArray2[i], 0, fArray.length - i);
        }
        return fArray2;
    }

    public static float[][] cutCUH(float[][] fArray) {
        assert (fArray.length > 0 && fArray[0].length == fArray.length);
        float[][] fArray2 = MatrixAlgebra.identityUH(fArray.length);
        fArray2[0] = new float[fArray.length];
        System.arraycopy(fArray[0], 0, fArray2[0], 0, fArray.length);
        for (int i = 1; i < fArray.length; ++i) {
            assert (fArray[i].length == fArray.length);
            fArray2[i] = new float[fArray.length - i + 1];
            System.arraycopy(fArray[i], i - 1, fArray2[i], 0, fArray2[i].length);
        }
        return fArray2;
    }

    public static float[][] copy(float[][] fArray) {
        float[][] fArrayArray = new float[fArray.length][];
        for (int i = 0; i < fArray.length; ++i) {
            fArrayArray[i] = new float[fArray[i].length];
            System.arraycopy(fArray[i], 0, fArrayArray[i], 0, fArray[i].length);
        }
        return fArrayArray;
    }

    public static double[] copyd(float[] fArray) {
        double[] dArray = new double[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            dArray[i] = fArray[i];
        }
        return dArray;
    }

    public static float[][] copyf(double[][] dArray) {
        float[][] fArrayArray = new float[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            fArrayArray[i] = new float[dArray[i].length];
            for (int j = 0; j < dArray[i].length; ++j) {
                fArrayArray[i][j] = (float)dArray[i][j];
            }
        }
        return fArrayArray;
    }

    public static float[][] add(float[][] fArray, float[][] fArray2) {
        float[][] fArrayArray = new float[fArray.length][];
        assert (fArray.length == fArray2.length);
        for (int i = 0; i < fArray.length; ++i) {
            assert (fArray[i].length == fArray2[i].length);
            fArrayArray[i] = new float[fArray[i].length];
            for (int j = 0; j < fArray[i].length; ++j) {
                fArrayArray[i][j] = fArray[i][j] + fArray2[i][j];
            }
        }
        return fArrayArray;
    }

    public static float[][] subtract(float[][] fArray, float[][] fArray2) {
        float[][] fArrayArray = new float[fArray.length][];
        assert (fArray.length == fArray2.length);
        for (int i = 0; i < fArray.length; ++i) {
            assert (fArray[i].length == fArray2[i].length);
            fArrayArray[i] = new float[fArray[i].length];
            for (int j = 0; j < fArray[i].length; ++j) {
                fArrayArray[i][j] = fArray[i][j] - fArray2[i][j];
            }
        }
        return fArrayArray;
    }

    public static double[][] subtract(double[][] dArray, double[][] dArray2) {
        double[][] dArrayArray = new double[dArray.length][];
        assert (dArray.length == dArray2.length);
        for (int i = 0; i < dArray.length; ++i) {
            assert (dArray[i].length == dArray2[i].length);
            dArrayArray[i] = new double[dArray[i].length];
            for (int j = 0; j < dArray[i].length; ++j) {
                dArrayArray[i][j] = dArray[i][j] - dArray2[i][j];
            }
        }
        return dArrayArray;
    }

    public static float[] subtract(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[fArray.length];
        assert (fArray.length == fArray2.length);
        for (int i = 0; i < fArray.length; ++i) {
            fArray3[i] = fArray[i] - fArray2[i];
        }
        return fArray3;
    }

    public static double[] subtract(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        assert (dArray.length == dArray2.length);
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
        return dArray3;
    }

    public static double[] subtract(float[] fArray, double[] dArray) {
        double[] dArray2 = new double[fArray.length];
        assert (fArray.length == dArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            dArray2[i] = (double)fArray[i] - dArray[i];
        }
        return dArray2;
    }

    public static float[][] toComplete(float[][] fArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < fArray.length; ++n) {
            n2 = Math.max(n2, fArray[n].length);
        }
        float[][] fArray2 = new float[fArray.length][n2];
        for (n = 0; n < fArray.length; ++n) {
            for (int i = 0; i < fArray[n].length; ++i) {
                fArray2[n][i + n2 - fArray[n].length] = fArray[n][i];
            }
        }
        return fArray2;
    }

    public static float[][] toCompleteUTmirror(float[][] fArray) {
        float[][] fArray2 = new float[fArray.length][fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray.length; ++j) {
                fArray2[i][j] = j >= i ? fArray[i][j - i] : fArray[j][i - j];
            }
        }
        return fArray2;
    }

    public static float[][] padIdentityBR(float[][] fArray, int n) {
        float[][] fArray2 = MatrixAlgebra.identityC(fArray.length + n);
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray.length; ++j) {
                fArray2[i][j] = fArray[i][j];
            }
        }
        return fArray2;
    }

    public static float[][] padIdentityTL(float[][] fArray, int n) {
        float[][] fArray2 = MatrixAlgebra.identityC(fArray.length + n);
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray.length; ++j) {
                fArray2[i + n][j + n] = fArray[i][j];
            }
        }
        return fArray2;
    }

    public static float[][] relativeError(float[][] fArray, float[][] fArray2) {
        float[][] fArrayArray = new float[fArray.length][];
        assert (fArray.length == fArray2.length);
        for (int i = 0; i < fArray.length; ++i) {
            assert (fArray[i].length == fArray2[i].length);
            fArrayArray[i] = new float[fArray[i].length];
            for (int j = 0; j < fArray[i].length; ++j) {
                fArrayArray[i][j] = Math.abs((fArray[i][j] - fArray2[i][j]) / fArray2[i][j]);
            }
        }
        return fArrayArray;
    }

    public static float squaredValueAddition(float[][] fArray) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                f += fArray[i][j] * fArray[i][j];
            }
        }
        return f;
    }

    public static double squaredValueAddition(double[][] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                d += dArray[i][j] * dArray[i][j];
            }
        }
        return d;
    }

    public static float squaredValueAddition(float[] fArray) {
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            d += (double)(fArray[i] * fArray[i]);
        }
        return (float)d;
    }

    public static double squaredValueAddition(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray[i];
        }
        return d;
    }

    public static float peakAbsoluteValue(float[][] fArray) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                f = Math.max(f, Math.abs(fArray[i][j]));
            }
        }
        return f;
    }

    public static float[] normalizeV(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            d += (double)fArray[i] * (double)fArray[i];
        }
        assert (d > 1.0E-6);
        double d2 = Math.sqrt(Math.abs(1.0 / d));
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = (float)((double)fArray[i] * d2);
        }
        return fArray2;
    }

    public static double[] normalizeV(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray[i];
        }
        assert (d > (double)5.0E-8f);
        double d2 = Math.sqrt(Math.abs(d));
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] / d2;
        }
        return dArray2;
    }

    public static float determinant(float[][] fArray) {
        return MatrixAlgebra.determinant(fArray, 1);
    }

    public static float determinant(float[][] fArray, int n) {
        assert (fArray.length > 0 && fArray[0].length == fArray.length);
        float[][] fArray2 = MatrixAlgebra.copy(fArray);
        int n2 = fArray.length;
        double d = 0.0;
        double d2 = 1.0;
        for (int i = 0; i < n2; ++i) {
            int n3;
            assert (fArray[i].length == n2);
            if (Math.abs(fArray2[i][i]) < Float.MIN_VALUE) {
                n3 = 1;
                while (i + n3 < n2 && Math.abs(fArray2[i + n3][i]) < Float.MIN_VALUE) {
                    ++n3;
                }
                if (i + n3 >= n2) {
                    return 0.0f;
                }
                float[] fArray3 = fArray2[i];
                fArray2[i] = fArray2[i + n3];
                fArray2[i + n3] = fArray3;
            }
            n3 = i + 1;
            while (n3 < n2) {
                float[] fArray4 = fArray2[i];
                int n4 = n3++;
                fArray4[n4] = fArray4[n4] / fArray2[i][i];
            }
            d += Math.log(Math.abs(fArray2[i][i]));
            d2 *= (double)Math.copySign(1.0f, fArray2[i][i]);
            fArray2[i][i] = 1.0f;
            for (n3 = i + 1; n3 < n2; ++n3) {
                for (int j = i + 1; j < n2; ++j) {
                    float[] fArray5 = fArray2[n3];
                    int n5 = j;
                    fArray5[n5] = fArray5[n5] - fArray2[n3][i] * fArray2[i][j];
                }
                fArray2[n3][i] = 0.0f;
            }
        }
        return (float)Math.copySign(Math.exp(d / (double)n), d2);
    }

    public static float[][] inverseC(float[][] fArray) {
        assert (fArray.length > 0 && fArray.length == fArray[0].length);
        float[][] fArray2 = MatrixAlgebra.copy(fArray);
        float[][] fArray3 = MatrixAlgebra.identityC(fArray.length);
        for (int i = 0; i < fArray2.length; ++i) {
            int n;
            float f;
            float f2 = Float.NEGATIVE_INFINITY;
            int n2 = -1;
            for (int j = i; j < fArray2.length; ++j) {
                if (!(f2 <= Math.abs(fArray2[j][i]))) continue;
                f2 = Math.abs(fArray2[j][i]);
                n2 = j;
            }
            assert (n2 >= 0);
            float[] fArray4 = fArray2[i];
            fArray2[i] = fArray2[n2];
            fArray2[n2] = fArray4;
            fArray4 = fArray3[i];
            fArray3[i] = fArray3[n2];
            fArray3[n2] = fArray4;
            float f3 = fArray2[i][i];
            assert (Math.abs(f3) > 1.0E-7f);
            int n3 = i;
            while (n3 < fArray2.length) {
                float[] fArray5 = fArray2[i];
                int n4 = n3++;
                fArray5[n4] = fArray5[n4] / f3;
            }
            n3 = 0;
            while (n3 < fArray2.length) {
                float[] fArray6 = fArray3[i];
                int n5 = n3++;
                fArray6[n5] = fArray6[n5] / f3;
            }
            for (n3 = 0; n3 < i; ++n3) {
                f = fArray2[n3][i];
                for (n = i + 1; n < fArray2.length; ++n) {
                    float[] fArray7 = fArray2[n3];
                    int n6 = n;
                    fArray7[n6] = fArray7[n6] - f * fArray2[i][n];
                }
                for (n = 0; n < fArray2.length; ++n) {
                    float[] fArray8 = fArray3[n3];
                    int n7 = n;
                    fArray8[n7] = fArray8[n7] - f * fArray3[i][n];
                }
            }
            for (n3 = i + 1; n3 < fArray2.length; ++n3) {
                f = fArray2[n3][i];
                for (n = i + 1; n < fArray2.length; ++n) {
                    float[] fArray9 = fArray2[n3];
                    int n8 = n;
                    fArray9[n8] = fArray9[n8] - f * fArray2[i][n];
                }
                for (n = 0; n < fArray2.length; ++n) {
                    float[] fArray10 = fArray3[n3];
                    int n9 = n;
                    fArray10[n9] = fArray10[n9] - f * fArray3[i][n];
                }
            }
        }
        return fArray3;
    }

    public static float[] matrixDiagonal(float[][] fArray) {
        assert (fArray.length > 0 && fArray.length == fArray[0].length);
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray[i][i];
        }
        return fArray2;
    }

    public static void printMatrix(float[][] fArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < fArray.length; ++n) {
            n2 = Math.max(n2, fArray[n].length);
        }
        for (n = 0; n < fArray.length; ++n) {
            int n3;
            for (n3 = 0; n3 < n2 - fArray[n].length; ++n3) {
                System.out.format("[%10.5g] \t", Float.valueOf(0.0f));
            }
            for (n3 = 0; n3 < fArray[n].length; ++n3) {
                System.out.format("% 11.5g \t", Float.valueOf(fArray[n][n3]));
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void printMatrix(long[][] lArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < lArray.length; ++n) {
            n2 = Math.max(n2, lArray[n].length);
        }
        for (n = 0; n < lArray.length; ++n) {
            int n3;
            for (n3 = 0; n3 < n2 - lArray[n].length; ++n3) {
                System.out.format("[%d] \t", 0);
            }
            for (n3 = 0; n3 < lArray[n].length; ++n3) {
                System.out.format("%d \t", lArray[n][n3]);
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void printMatrix(int[][] nArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 = Math.max(n2, nArray[n].length);
        }
        for (n = 0; n < nArray.length; ++n) {
            int n3;
            for (n3 = 0; n3 < n2 - nArray[n].length; ++n3) {
                System.out.format("[%d] \t", 0);
            }
            for (n3 = 0; n3 < nArray[n].length; ++n3) {
                System.out.format("%d \t", nArray[n][n3]);
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void printVector(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            System.out.format("% 11.5g \t", Float.valueOf(fArray[i]));
        }
        System.out.println();
    }

    public static void printVector(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            System.out.format("% 11.5g \t", dArray[i]);
        }
        System.out.println();
    }

    public static void printVector(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            System.out.format(" %d", nArray[i]);
        }
        System.out.println();
    }

    public static void printVector(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            System.out.format(" %d", lArray[i]);
        }
        System.out.println();
    }
}

