/*
 * Decompiled with CFR 0.152.
 */
package GiciMatrix;

import GiciAnalysis.Epsilon;
import GiciMatrix.MatrixAlgebra;

public class Tridiagonalize {
    private float[][] a;
    private float[][] t;
    private float[][] u;
    private boolean ran = false;

    public Tridiagonalize(float[][] fArray) {
        assert (fArray.length > 0 && fArray.length == fArray[0].length);
        assert (fArray[fArray.length - 1].length == 1);
        this.a = MatrixAlgebra.toComplete(fArray);
        for (int i = 0; i < this.a.length; ++i) {
            for (int j = 0; j < i; ++j) {
                this.a[i][j] = this.a[j][i];
            }
        }
        this.t = MatrixAlgebra.identityUH(this.a.length);
        this.u = MatrixAlgebra.identityC(this.a.length);
    }

    private float[][] pap(float[][] fArray, int n, float[][] fArray2) {
        float[][] fArray3 = MatrixAlgebra.padIdentityTL(fArray2, n);
        return MatrixAlgebra.multiplicationCC(fArray3, MatrixAlgebra.multiplicationCC(fArray, fArray3));
    }

    private float[][] buildP(float[] fArray) {
        float[][] fArray2 = new float[1][fArray.length];
        float[][] fArray3 = new float[fArray.length][1];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[0][i] = fArray[i];
            fArray3[i][0] = fArray[i];
        }
        float[][] fArray4 = MatrixAlgebra.multiplicationCC(fArray3, fArray2);
        for (int i = 0; i < fArray.length; ++i) {
            int n = 0;
            while (n < fArray.length) {
                float[] fArray5 = fArray4[i];
                int n2 = n++;
                fArray5[n2] = fArray5[n2] * 2.0f;
            }
        }
        return MatrixAlgebra.subtract(MatrixAlgebra.identityC(fArray.length), fArray4);
    }

    public final void run() {
        this.ran = true;
        for (int i = 0; i < this.a.length - 1; ++i) {
            int n;
            float f = 0.0f;
            float[] fArray = new float[this.a[i].length - 1 - i];
            for (n = i + 1; n < this.a[i].length; ++n) {
                f += this.a[i][n] * this.a[i][n];
                fArray[n - (i + 1)] = this.a[i][n];
            }
            if (Math.abs(f) < Float.MIN_VALUE) continue;
            if (Math.signum(fArray[0] * (f = (float)Math.sqrt(f))) > 0.0f) {
                f = -f;
            }
            fArray[0] = fArray[0] - f;
            float f2 = 0.0f;
            for (n = 0; n < fArray.length; ++n) {
                f2 += fArray[n] * fArray[n];
            }
            assert (f2 > Epsilon.getFloatEpsilon());
            f2 = (float)(1.0 / Math.sqrt(f2));
            n = 0;
            while (n < fArray.length) {
                int n2 = n++;
                fArray[n2] = fArray[n2] * f2;
            }
            float[][] fArray2 = this.buildP(fArray);
            this.a = this.pap(this.a, i + 1, fArray2);
            this.u = MatrixAlgebra.subMultiplicationCC(fArray2, this.u);
        }
        this.u = MatrixAlgebra.transposeC(this.u);
        this.t = MatrixAlgebra.cutCUH(this.a);
    }

    public final float[][] getT() {
        assert (this.ran);
        return this.t;
    }

    public final float[][] getU() {
        assert (this.ran);
        return this.u;
    }
}

