/*
 * Decompiled with CFR 0.152.
 */
package GiciParallel;

import GiciParallel.BatchExecutorService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;

public final class ParallelMap {
    private static final int DEFAULT_CONCURRENCY = Runtime.getRuntime().availableProcessors();

    private ParallelMap() {
    }

    public static <E> void map(final MapIterator<E> mapIterator, final MapInterface<E> mapInterface, final int n) {
        BatchExecutorService<Object> batchExecutorService = new BatchExecutorService<Object>();
        int n2 = 0;
        while (n2 < n) {
            final int n3 = n2++;
            batchExecutorService.submitAndRememberFuture(new Callable<Object>(){

                @Override
                public Object call() {
                    Iterator iterator = mapIterator.getPackageIterator(n3, n);
                    while (iterator.hasNext()) {
                        mapInterface.apply(iterator.next());
                    }
                    return null;
                }
            });
        }
        batchExecutorService.awaitAllLocalTasks();
    }

    public static <E> void map(MapIterator<E> mapIterator, MapInterface<E> mapInterface) {
        ParallelMap.map(mapIterator, mapInterface, DEFAULT_CONCURRENCY);
    }

    public static final class UpperDiagonalIterator
    implements MapIterator<int[]> {
        private final int matrixSize;

        public UpperDiagonalIterator(int n) {
            this.matrixSize = n;
        }

        private int[] startPosition(int n, int n2) {
            int[] nArray = new int[2];
            if (n == n2) {
                nArray[0] = this.matrixSize;
                nArray[1] = this.matrixSize;
                return nArray;
            }
            int n3 = this.matrixSize;
            int n4 = 2 * n3 + 1;
            int n5 = (1 + n3) * n3 / 2 * n / n2;
            int n6 = (-n4 + (int)Math.sqrt(n4 * n4 + 8 * n5)) / 2 - 3;
            while (n5 >= (n4 * n6 - n6 * n6) / 2) {
                ++n6;
            }
            nArray[0] = --n6;
            nArray[1] = n6 + n5 - (n4 * n6 - n6 * n6) / 2;
            return nArray;
        }

        @Override
        public Iterator<int[]> getPackageIterator(final int n, final int n2) {
            return new Iterator<int[]>(){
                private int[] position;
                private int[] endPosition;
                {
                    this.position = this.startPosition(n, n2);
                    this.endPosition = this.startPosition(n + 1, n2);
                }

                @Override
                public boolean hasNext() {
                    return this.position[0] != this.endPosition[0] || this.position[1] != this.endPosition[1];
                }

                @Override
                public int[] next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int[] nArray = Arrays.copyOf(this.position, this.position.length);
                    this.position[1] = this.position[1] + 1;
                    if (this.position[1] >= matrixSize) {
                        this.position[0] = this.position[0] + 1;
                        this.position[1] = this.position[0];
                    }
                    return nArray;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static final class MultidimensionalIterator
    implements MapIterator<int[]> {
        private final int[] dimensionSizes;
        private final int elementCount;

        public MultidimensionalIterator(int ... nArray) {
            this.dimensionSizes = nArray;
            int n = 1;
            double d = 1.0;
            for (int n2 : this.dimensionSizes) {
                n *= n2;
                d *= (double)n2;
            }
            assert (d < 2.147483647E9);
            this.elementCount = n;
        }

        @Override
        public Iterator<int[]> getPackageIterator(int n, int n2) {
            final int[] nArray = new int[this.dimensionSizes.length];
            final int n3 = this.elementCount * n / n2;
            final int n4 = this.elementCount * (n + 1) / n2;
            int n5 = n3;
            for (int i = nArray.length - 1; i > 0; --i) {
                nArray[i] = n5 % this.dimensionSizes[i];
                n5 /= this.dimensionSizes[i];
            }
            nArray[0] = n5;
            if (this.dimensionSizes.length != 2) {
                return new Iterator<int[]>(){
                    private int localFromIndex;
                    private final int localToIndex;
                    {
                        this.localFromIndex = n3;
                        this.localToIndex = n4;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.localFromIndex < this.localToIndex;
                    }

                    @Override
                    public int[] next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
                        for (int i = nArray.length - 1; i >= 0; --i) {
                            nArray[i] = (nArray[i] + 1) % dimensionSizes[i];
                            if (nArray[i] != 0) break;
                        }
                        ++this.localFromIndex;
                        return nArray2;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            nArray[1] = nArray[1] - 1;
            if (nArray[1] == -1) {
                nArray[0] = nArray[0] - 1;
            }
            return new Iterator<int[]>(){
                private int localFromIndex;
                private final int localToIndex;
                final int[] nextValue;
                final int modulo;
                {
                    this.localFromIndex = n3;
                    this.localToIndex = n4;
                    this.nextValue = nArray;
                    this.modulo = dimensionSizes[1];
                }

                @Override
                public boolean hasNext() {
                    return this.localFromIndex < this.localToIndex;
                }

                @Override
                public int[] next() {
                    this.nextValue[1] = (this.nextValue[1] + 1) % this.modulo;
                    if (this.nextValue[1] == 0) {
                        this.nextValue[0] = this.nextValue[0] + 1;
                    }
                    ++this.localFromIndex;
                    int[] nArray2 = nArray;
                    return nArray2;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static final class ListIterator
    implements MapIterator<Integer> {
        private final List<Integer> memberList;

        public ListIterator(List<Integer> list) {
            this.memberList = list;
        }

        public ListIterator(Set<Integer> set) {
            this.memberList = new ArrayList<Integer>(set);
        }

        @Override
        public Iterator<Integer> getPackageIterator(int n, int n2) {
            int n3 = this.memberList.size() * n / n2;
            int n4 = this.memberList.size() * (n + 1) / n2;
            List<Integer> list = this.memberList.subList(n3, n4);
            return list.iterator();
        }
    }

    public static interface MapIterator<E> {
        public Iterator<E> getPackageIterator(int var1, int var2);
    }

    public static interface MapInterface<E> {
        public void apply(E var1);
    }
}

