/*
 * Decompiled with CFR 0.152.
 */
package GiciStream;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends FilterInputStream {
    private static final int BITS_PER_BYTE = 8;
    private static final int[] bmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private int buffer = 0;
    private int bitCount = 0;

    public BitInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read(int n) throws IOException {
        if (n > 32 || n < 0) {
            throw new RuntimeException("BitInputStream can only return from 0 to 32 bits.");
        }
        int n2 = 0;
        while (n > this.bitCount) {
            n2 |= this.buffer << n - this.bitCount;
            n -= this.bitCount;
            this.buffer = this.in.read();
            if (this.buffer == -1) {
                throw new EOFException();
            }
            this.bitCount = 8;
        }
        if (n > 0) {
            n2 |= this.buffer >>> this.bitCount - n;
            this.buffer &= bmask[this.bitCount - n];
            this.bitCount -= n;
        }
        return n2;
    }

    @Override
    public int read() throws IOException {
        return this.read(8);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = n; n3 < n + n2; ++n3) {
            try {
                byArray[n3] = (byte)this.read();
                continue;
            }
            catch (EOFException eOFException) {
                if (n3 != n) break;
                return -1;
            }
        }
        return n3 - n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }
}

