/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;

public class CoefficientsApproximation {
    float[][][] imageSamples = null;
    int[] approximationTypes = null;
    boolean parametersSet = false;

    public CoefficientsApproximation(float[][][] fArray) {
        this.imageSamples = fArray;
    }

    public void setParameters(int[] nArray) {
        this.approximationTypes = nArray != null ? nArray : new int[this.imageSamples.length];
        this.parametersSet = true;
    }

    public float[][][] run() throws ErrorException {
        if (!this.parametersSet) {
            throw new ErrorException("Coefficent approximation cannot run if parameters are not set.");
        }
        int n = this.imageSamples.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = this.imageSamples[i].length;
            int n5 = this.imageSamples[i][0].length;
            if (this.approximationTypes[i] == 0) {
                for (n3 = 0; n3 < n4; ++n3) {
                    for (n2 = 0; n2 < n5; ++n2) {
                        this.imageSamples[i][n3][n2] = (int)this.imageSamples[i][n3][n2];
                    }
                }
                continue;
            }
            if (this.approximationTypes[i] == 1) {
                for (n3 = 0; n3 < n4; ++n3) {
                    for (n2 = 0; n2 < n5; ++n2) {
                        this.imageSamples[i][n3][n2] = Math.round(this.imageSamples[i][n3][n2]);
                    }
                }
                continue;
            }
            if (this.approximationTypes[i] == 2) {
                for (n3 = 0; n3 < n4; ++n3) {
                    for (n2 = 0; n2 < n5; ++n2) {
                        this.imageSamples[i][n3][n2] = (float)Math.floor(this.imageSamples[i][n3][n2]);
                    }
                }
                continue;
            }
            if (this.approximationTypes[i] != 3) continue;
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    this.imageSamples[i][n3][n2] = (float)Math.ceil(this.imageSamples[i][n3][n2]);
                }
            }
        }
        return this.imageSamples;
    }

    public static boolean TERsetApproximationNeed(int[] nArray) {
        boolean bl = false;
        if (nArray != null) {
            for (int i = 0; i < nArray.length && !bl; ++i) {
                if (nArray[i] <= 0) continue;
                bl = true;
            }
        }
        return bl;
    }
}

