/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciAnalysis.ImageStatistical;
import GiciException.ErrorException;

public class CropChannels {
    float[][][] imageSamples = null;
    boolean parametersSet = false;
    int cropType;
    boolean[] removeBand = null;

    public CropChannels(float[][][] fArray) {
        this.imageSamples = fArray;
    }

    public void setParameters(int n) {
        this.cropType = n;
        this.parametersSet = true;
    }

    public float[][][] run() throws ErrorException {
        if (!this.parametersSet) {
            throw new ErrorException("Crop channels cannot run if parameters are not set.");
        }
        Object object = null;
        if (this.cropType == 1) {
            int n;
            ImageStatistical imageStatistical = new ImageStatistical(this.imageSamples);
            double[] dArray = imageStatistical.getEnergy();
            int n2 = 0;
            this.removeBand = new boolean[dArray.length];
            for (n = 0; n < dArray.length; ++n) {
                if (dArray[n] > 0.0) {
                    this.removeBand[n] = false;
                    ++n2;
                    continue;
                }
                this.removeBand[n] = true;
            }
            object = new float[n2][][];
            n2 = 0;
            for (n = 0; n < dArray.length && n2 < ((float[][][])object).length; ++n) {
                if (this.removeBand[n]) continue;
                int n3 = this.imageSamples[n].length;
                int n4 = this.imageSamples[n][0].length;
                object[n2] = new float[n3][n4];
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        object[n2][i][j] = this.imageSamples[n][i][j];
                    }
                }
                ++n2;
            }
            this.imageSamples = null;
        } else {
            object = this.imageSamples;
        }
        return object;
    }

    public boolean[] getRemoveBand() {
        return this.removeBand;
    }
}

