/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;

public class ForwardDWTCore {
    float[][][] imageSamples = null;
    int WTTypes;
    int WTAxis;
    int WTZRegionStart;
    int WTZRegionEnd;
    int WTYRegionStart;
    int WTYRegionEnd;
    int WTXRegionStart;
    int WTXRegionEnd;
    boolean parametersSet = false;

    public ForwardDWTCore(float[][][] fArray) {
        this.imageSamples = fArray;
    }

    public void setParameters(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.parametersSet = true;
        this.WTTypes = n;
        this.WTAxis = n2;
        this.WTZRegionStart = n3;
        this.WTZRegionEnd = n4;
        this.WTYRegionStart = n5;
        this.WTYRegionEnd = n6;
        this.WTXRegionStart = n7;
        this.WTXRegionEnd = n8;
    }

    public void setImageSamples(float[][][] fArray) {
        this.imageSamples = fArray;
    }

    public float[][][] getImageSamples() {
        return this.imageSamples;
    }

    public void run() throws ErrorException {
        if (!this.parametersSet) {
            throw new ErrorException("Parameters not set.");
        }
        if (this.WTTypes != 0) {
            int n = this.WTZRegionEnd - this.WTZRegionStart + 1;
            int n2 = this.WTYRegionEnd - this.WTYRegionStart + 1;
            int n3 = this.WTXRegionEnd - this.WTXRegionStart + 1;
            switch (this.WTAxis) {
                case 0: {
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            int n4;
                            float[] fArray = new float[n3];
                            for (n4 = 0; n4 < n3; ++n4) {
                                fArray[n4 + this.WTXRegionStart] = this.imageSamples[i + this.WTZRegionStart][j + this.WTYRegionStart][n4 + this.WTXRegionStart];
                            }
                            fArray = this.filtering(fArray, this.WTTypes, this.WTXRegionStart);
                            for (n4 = 0; n4 < n3; ++n4) {
                                this.imageSamples[i + this.WTZRegionStart][j + this.WTYRegionStart][n4 + this.WTXRegionStart] = fArray[n4 + this.WTXRegionStart];
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            int n5;
                            float[] fArray = new float[n2];
                            for (n5 = 0; n5 < n2; ++n5) {
                                fArray[n5 + this.WTYRegionStart] = this.imageSamples[i + this.WTZRegionStart][n5 + this.WTYRegionStart][j + this.WTXRegionStart];
                            }
                            fArray = this.filtering(fArray, this.WTTypes, this.WTYRegionStart);
                            for (n5 = 0; n5 < n2; ++n5) {
                                this.imageSamples[i + this.WTZRegionStart][n5 + this.WTYRegionStart][j + this.WTXRegionStart] = fArray[n5 + this.WTYRegionStart];
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            int n6;
                            float[] fArray = new float[n];
                            for (n6 = 0; n6 < n; ++n6) {
                                fArray[n6 + this.WTZRegionStart] = this.imageSamples[n6 + this.WTZRegionStart][i + this.WTYRegionStart][j + this.WTXRegionStart];
                            }
                            fArray = this.filtering(fArray, this.WTTypes, this.WTZRegionStart);
                            for (n6 = 0; n6 < n; ++n6) {
                                this.imageSamples[n6 + this.WTZRegionStart][i + this.WTYRegionStart][j + this.WTXRegionStart] = fArray[n6 + this.WTZRegionStart];
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new ErrorException("Unimplemented Axis");
                }
            }
        }
        this.parametersSet = false;
    }

    private float[] filtering(float[] fArray, int n, int n2) throws ErrorException {
        float[] fArray2 = null;
        float[] fArray3 = null;
        if (fArray.length == 1 && n != 4) {
            fArray2 = fArray;
        } else {
            float[] fArray4 = null;
            fArray4 = n == 4 && fArray.length < 6 ? this.coefExpansion(fArray) : fArray;
            fArray3 = fArray4.length % 2 == 0 && n2 % 2 == 0 ? this.evenEvenFiltering(fArray4, n) : (fArray4.length % 2 == 0 && n2 % 2 == 1 ? this.evenOddFiltering(fArray4, n) : (fArray4.length % 2 == 1 && n2 % 2 == 0 ? this.oddEvenFiltering(fArray4, n) : (fArray4.length % 2 == 1 && n2 % 2 == 1 ? this.oddOddFiltering(fArray4, n) : fArray4)));
            fArray2 = n == 4 && fArray.length < 6 ? this.coefUnexpansion(fArray3, fArray.length) : fArray3;
        }
        return fArray2;
    }

    private float[] evenEvenFiltering(float[] fArray, int n) throws ErrorException {
        int n2;
        int n3 = fArray.length;
        switch (n) {
            case 1: {
                for (n2 = 1; n2 < n3 - 1; n2 += 2) {
                    fArray[n2] = fArray[n2] - (float)Math.floor((fArray[n2 - 1] + fArray[n2 + 1]) / 2.0f);
                }
                fArray[n3 - 1] = fArray[n3 - 1] - (float)Math.floor((fArray[n3 - 2] + fArray[n3 - 2]) / 2.0f);
                fArray[0] = fArray[0] + (float)Math.floor((fArray[1] + fArray[1] + 2.0f) / 4.0f);
                for (n2 = 2; n2 < n3 - 1; n2 += 2) {
                    fArray[n2] = fArray[n2] + (float)Math.floor((fArray[n2 - 1] + fArray[n2 + 1] + 2.0f) / 4.0f);
                }
                break;
            }
            case 2: 
            case 3: {
                int n4;
                float f;
                float f2;
                if (n == 2) {
                    f2 = 1.2301741f;
                    f = 1.0f / f2;
                } else {
                    f = 1.1496044f;
                    f2 = -1.0f / f;
                }
                for (n4 = 1; n4 < n3 - 2; n4 += 2) {
                    fArray[n4] = fArray[n4] + -1.5861343f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                fArray[n3 - 1] = fArray[n3 - 1] + -1.5861343f * (fArray[n3 - 2] + fArray[n3 - 2]);
                fArray[0] = fArray[0] + -0.052980117f * (fArray[1] + fArray[1]);
                for (n4 = 2; n4 < n3; n4 += 2) {
                    fArray[n4] = fArray[n4] + -0.052980117f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                for (n4 = 1; n4 < n3 - 2; n4 += 2) {
                    fArray[n4] = fArray[n4] + 0.8829111f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                fArray[n3 - 1] = fArray[n3 - 1] + 0.8829111f * (fArray[n3 - 2] + fArray[n3 - 2]);
                fArray[0] = fArray[0] + 0.44350687f * (fArray[1] + fArray[1]);
                for (n4 = 2; n4 < n3; n4 += 2) {
                    fArray[n4] = fArray[n4] + 0.44350687f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                for (n4 = 0; n4 < n3; n4 += 2) {
                    fArray[n4] = fArray[n4] * f;
                    fArray[n4 + 1] = fArray[n4 + 1] * f2;
                }
                break;
            }
            case 4: {
                if (n3 >= 6) {
                    int n5;
                    fArray[1] = fArray[1] - (float)Math.floor(0.5625f * (fArray[0] + fArray[2]) - 0.0625f * (fArray[2] + fArray[4]) + 0.5f);
                    for (n5 = 3; n5 < n3 - 3; n5 += 2) {
                        fArray[n5] = fArray[n5] - (float)Math.floor(0.5625f * (fArray[n5 - 1] + fArray[n5 + 1]) - 0.0625f * (fArray[n5 - 3] + fArray[n5 + 3]) + 0.5f);
                    }
                    fArray[n3 - 3] = fArray[n3 - 3] - (float)Math.floor(0.5625f * (fArray[n3 - 4] + fArray[n3 - 2]) - 0.0625f * (fArray[n3 - 6] + fArray[n3 - 2]) + 0.5f);
                    fArray[n3 - 1] = fArray[n3 - 1] - (float)Math.floor(0.5625f * (fArray[n3 - 2] + fArray[n3 - 2]) - 0.0625f * (fArray[n3 - 4] + fArray[n3 - 4]) + 0.5f);
                    fArray[0] = fArray[0] - (float)Math.floor(-0.25f * (fArray[1] + fArray[1]) + 0.5f);
                    for (n5 = 2; n5 < n3; n5 += 2) {
                        fArray[n5] = fArray[n5] - (float)Math.floor(-0.25f * (fArray[n5 - 1] + fArray[n5 + 1]) + 0.5f);
                    }
                    break;
                }
                throw new ErrorException("Size should be greater or equal than 6 in order to perform 9/7M");
            }
            case 7: {
                float f = 0.0f;
                float f3 = 0.0f;
                float f4 = (float)Math.sqrt(2.0);
                for (int i = 0; i < n3; i += 2) {
                    f = (fArray[i] + fArray[i + 1]) / 2.0f;
                    f3 = (fArray[i] - fArray[i + 1]) / 2.0f;
                    fArray[i] = f / f4;
                    fArray[i + 1] = f3 / f4;
                }
                break;
            }
            case 8: {
                float f = 0.0f;
                for (int i = 0; i < n3; i += 2) {
                    f = fArray[i] - fArray[i + 1];
                    fArray[i] = fArray[i + 1] + (float)Math.floor(f / 2.0f);
                    fArray[i + 1] = f;
                }
                break;
            }
            default: {
                throw new ErrorException("Unrecognized wavelet transform type.");
            }
        }
        n2 = n3 / 2;
        float[] fArray2 = new float[n3];
        for (int i = 0; i < n2; ++i) {
            fArray2[i] = fArray[2 * i];
            fArray2[i + n2] = fArray[2 * i + 1];
        }
        return fArray2;
    }

    private float[] evenOddFiltering(float[] fArray, int n) throws ErrorException {
        int n2;
        int n3 = fArray.length;
        switch (n) {
            case 1: {
                fArray[0] = fArray[0] - (float)Math.floor((fArray[1] + fArray[1]) / 2.0f);
                for (n2 = 2; n2 < n3 - 1; n2 += 2) {
                    fArray[n2] = fArray[n2] - (float)Math.floor((fArray[n2 - 1] + fArray[n2 + 1]) / 2.0f);
                }
                fArray[n3 - 1] = fArray[n3 - 1] + (float)Math.floor((fArray[n3 - 2] + fArray[n3 - 2] + 2.0f) / 4.0f);
                for (n2 = 1; n2 < n3 - 1; n2 += 2) {
                    fArray[n2] = fArray[n2] + (float)Math.floor((fArray[n2 - 1] + fArray[n2 + 1] + 2.0f) / 4.0f);
                }
                break;
            }
            case 2: 
            case 3: {
                int n4;
                float f;
                float f2;
                if (n == 2) {
                    f2 = 1.2301741f;
                    f = 1.0f / f2;
                } else {
                    f = 1.1496044f;
                    f2 = -1.0f / f;
                }
                fArray[0] = fArray[0] + -1.5861343f * (fArray[1] + fArray[1]);
                for (n4 = 2; n4 < n3 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] + -1.5861343f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                for (n4 = 1; n4 < n3 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] + -0.052980117f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                fArray[n3 - 1] = fArray[n3 - 1] + -0.052980117f * (fArray[n3 - 2] + fArray[n3 - 2]);
                fArray[0] = fArray[0] + 0.8829111f * (fArray[1] + fArray[1]);
                for (n4 = 2; n4 < n3 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] + 0.8829111f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                fArray[n3 - 1] = fArray[n3 - 1] + 0.44350687f * (fArray[n3 - 2] + fArray[n3 - 2]);
                for (n4 = 1; n4 < n3 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] + 0.44350687f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                for (n4 = 0; n4 < n3; n4 += 2) {
                    fArray[n4] = fArray[n4] * f2;
                    fArray[n4 + 1] = fArray[n4 + 1] * f;
                }
                break;
            }
            case 4: {
                if (n3 >= 6) {
                    int n5;
                    fArray[1] = fArray[1] - (float)Math.floor(0.5625f * (fArray[0] + fArray[2]) - 0.0625f * (fArray[2] + fArray[4]) + 0.5f);
                    for (n5 = 3; n5 < n3 - 3; n5 += 2) {
                        fArray[n5] = fArray[n5] - (float)Math.floor(0.5625f * (fArray[n5 - 1] + fArray[n5 + 1]) - 0.0625f * (fArray[n5 - 3] + fArray[n5 + 3]) + 0.5f);
                    }
                    fArray[n3 - 3] = fArray[n3 - 3] - (float)Math.floor(0.5625f * (fArray[n3 - 4] + fArray[n3 - 2]) - 0.0625f * (fArray[n3 - 6] + fArray[n3 - 2]) + 0.5f);
                    fArray[n3 - 1] = fArray[n3 - 1] - (float)Math.floor(0.5625f * (fArray[n3 - 2] + fArray[n3 - 2]) - 0.0625f * (fArray[n3 - 4] + fArray[n3 - 4]) + 0.5f);
                    fArray[0] = fArray[0] - (float)Math.floor(-0.25f * (fArray[1] + fArray[1]) + 0.5f);
                    for (n5 = 2; n5 < n3; n5 += 2) {
                        fArray[n5] = fArray[n5] - (float)Math.floor(-0.25f * (fArray[n5 - 1] + fArray[n5 + 1]) + 0.5f);
                    }
                    break;
                }
                throw new ErrorException("Size should be greater or equal than 6 in order to perform 9/7M");
            }
            case 7: {
                throw new ErrorException("Broken?");
            }
            case 8: {
                throw new ErrorException("Broken?");
            }
            default: {
                throw new ErrorException("Unrecognized wavelet transform type.");
            }
        }
        n2 = n3 / 2;
        float[] fArray2 = new float[n3];
        for (int i = 0; i < n2; ++i) {
            fArray2[i] = fArray[2 * i];
            fArray2[i + n2] = fArray[2 * i + 1];
        }
        return fArray2;
    }

    private float[] oddEvenFiltering(float[] fArray, int n) throws ErrorException {
        int n2 = fArray.length;
        switch (n) {
            case 1: {
                int n3;
                for (n3 = 1; n3 < n2 - 1; n3 += 2) {
                    fArray[n3] = fArray[n3] - (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1]) / 2.0f);
                }
                fArray[0] = fArray[0] + (float)Math.floor((fArray[1] + fArray[1] + 2.0f) / 4.0f);
                for (n3 = 2; n3 < n2 - 1; n3 += 2) {
                    fArray[n3] = fArray[n3] + (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1] + 2.0f) / 4.0f);
                }
                fArray[n2 - 1] = fArray[n2 - 1] + (float)Math.floor((fArray[n2 - 2] + fArray[n2 - 2] + 2.0f) / 4.0f);
                break;
            }
            case 2: 
            case 3: {
                int n4;
                float f;
                float f2;
                if (n == 2) {
                    f2 = 1.2301741f;
                    f = 1.0f / f2;
                } else {
                    f = 1.1496044f;
                    f2 = -1.0f / f;
                }
                for (n4 = 1; n4 < n2 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] + -1.5861343f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                fArray[0] = fArray[0] + -0.052980117f * (fArray[1] + fArray[1]);
                for (n4 = 2; n4 < n2 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] + -0.052980117f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                fArray[n2 - 1] = fArray[n2 - 1] + -0.052980117f * (fArray[n2 - 2] + fArray[n2 - 2]);
                for (n4 = 1; n4 < n2 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] + 0.8829111f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                fArray[0] = fArray[0] + 0.44350687f * (fArray[1] + fArray[1]);
                for (n4 = 2; n4 < n2 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] + 0.44350687f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                fArray[n2 - 1] = fArray[n2 - 1] + 0.44350687f * (fArray[n2 - 2] + fArray[n2 - 2]);
                for (n4 = 0; n4 < n2 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] * f;
                    fArray[n4 + 1] = fArray[n4 + 1] * f2;
                }
                fArray[n2 - 1] = fArray[n2 - 1] * f;
                break;
            }
            case 4: {
                if (n2 >= 6) {
                    int n5;
                    fArray[1] = fArray[1] - (float)Math.floor((double)(0.5625f * (fArray[0] + fArray[2]) - 0.0625f * (fArray[2] + fArray[4])) + 0.5);
                    for (n5 = 3; n5 < n2 - 3; n5 += 2) {
                        fArray[n5] = fArray[n5] - (float)Math.floor((double)(0.5625f * (fArray[n5 - 1] + fArray[n5 + 1]) - 0.0625f * (fArray[n5 - 3] + fArray[n5 + 3])) + 0.5);
                    }
                    fArray[n2 - 2] = fArray[n2 - 2] - (float)Math.floor((double)(0.5625f * (fArray[n2 - 3] + fArray[n2 - 1]) - 0.0625f * (fArray[n2 - 5] + fArray[n2 - 1])) + 0.5);
                    fArray[0] = fArray[0] - (float)Math.floor((double)(-0.25f * (fArray[1] + fArray[1])) + 0.5);
                    for (n5 = 2; n5 < n2 - 1; n5 += 2) {
                        fArray[n5] = fArray[n5] - (float)Math.floor((double)(-0.25f * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                    }
                    fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((double)(-0.25f * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
                    break;
                }
                throw new ErrorException("Size should be greater or equal than 6 in order to perform 9/7M");
            }
            case 7: {
                float f = 0.0f;
                float f3 = 0.0f;
                float f4 = (float)Math.sqrt(2.0);
                for (int i = 0; i < n2 - 1; i += 2) {
                    f = (fArray[i] + fArray[i + 1]) / 2.0f;
                    f3 = (fArray[i + 1] - fArray[i + 1]) / 2.0f;
                    fArray[i] = f / f4;
                    fArray[i + 1] = f3 / f4;
                }
                fArray[n2 - 1] = fArray[n2 - 1];
                break;
            }
            case 8: {
                float f = 0.0f;
                for (int i = 0; i < n2 - 1; i += 2) {
                    f = fArray[i] - fArray[i + 1];
                    fArray[i] = fArray[i + 1] + (float)Math.floor(f / 2.0f);
                    fArray[i + 1] = f;
                }
                fArray[n2 - 1] = fArray[n2 - 1];
                break;
            }
            default: {
                throw new ErrorException("Unrecognized wavelet transform type.");
            }
        }
        float[] fArray2 = new float[n2];
        for (int i = 0; i < n2 / 2; ++i) {
            fArray2[i] = fArray[2 * i];
            fArray2[i + n2 / 2 + 1] = fArray[2 * i + 1];
        }
        fArray2[n2 / 2] = fArray[n2 - 1];
        return fArray2;
    }

    private float[] oddOddFiltering(float[] fArray, int n) throws ErrorException {
        int n2 = fArray.length;
        switch (n) {
            case 1: {
                int n3;
                for (n3 = 2; n3 < n2 - 1; n3 += 2) {
                    fArray[n3] = fArray[n3] - (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1]) / 2.0f);
                }
                fArray[0] = fArray[0] - (float)Math.floor((fArray[1] + fArray[1]) / 2.0f);
                fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((fArray[n2 - 2] + fArray[n2 - 2]) / 2.0f);
                for (n3 = 1; n3 < n2 - 1; n3 += 2) {
                    fArray[n3] = fArray[n3] + (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1] + 2.0f) / 4.0f);
                }
                break;
            }
            case 2: 
            case 3: {
                int n4;
                float f;
                float f2;
                if (n == 2) {
                    f2 = 1.2301741f;
                    f = 1.0f / f2;
                } else {
                    f = 1.1496044f;
                    f2 = -1.0f / f;
                }
                for (n4 = 2; n4 < n2 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] + -1.5861343f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                fArray[n2 - 1] = fArray[n2 - 1] + -1.5861343f * (fArray[n2 - 2] + fArray[n2 - 2]);
                fArray[0] = fArray[0] + -1.5861343f * (fArray[1] + fArray[1]);
                for (n4 = 1; n4 < n2 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] + -0.052980117f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                for (n4 = 2; n4 < n2 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] + 0.8829111f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                fArray[n2 - 1] = fArray[n2 - 1] + 0.8829111f * (fArray[n2 - 2] + fArray[n2 - 2]);
                fArray[0] = fArray[0] + 0.8829111f * (fArray[1] + fArray[1]);
                for (n4 = 1; n4 < n2 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] + 0.44350687f * (fArray[n4 - 1] + fArray[n4 + 1]);
                }
                for (n4 = 0; n4 < n2 - 1; n4 += 2) {
                    fArray[n4] = fArray[n4] * f2;
                    fArray[n4 + 1] = fArray[n4 + 1] * f;
                }
                fArray[n2 - 1] = fArray[n2 - 1] * f2;
                break;
            }
            case 4: {
                if (n2 >= 6) {
                    int n5;
                    fArray[0] = fArray[0] - (float)Math.floor((double)(0.5625f * (fArray[1] + fArray[1]) - 0.0625f * (fArray[3] + fArray[3])) + 0.5);
                    fArray[2] = fArray[2] - (float)Math.floor((double)(0.5625f * (fArray[1] + fArray[3]) - 0.0625f * (fArray[1] + fArray[5])) + 0.5);
                    for (n5 = 4; n5 < n2 - 3; n5 += 2) {
                        fArray[n5] = fArray[n5] - (float)Math.floor((double)(0.5625f * (fArray[n5 - 1] + fArray[n5 + 1]) - 0.0625f * (fArray[n5 - 3] + fArray[n5 + 3])) + 0.5);
                    }
                    fArray[n2 - 3] = fArray[n2 - 3] - (float)Math.floor((double)(0.5625f * (fArray[n2 - 4] + fArray[n2 - 2]) - 0.0625f * (fArray[n2 - 6] + fArray[n2 - 2])) + 0.5);
                    fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((double)(0.5625f * (fArray[n2 - 2] + fArray[n2 - 2]) - 0.0625f * (fArray[n2 - 4] + fArray[n2 - 4])) + 0.5);
                    for (n5 = 1; n5 < n2; n5 += 2) {
                        fArray[n5] = fArray[n5] - (float)Math.floor((double)(-0.25f * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                    }
                    break;
                }
                throw new ErrorException("Size should be greater or equal than 6 in order to perform 9/7M");
            }
            case 7: {
                throw new ErrorException("Broken?");
            }
            case 8: {
                throw new ErrorException("Broken?");
            }
            default: {
                throw new ErrorException("Unrecognized wavelet transform type.");
            }
        }
        float[] fArray2 = new float[n2];
        for (int i = 0; i < n2 / 2; ++i) {
            fArray2[i] = fArray[2 * i];
            fArray2[i + n2 / 2 + 1] = fArray[2 * i + 1];
        }
        fArray2[n2 / 2] = fArray[n2 - 1];
        return fArray2;
    }

    private float[] coefExpansion(float[] fArray) throws ErrorException {
        float[] fArray2 = new float[6];
        if (fArray == null) {
            throw new ErrorException("The source array is null");
        }
        switch (fArray.length) {
            case 1: {
                for (int i = 0; i < 6; ++i) {
                    fArray2[i] = fArray[0];
                }
                break;
            }
            case 2: {
                int n;
                for (n = 0; n < 6; n += 2) {
                    fArray2[n] = fArray[0];
                }
                for (n = 1; n < 6; n += 2) {
                    fArray2[n] = fArray[1];
                }
                break;
            }
            case 3: {
                int n;
                for (n = 0; n < 3; ++n) {
                    fArray2[n] = fArray[n];
                }
                for (n = 3; n < 5; ++n) {
                    fArray2[n] = fArray[4 - n];
                }
                fArray2[5] = fArray[1];
                break;
            }
            case 4: {
                int n;
                for (n = 0; n < 4; ++n) {
                    fArray2[n] = fArray[n];
                }
                for (n = 4; n < 6; ++n) {
                    fArray2[n] = fArray[6 - n];
                }
                break;
            }
            case 5: {
                for (int i = 0; i < 5; ++i) {
                    fArray2[i] = fArray[i];
                }
                fArray2[5] = fArray[3];
                break;
            }
            default: {
                throw new ErrorException("The source array length is out of the range 1 - 5");
            }
        }
        return fArray2;
    }

    private float[] coefUnexpansion(float[] fArray, int n) throws ErrorException {
        float[] fArray2 = new float[n];
        if (fArray == null) {
            throw new ErrorException("The filtered array is null!");
        }
        if (fArray.length != 6) {
            throw new ErrorException("The filtered array does not have size of 6");
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                for (int i = 0; i < n; ++i) {
                    fArray2[i] = fArray[i];
                }
                break;
            }
            default: {
                throw new ErrorException("The array original length is out of the range 1 - 5");
            }
        }
        return fArray2;
    }
}

