/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;
import GiciTransform.ForwardDWTCore;

public class ForwardPyramidal3D {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int[] WTTypes = null;
    int[] WTLevels = null;
    int WTOrder;
    boolean parametersSet = false;

    public ForwardPyramidal3D(float[][][] fArray) {
        this.imageSamples = fArray;
        this.zSize = fArray.length;
        this.ySize = fArray[0].length;
        this.xSize = fArray[0][0].length;
    }

    public void setParameters(int[] nArray, int[] nArray2) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = 0;
    }

    public void setParameters(int[] nArray, int[] nArray2, int n) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = n;
    }

    public float[][][] run() throws ErrorException {
        if (!this.parametersSet) {
            throw new ErrorException("Parameters not set.");
        }
        int n = this.xSize;
        int n2 = this.ySize;
        int n3 = this.zSize;
        if (this.WTLevels[0] < 0 || this.WTLevels[1] < 0 || this.WTLevels[2] < 0) {
            throw new ErrorException("All the transform levels to apply must be no negative.");
        }
        ForwardDWTCore forwardDWTCore = new ForwardDWTCore(this.imageSamples);
        if (this.WTLevels[0] != this.WTLevels[1] || this.WTLevels[1] != this.WTLevels[2]) {
            throw new ErrorException("The transform levels to apply must be equal for every dimension.");
        }
        switch (this.WTOrder) {
            case 0: {
                for (int i = 0; i < this.WTLevels[0]; ++i) {
                    forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    n = n / 2 + n % 2;
                    n2 = n2 / 2 + n2 % 2;
                    n3 = n3 / 2 + n3 % 2;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.WTLevels[0]; ++i) {
                    forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    n = n / 2 + n % 2;
                    n2 = n2 / 2 + n2 % 2;
                    n3 = n3 / 2 + n3 % 2;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.WTLevels[0]; ++i) {
                    forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    n = n / 2 + n % 2;
                    n2 = n2 / 2 + n2 % 2;
                    n3 = n3 / 2 + n3 % 2;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.WTLevels[0]; ++i) {
                    forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    n = n / 2 + n % 2;
                    n2 = n2 / 2 + n2 % 2;
                    n3 = n3 / 2 + n3 % 2;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.WTLevels[0]; ++i) {
                    forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    n = n / 2 + n % 2;
                    n2 = n2 / 2 + n2 % 2;
                    n3 = n3 / 2 + n3 % 2;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.WTLevels[0]; ++i) {
                    forwardDWTCore.setParameters(this.WTTypes[2], 2, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    forwardDWTCore.setParameters(this.WTTypes[1], 1, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    forwardDWTCore.setParameters(this.WTTypes[0], 0, 0, n3 - 1, 0, n2 - 1, 0, n - 1);
                    forwardDWTCore.run();
                    n = n / 2 + n % 2;
                    n2 = n2 / 2 + n2 % 2;
                    n3 = n3 / 2 + n3 % 2;
                }
                break;
            }
        }
        return forwardDWTCore.getImageSamples();
    }
}

