/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;

public class ForwardWaveletTransform {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int[] WTTypes = null;
    int[] WTLevels = null;
    int[] WTOrder = null;
    boolean parametersSet = false;
    int rLevel = 0;

    public ForwardWaveletTransform(float[][][] fArray) {
        this.imageSamples = fArray;
        this.zSize = fArray.length;
    }

    public void setParameters(int[] nArray, int[] nArray2) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = new int[this.zSize];
        for (int i = 0; i < this.zSize; ++i) {
            this.WTOrder[i] = 1;
        }
    }

    public void setParameters(int[] nArray, int[] nArray2, int[] nArray3) {
        this.parametersSet = true;
        this.WTTypes = nArray;
        this.WTLevels = nArray2;
        this.WTOrder = nArray3;
    }

    public float[][][] run() throws ErrorException {
        if (!this.parametersSet) {
            throw new ErrorException("Discrete wavelet transform cannot run if parameters are not set.");
        }
        for (int i = 0; i < this.zSize; ++i) {
            this.ySize = this.imageSamples[i].length;
            this.xSize = this.imageSamples[i][0].length;
            if (this.WTTypes[i] == 0 || this.WTLevels[i] <= 0) continue;
            int n = this.xSize;
            int n2 = this.ySize;
            for (int j = 0; j < this.WTLevels[i]; ++j) {
                int n3;
                float[] fArray;
                int n4;
                this.rLevel = this.WTLevels[i] - j;
                if (this.WTOrder[i] == 0 || this.WTOrder[i] == 2) {
                    for (n4 = 0; n4 < n2; ++n4) {
                        fArray = new float[n];
                        for (n3 = 0; n3 < n; ++n3) {
                            fArray[n3] = this.imageSamples[i][n4][n3];
                        }
                        fArray = this.filtering(fArray, i);
                        for (n3 = 0; n3 < n; ++n3) {
                            this.imageSamples[i][n4][n3] = fArray[n3];
                        }
                    }
                }
                if (this.WTOrder[i] != 2) {
                    for (n4 = 0; n4 < n; ++n4) {
                        fArray = new float[n2];
                        for (n3 = 0; n3 < n2; ++n3) {
                            fArray[n3] = this.imageSamples[i][n3][n4];
                        }
                        fArray = this.filtering(fArray, i);
                        for (n3 = 0; n3 < n2; ++n3) {
                            this.imageSamples[i][n3][n4] = fArray[n3];
                        }
                    }
                }
                if (this.WTOrder[i] == 1) {
                    for (n4 = 0; n4 < n2; ++n4) {
                        fArray = new float[n];
                        for (n3 = 0; n3 < n; ++n3) {
                            fArray[n3] = this.imageSamples[i][n4][n3];
                        }
                        fArray = this.filtering(fArray, i);
                        for (n3 = 0; n3 < n; ++n3) {
                            this.imageSamples[i][n4][n3] = fArray[n3];
                        }
                    }
                }
                n = n / 2 + n % 2;
                if (this.WTOrder[i] == 2) continue;
                n2 = n2 / 2 + n2 % 2;
            }
        }
        return this.imageSamples;
    }

    private float[] filtering(float[] fArray, int n) throws ErrorException {
        if (fArray.length == 1) {
            return fArray;
        }
        if (fArray.length % 2 == 0) {
            return this.evenFiltering(fArray, n);
        }
        return this.oddFiltering(fArray, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private float[] evenFiltering(float[] fArray, int n) throws ErrorException {
        float f;
        int n2 = fArray.length;
        if (this.WTTypes[n] == 1) {
            int n3;
            for (n3 = 1; n3 < n2 - 1; n3 += 2) {
                fArray[n3] = fArray[n3] - (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1]) / 2.0f);
            }
            fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor((fArray[n2 - 2] + fArray[n2 - 2]) / 2.0f);
            fArray[0] = fArray[0] + (float)Math.floor((fArray[1] + fArray[1] + 2.0f) / 4.0f);
            for (n3 = 2; n3 < n2 - 1; n3 += 2) {
                fArray[n3] = fArray[n3] + (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1] + 2.0f) / 4.0f);
            }
        } else if (this.WTTypes[n] == 2 || this.WTTypes[n] == 3) {
            int n4;
            float f2;
            float f3;
            if (this.WTTypes[n] == 2) {
                f3 = 1.2301741f;
                f2 = 1.0f / f3;
            } else {
                f2 = 1.1496043f;
                f3 = -1.0f / f2;
            }
            for (n4 = 1; n4 < n2 - 2; n4 += 2) {
                fArray[n4] = fArray[n4] + -1.5861343f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[n2 - 1] = fArray[n2 - 1] + -1.5861343f * (fArray[n2 - 2] + fArray[n2 - 2]);
            fArray[0] = fArray[0] + -0.052980117f * (fArray[1] + fArray[1]);
            for (n4 = 2; n4 < n2; n4 += 2) {
                fArray[n4] = fArray[n4] + -0.052980117f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            for (n4 = 1; n4 < n2 - 2; n4 += 2) {
                fArray[n4] = fArray[n4] + 0.8829111f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[n2 - 1] = fArray[n2 - 1] + 0.8829111f * (fArray[n2 - 2] + fArray[n2 - 2]);
            fArray[0] = fArray[0] + 0.44350687f * (fArray[1] + fArray[1]);
            for (n4 = 2; n4 < n2; n4 += 2) {
                fArray[n4] = fArray[n4] + 0.44350687f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            for (n4 = 0; n4 < n2; n4 += 2) {
                fArray[n4] = fArray[n4] * f2;
                fArray[n4 + 1] = fArray[n4 + 1] * f3;
            }
        } else if (this.WTTypes[n] == 4) {
            int n5;
            if (n2 < 6) throw new ErrorException("Size should be greater or equal than 6 in order to perform 9/7M");
            fArray[1] = fArray[1] - (float)Math.floor(0.5625f * (fArray[0] + fArray[2]) - 0.0625f * (fArray[2] + fArray[4]) + 0.5f);
            for (n5 = 3; n5 < n2 - 3; n5 += 2) {
                fArray[n5] = fArray[n5] - (float)Math.floor(0.5625f * (fArray[n5 - 1] + fArray[n5 + 1]) - 0.0625f * (fArray[n5 - 3] + fArray[n5 + 3]) + 0.5f);
            }
            fArray[n2 - 3] = fArray[n2 - 3] - (float)Math.floor(0.5625f * (fArray[n2 - 4] + fArray[n2 - 2]) - 0.0625f * (fArray[n2 - 6] + fArray[n2 - 2]) + 0.5f);
            fArray[n2 - 1] = fArray[n2 - 1] - (float)Math.floor(0.5625f * (fArray[n2 - 2] + fArray[n2 - 2]) - 0.0625f * (fArray[n2 - 4] + fArray[n2 - 4]) + 0.5f);
            fArray[0] = fArray[0] - (float)Math.floor(-0.25f * (fArray[1] + fArray[1]) + 0.5f);
            for (n5 = 2; n5 < n2; n5 += 2) {
                fArray[n5] = fArray[n5] - (float)Math.floor(-0.25f * (fArray[n5 - 1] + fArray[n5 + 1]) + 0.5f);
            }
        } else if (this.WTTypes[n] == 5 || this.WTTypes[n] == 6) {
            int n6;
            float f4;
            float f5;
            float f6;
            if (this.WTTypes[n] == 6) {
                f6 = -1.5861598f;
                f5 = -0.05297864f;
                f = 0.8829336f;
                f4 = 0.4435048f;
            } else {
                f6 = -0.5f;
                f5 = 0.25f;
                f = 0.0f;
                f4 = 0.0f;
            }
            for (n6 = 1; n6 < n2 - 2; n6 += 2) {
                fArray[n6] = fArray[n6] + (float)Math.floor((double)(f6 * (fArray[n6 - 1] + fArray[n6 + 1])) + 0.5);
            }
            fArray[n2 - 1] = fArray[n2 - 1] + (float)Math.floor((double)(f6 * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
            fArray[0] = fArray[0] + (float)Math.floor((double)(f5 * (fArray[1] + fArray[1])) + 0.5);
            for (n6 = 2; n6 < n2; n6 += 2) {
                fArray[n6] = fArray[n6] + (float)Math.floor((double)(f5 * (fArray[n6 - 1] + fArray[n6 + 1])) + 0.5);
            }
            if (this.WTTypes[n] == 6) {
                for (n6 = 1; n6 < n2 - 2; n6 += 2) {
                    fArray[n6] = fArray[n6] + (float)Math.floor((double)(f * (fArray[n6 - 1] + fArray[n6 + 1])) + 0.5);
                }
                fArray[n2 - 1] = fArray[n2 - 1] + (float)Math.floor((double)(f * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
                fArray[0] = fArray[0] + (float)Math.floor((double)(f4 * (fArray[1] + fArray[1])) + 0.5);
                for (n6 = 2; n6 < n2; n6 += 2) {
                    fArray[n6] = fArray[n6] + (float)Math.floor((double)(f4 * (fArray[n6 - 1] + fArray[n6 + 1])) + 0.5);
                }
            }
        } else if (this.WTTypes[n] == 7) {
            float f7 = 0.0f;
            float f8 = 0.0f;
            f = (float)Math.sqrt(2.0);
            for (int i = 0; i < n2; i += 2) {
                f7 = (fArray[i] + fArray[i + 1]) / 2.0f;
                f8 = (fArray[i] - fArray[i + 1]) / 2.0f;
                fArray[i] = f7 / f;
                fArray[i + 1] = f8 / f;
            }
        } else {
            if (this.WTTypes[n] != 8) throw new ErrorException("Unrecognized wavelet transform type.");
            float f9 = 0.0f;
            for (int i = 0; i < n2; i += 2) {
                f9 = fArray[i] - fArray[i + 1];
                fArray[i] = fArray[i + 1] + (float)Math.floor(f9 / 2.0f);
                fArray[i + 1] = f9;
            }
        }
        int n7 = n2 / 2;
        float[] fArray2 = new float[n2];
        for (int i = 0; i < n7; ++i) {
            fArray2[i] = fArray[2 * i];
            fArray2[i + n7] = fArray[2 * i + 1];
        }
        return fArray2;
    }

    private float[] oddFiltering(float[] fArray, int n) throws ErrorException {
        int n2 = fArray.length;
        if (this.WTTypes[n] == 1) {
            int n3;
            for (n3 = 1; n3 < n2 - 1; n3 += 2) {
                fArray[n3] = fArray[n3] - (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1]) / 2.0f);
            }
            fArray[0] = fArray[0] + (float)Math.floor((fArray[1] + fArray[1] + 2.0f) / 4.0f);
            for (n3 = 2; n3 < n2 - 1; n3 += 2) {
                fArray[n3] = fArray[n3] + (float)Math.floor((fArray[n3 - 1] + fArray[n3 + 1] + 2.0f) / 4.0f);
            }
            fArray[n2 - 1] = fArray[n2 - 1] + (float)Math.floor((fArray[n2 - 2] + fArray[n2 - 2] + 2.0f) / 4.0f);
        } else if (this.WTTypes[n] == 2 || this.WTTypes[n] == 3) {
            int n4;
            float f;
            float f2;
            if (this.WTTypes[n] == 2) {
                f2 = 1.2301741f;
                f = 1.0f / f2;
            } else {
                f2 = 1.1496043f;
                f = -1.0f / f2;
            }
            for (n4 = 1; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] + -1.5861343f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[0] = fArray[0] + -0.052980117f * (fArray[1] + fArray[1]);
            for (n4 = 2; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] + -0.052980117f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[n2 - 1] = fArray[n2 - 1] + -0.052980117f * (fArray[n2 - 2] + fArray[n2 - 2]);
            for (n4 = 1; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] + 0.8829111f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[0] = fArray[0] + 0.44350687f * (fArray[1] + fArray[1]);
            for (n4 = 2; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] + 0.44350687f * (fArray[n4 - 1] + fArray[n4 + 1]);
            }
            fArray[n2 - 1] = fArray[n2 - 1] + 0.44350687f * (fArray[n2 - 2] + fArray[n2 - 2]);
            for (n4 = 0; n4 < n2 - 1; n4 += 2) {
                fArray[n4] = fArray[n4] * f;
                fArray[n4 + 1] = fArray[n4 + 1] * f2;
            }
            fArray[n2 - 1] = fArray[n2 - 1] * f;
        } else {
            float f;
            if (this.WTTypes[n] == 4) {
                throw new ErrorException("Integer 9/7M CCSDS Recommended is not implemented for odd signals.!!!");
            }
            if (this.WTTypes[n] == 5 || this.WTTypes[n] == 6) {
                int n5;
                float f3;
                float f4;
                float f5;
                if (this.WTTypes[n] == 6) {
                    f5 = -1.5861598f;
                    f4 = -0.05297864f;
                    f = 0.8829336f;
                    f3 = 0.4435048f;
                } else {
                    f5 = -0.5f;
                    f4 = 0.25f;
                    f = 0.0f;
                    f3 = 0.0f;
                }
                for (n5 = 1; n5 < n2 - 1; n5 += 2) {
                    fArray[n5] = fArray[n5] + (float)Math.floor((double)(f5 * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                }
                fArray[0] = fArray[0] + (float)Math.floor((double)(f4 * (fArray[1] + fArray[1])) + 0.5);
                for (n5 = 2; n5 < n2 - 1; n5 += 2) {
                    fArray[n5] = fArray[n5] + (float)Math.floor((double)(f4 * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                }
                fArray[n2 - 1] = fArray[n2 - 1] + (float)Math.floor((double)(f4 * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
                if (this.WTTypes[n] == 6) {
                    for (n5 = 1; n5 < n2 - 1; n5 += 2) {
                        fArray[n5] = fArray[n5] + (float)Math.floor((double)(f * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                    }
                    fArray[0] = fArray[0] + (float)Math.floor((double)(f3 * (fArray[1] + fArray[1])) + 0.5);
                    for (n5 = 2; n5 < n2 - 1; n5 += 2) {
                        fArray[n5] = fArray[n5] + (float)Math.floor((double)(f3 * (fArray[n5 - 1] + fArray[n5 + 1])) + 0.5);
                    }
                    fArray[n2 - 1] = fArray[n2 - 1] + (float)Math.floor((double)(f3 * (fArray[n2 - 2] + fArray[n2 - 2])) + 0.5);
                }
            } else if (this.WTTypes[n] == 7) {
                float f6 = 0.0f;
                float f7 = 0.0f;
                f = (float)Math.sqrt(2.0);
                for (int i = 0; i < n2 - 1; i += 2) {
                    f6 = (fArray[i] + fArray[i + 1]) / 2.0f;
                    f7 = (fArray[i + 1] - fArray[i + 1]) / 2.0f;
                    fArray[i] = f6 / f;
                    fArray[i + 1] = f7 / f;
                }
                fArray[n2 - 1] = fArray[n2 - 1];
            } else if (this.WTTypes[n] == 8) {
                float f8 = 0.0f;
                for (int i = 0; i < n2 - 1; i += 2) {
                    f8 = fArray[i] - fArray[i + 1];
                    fArray[i] = fArray[i + 1] + (float)Math.floor(f8 / 2.0f);
                    fArray[i + 1] = f8;
                }
                fArray[n2 - 1] = fArray[n2 - 1];
            } else {
                throw new ErrorException("Unrecognized wavelet transform type.");
            }
        }
        float[] fArray2 = new float[n2];
        for (int i = 0; i < n2 / 2; ++i) {
            fArray2[i] = fArray[2 * i];
            fArray2[i + n2 / 2 + 1] = fArray[2 * i + 1];
        }
        fArray2[n2 / 2] = fArray[n2 - 1];
        return fArray2;
    }
}

