/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform.Interleaver;

import GiciTransform.Interleaver.SampleOrder;

public class Deinterleaver {
    private final GenericDeinterleaver instance;

    public Deinterleaver(int[][][] nArray, SampleOrder sampleOrder, int n) {
        switch (sampleOrder) {
            case BSQ: {
                this.instance = new BandSequential(nArray);
                break;
            }
            case BIL: {
                this.instance = new BandInterleaved(nArray, n);
                break;
            }
            default: {
                this.instance = null;
            }
        }
    }

    public int setNextSamples(int[] nArray) {
        return this.instance.setNextSamples(nArray);
    }

    private class BandInterleaved
    implements GenericDeinterleaver {
        int[][][] img;
        int x_max;
        int x = 0;
        int y_max;
        int y = 0;
        int z_max;
        int z = 0;
        int M;
        int aux;
        int m = 0;

        public BandInterleaved(int[][][] nArray, int n) {
            this.img = nArray;
            this.x_max = nArray[0][0].length;
            this.y_max = nArray[0].length;
            this.z_max = nArray.length;
            if (n < 1 || n > nArray.length) {
                throw new RuntimeException("Subframe interleaving depth must be between 1 and the number of bands.");
            }
            this.M = n;
            this.aux = this.z_max % n == 0 ? this.z_max / n : this.z_max / n + 1;
        }

        @Override
        public int setNextSamples(int[] nArray) {
            int n = 0;
            block0: while (this.y < this.y_max) {
                while (this.m < this.aux) {
                    while (this.x < this.x_max) {
                        while (this.z < Math.min((this.m + 1) * this.M, this.z_max)) {
                            if (n >= nArray.length) break block0;
                            this.img[this.z][this.y][this.x] = nArray[n++];
                            ++this.z;
                        }
                        this.z = this.m * this.M;
                        ++this.x;
                    }
                    this.z = (this.m + 1) * this.M;
                    this.x = 0;
                    ++this.m;
                }
                this.m = 0;
                this.z = 0;
                ++this.y;
            }
            return n;
        }
    }

    private class BandSequential
    implements GenericDeinterleaver {
        int[][][] img;
        int x_max;
        int x = 0;
        int y_max;
        int y = 0;
        int z_max;
        int z = 0;

        public BandSequential(int[][][] nArray) {
            this.img = nArray;
            this.x_max = nArray[0][0].length;
            this.y_max = nArray[0].length;
            this.z_max = nArray.length;
        }

        @Override
        public int setNextSamples(int[] nArray) {
            int n = 0;
            block0: while (this.z < this.z_max) {
                while (this.y < this.y_max) {
                    while (this.x < this.x_max) {
                        if (n > nArray.length) break block0;
                        this.img[this.z][this.y][this.x] = nArray[n++];
                        ++this.x;
                    }
                    this.x = 0;
                    ++this.y;
                }
                this.y = 0;
                ++this.z;
            }
            return n;
        }
    }

    static interface GenericDeinterleaver {
        public int setNextSamples(int[] var1);
    }
}

