/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciAnalysis.ImageStatistical;
import GiciException.ErrorException;

public class LevelShift {
    float[][][] imageSamples = null;
    int zSize;
    int ySize;
    int xSize;
    int LSType;
    boolean[] LSComponents = null;
    int[] LSSubsValues = null;
    int[] QComponentsBits = null;
    boolean parametersSet = false;

    public LevelShift(float[][][] fArray) {
        this.imageSamples = fArray;
        this.zSize = fArray.length;
        this.ySize = fArray[0].length;
        this.xSize = fArray[0][0].length;
    }

    public void setParameters(int n, boolean[] blArray, int[] nArray, int[] nArray2) {
        this.parametersSet = true;
        this.LSType = n;
        this.LSComponents = blArray;
        this.LSSubsValues = nArray;
        this.QComponentsBits = nArray2;
    }

    public float[][][] run() throws ErrorException {
        if (!this.parametersSet) {
            throw new ErrorException("Parameters not set.");
        }
        if (this.LSType != 0) {
            int n;
            int n2;
            if (this.LSSubsValues == null) {
                this.LSSubsValues = new int[this.zSize];
            }
            ImageStatistical imageStatistical = null;
            switch (this.LSType) {
                case 0: {
                    for (int i = 0; i < this.zSize; ++i) {
                        this.LSSubsValues[i] = 0;
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.zSize; ++i) {
                        this.LSSubsValues[i] = (int)Math.pow(2.0, this.QComponentsBits[i] - 1);
                    }
                    break;
                }
                case 2: {
                    imageStatistical = new ImageStatistical(this.imageSamples);
                    double[] dArray = imageStatistical.getCenterRange();
                    for (n2 = 0; n2 < this.zSize; ++n2) {
                        this.LSSubsValues[n2] = (int)Math.round(dArray[n2]);
                    }
                    break;
                }
                case 3: {
                    imageStatistical = new ImageStatistical(this.imageSamples);
                    double[] dArray = imageStatistical.getAverage();
                    for (n = 0; n < this.zSize; ++n) {
                        this.LSSubsValues[n] = (int)Math.round(dArray[n]);
                    }
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new ErrorException("Unrecognized level shift type.");
                }
            }
            for (int i = 0; i < this.zSize; ++i) {
                if (this.LSComponents[i]) {
                    if (this.LSSubsValues[i] == 0) continue;
                    for (n2 = 0; n2 < this.ySize; ++n2) {
                        n = 0;
                        while (n < this.xSize) {
                            float[] fArray = this.imageSamples[i][n2];
                            int n3 = n++;
                            fArray[n3] = fArray[n3] - (float)this.LSSubsValues[i];
                        }
                    }
                    continue;
                }
                this.LSSubsValues[i] = 0;
            }
        }
        return this.imageSamples;
    }

    public int[] getSubsValues() {
        return this.LSSubsValues;
    }
}

