/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciMatrix.MatrixAlgebra;
import GiciParallel.ParallelMap;

public class LinearTransform {
    private float[][] transform;
    private int dimension;

    public LinearTransform(float[][] fArray, int n) {
        this.transform = fArray;
        this.dimension = n;
        assert (fArray.length > 0 && fArray.length == fArray[0].length);
        assert (this.dimension < 3 && this.dimension >= 0);
    }

    public final void transformInPlace(final float[][][] fArray) {
        final int n = fArray.length;
        int n2 = fArray[0].length;
        int n3 = fArray[0][0].length;
        switch (this.dimension) {
            case 0: {
                assert (n == this.transform.length);
                ParallelMap.map(new ParallelMap.MultidimensionalIterator(n2, n3), new ParallelMap.MapInterface<int[]>(){

                    @Override
                    public void apply(int[] nArray) {
                        int n2;
                        float[] fArray2 = new float[n];
                        for (n2 = 0; n2 < n; ++n2) {
                            fArray2[n2] = fArray[n2][nArray[0]][nArray[1]];
                        }
                        fArray2 = MatrixAlgebra.multiplicationCV(LinearTransform.this.transform, fArray2);
                        for (n2 = 0; n2 < n; ++n2) {
                            fArray[n2][nArray[0]][nArray[1]] = fArray2[n2];
                        }
                    }
                });
                break;
            }
            case 1: {
                assert (n2 == this.transform.length);
                float[] fArray2 = new float[n2];
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n4;
                        for (n4 = 0; n4 < n2; ++n4) {
                            fArray2[n4] = fArray[i][n4][j];
                        }
                        fArray2 = MatrixAlgebra.multiplicationCV(this.transform, fArray2);
                        for (n4 = 0; n4 < n2; ++n4) {
                            fArray[i][n4][j] = fArray2[n4];
                        }
                    }
                }
                break;
            }
            case 2: {
                assert (n3 == this.transform.length);
                float[] fArray3 = new float[n3];
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        int n5;
                        for (n5 = 0; n5 < n3; ++n5) {
                            fArray3[n5] = fArray[i][j][n5];
                        }
                        fArray3 = MatrixAlgebra.multiplicationCV(this.transform, fArray3);
                        for (n5 = 0; n5 < n3; ++n5) {
                            fArray[i][j][n5] = fArray3[n5];
                        }
                    }
                }
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public final float[][][] transform(float[][][] fArray) {
        float[][][] fArrayArray = new float[fArray.length][][];
        for (int i = 0; i < fArray.length; ++i) {
            fArrayArray[i] = new float[fArray[i].length][];
            for (int j = 0; j < fArray[i].length; ++j) {
                fArrayArray[i][j] = new float[fArray[i][j].length];
                System.arraycopy(fArray[i][j], 0, fArrayArray[i][j], 0, fArray[i][j].length);
            }
        }
        this.transformInPlace(fArrayArray);
        return fArrayArray;
    }
}

