/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import java.util.ArrayList;
import java.util.List;

public class ModuloTransform {
    int index = 0;

    private int[] getPythagoreanTriple(int n) {
        assert (n > 0);
        int n2 = n * 2 + 1;
        int n3 = (n2 * n2 - 1) / 2;
        int[] nArray = new int[]{n2, n3, n3 + 1};
        return nArray;
    }

    private double getAngleFromTriple(int[] nArray) {
        int n = nArray[0];
        return Math.atan2(2 * n, n * n - 1);
    }

    private List<int[]> recursiveSequence(int n, int n2, int n3) {
        if (n3 < 1) {
            return new ArrayList<int[]>();
        }
        List<int[]> list = this.recursiveSequence(n, n2, n3 - 1);
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int[] nArray : list) {
            int n4 = n;
            while (n4 < n2) {
                int[] nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray2[nArray.length] = n4++;
                arrayList.add(nArray2);
            }
        }
        int n5 = n;
        while (n5 < n2) {
            int[] nArray;
            nArray = new int[]{n5++};
            arrayList.add(nArray);
        }
        return arrayList;
    }

    public int[] suggestTriplesSequence(double d) {
        assert (d > 0.0);
        List<int[]> list = this.recursiveSequence(1, 13, 5);
        int[] nArray = null;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = 1;
        for (int[] nArray2 : list) {
            double d3 = 0.0;
            for (int i = 0; i < nArray2.length; ++i) {
                d3 += this.getAngleFromTriple(this.getPythagoreanTriple(nArray2[i]));
            }
            if (!(Math.abs(d - d3) + 0.005 * (double)(nArray2.length - n) < Math.abs(d - d2))) continue;
            nArray = nArray2;
            d2 = d3;
            n = nArray2.length;
        }
        return nArray;
    }

    private int sdiv(int n, int n2) {
        assert (n2 > 0);
        int n3 = n + n2 / 2;
        int n4 = n3 / n2;
        if (n3 < 0 && n3 % n2 != 0) {
            --n4;
        }
        return n4;
    }

    private int smod(int n, int n2) {
        return n - n2 * this.sdiv(n, n2);
    }

    public void setTransform(int n) {
        assert (n > 0);
        this.index = n;
    }

    private int[] butterfly(int[] nArray, int[] nArray2) {
        int n = nArray2[0];
        int n2 = nArray2[1];
        int n3 = nArray2[2];
        int[] nArray3 = new int[]{nArray[0] * n2, nArray[1] * n2};
        nArray3[1] = nArray3[1] + nArray[0] * n;
        nArray3[0] = nArray3[0] - nArray[1] * n;
        nArray3[0] = this.sdiv(nArray3[0], n3);
        nArray3[1] = this.sdiv(nArray3[1], n3);
        return nArray3;
    }

    public void applyForward(int[][] nArray) {
        int[] nArray2 = this.getPythagoreanTriple(this.index);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.butterfly(nArray[i], nArray2);
        }
    }

    public void applyInverse(int[][] nArray) {
        int[] nArray2 = this.getPythagoreanTriple(this.index);
        nArray2[0] = -nArray2[0];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.butterfly(nArray[i], nArray2);
        }
    }
}

