/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciTransform.Permutation;

public class Reshape {
    public static final int[] DIM_TRANSP_BIL_TO_BSQ = new int[]{1, 0, 2};
    public static final int[] DIM_TRANSP_BSQ_TO_BIL = DIM_TRANSP_BIL_TO_BSQ;
    public static final int[] DIM_TRANSP_BIL_TO_BIP = new int[]{0, 2, 1};
    public static final int[] DIM_TRANSP_BIP_TO_BIL = DIM_TRANSP_BIL_TO_BIP;
    public static final int[] DIM_TRANSP_BIP_TO_BSQ = new int[]{2, 0, 1};
    public static final int[] DIM_TRANSP_BSQ_TO_BIP = new int[]{1, 2, 0};
    public static final int[] DIM_TRANSP_SPATIAL = new int[]{0, 2, 1};
    GenericReshape instance;

    public void dimensionTranspose(int[] nArray) {
        this.instance.dimensionTranspose(nArray);
    }

    public void reshapeMatlabLike(int n, int n2, int n3) {
        this.instance.reshapeMatlabLike(n, n2, n3);
    }

    public Reshape(float[][][] fArray) {
        this.instance = new FloatReshape(fArray);
    }

    public Reshape(int[][][] nArray) {
        this.instance = new IntegerReshape(nArray);
    }

    public float[][][] getImageFloat() {
        return ((FloatReshape)this.instance).getImage();
    }

    public int[][][] getImageInteger() {
        return ((IntegerReshape)this.instance).getImage();
    }

    class IntegerReshape
    implements GenericReshape {
        int[][][] image;

        public IntegerReshape(int[][][] nArray) {
            assert (nArray.length > 0 && nArray[0].length > 0 && nArray[0][0].length > 0);
            this.image = nArray;
        }

        @Override
        public void dimensionTranspose(int[] nArray) {
            Permutation permutation = new Permutation(nArray);
            int[] nArray2 = new int[]{this.image.length, this.image[0].length, this.image[0][0].length};
            nArray2 = permutation.applyToVector(nArray2);
            int[][][] nArray3 = new int[nArray2[0]][nArray2[1]][nArray2[2]];
            permutation.reversePermutation();
            for (int i = 0; i < nArray2[0]; ++i) {
                for (int j = 0; j < nArray2[1]; ++j) {
                    for (int k = 0; k < nArray2[2]; ++k) {
                        int[] nArray4 = new int[]{i, j, k};
                        nArray4 = permutation.applyToVector(nArray4);
                        nArray3[i][j][k] = this.image[nArray4[0]][nArray4[1]][nArray4[2]];
                    }
                }
            }
            this.image = nArray3;
        }

        @Override
        public void reshapeMatlabLike(int n, int n2, int n3) {
            int n4 = this.image.length;
            int n5 = this.image[0].length;
            int n6 = this.image[0][0].length;
            assert (n4 * n5 * n6 == n * n2 * n3);
            assert (n4 > 0);
            assert (n5 > 0);
            assert (n6 > 0);
            assert (n > 0);
            assert (n2 > 0);
            assert (n3 > 0);
            int[][][] nArray = new int[n][n2][n3];
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            do {
                nArray[n10][n11][n12] = this.image[n7][n8][n9];
                if ((n9 = (n9 + 1) % n6) != 0 || (n8 = (n8 + 1) % n5) != 0) continue;
                n7 = (n7 + 1) % n4;
            } while ((n12 = (n12 + 1) % n3) != 0 || (n11 = (n11 + 1) % n2) != 0 || (n10 = (n10 + 1) % n) != 0);
            assert (n7 == 0 && n8 == 0 && n9 == 0);
            this.image = nArray;
        }

        public int[][][] getImage() {
            return this.image;
        }
    }

    class FloatReshape
    implements GenericReshape {
        float[][][] image;

        public FloatReshape(float[][][] fArray) {
            assert (fArray.length > 0 && fArray[0].length > 0 && fArray[0][0].length > 0);
            this.image = fArray;
        }

        @Override
        public void dimensionTranspose(int[] nArray) {
            Permutation permutation = new Permutation(nArray);
            int[] nArray2 = new int[]{this.image.length, this.image[0].length, this.image[0][0].length};
            nArray2 = permutation.applyToVector(nArray2);
            float[][][] fArray = new float[nArray2[0]][nArray2[1]][nArray2[2]];
            permutation.reversePermutation();
            for (int i = 0; i < nArray2[0]; ++i) {
                for (int j = 0; j < nArray2[1]; ++j) {
                    for (int k = 0; k < nArray2[2]; ++k) {
                        int[] nArray3 = new int[]{i, j, k};
                        nArray3 = permutation.applyToVector(nArray3);
                        fArray[i][j][k] = this.image[nArray3[0]][nArray3[1]][nArray3[2]];
                    }
                }
            }
            this.image = fArray;
        }

        @Override
        public void reshapeMatlabLike(int n, int n2, int n3) {
            int n4 = this.image.length;
            int n5 = this.image[0].length;
            int n6 = this.image[0][0].length;
            assert (n4 * n5 * n6 == n * n2 * n3);
            assert (n4 > 0);
            assert (n5 > 0);
            assert (n6 > 0);
            assert (n > 0);
            assert (n2 > 0);
            assert (n3 > 0);
            float[][][] fArray = new float[n][n2][n3];
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            do {
                fArray[n10][n11][n12] = this.image[n7][n8][n9];
                if ((n9 = (n9 + 1) % n6) != 0 || (n8 = (n8 + 1) % n5) != 0) continue;
                n7 = (n7 + 1) % n4;
            } while ((n12 = (n12 + 1) % n3) != 0 || (n11 = (n11 + 1) % n2) != 0 || (n10 = (n10 + 1) % n) != 0);
            assert (n7 == 0 && n8 == 0 && n9 == 0);
            this.image = fArray;
        }

        public float[][][] getImage() {
            return this.image;
        }
    }

    static interface GenericReshape {
        public void dimensionTranspose(int[] var1);

        public void reshapeMatlabLike(int var1, int var2, int var3);
    }
}

