/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.ErrorException;

public class Scaler {
    float[][] imageSamples = null;
    public static final int NEAREST = 1;
    public static final int BILINEAR = 2;
    int interpolType;
    double scaleVertical;
    double scaleHorizontal;
    boolean parametersSet = false;

    public Scaler(float[][] fArray) {
        this.imageSamples = fArray;
    }

    public void setParamaters(double d, double d2, int n) {
        this.parametersSet = true;
        this.scaleVertical = d;
        this.scaleHorizontal = d2;
        this.interpolType = n;
    }

    float[][] getScaleNN() throws ErrorException {
        if (!this.parametersSet) {
            throw new ErrorException("Parameters not set.");
        }
        int n = this.imageSamples.length;
        int n2 = this.imageSamples[0].length;
        double d = 1.0E-10;
        int n3 = (int)((double)n * this.scaleVertical + d);
        int n4 = (int)((double)n2 * this.scaleHorizontal + d);
        float[][] fArray = new float[n3][n4];
        double d2 = ((double)n3 - 1.0) / ((double)n - 1.0);
        double d3 = ((double)n4 - 1.0) / ((double)n2 - 1.0);
        for (int i = 0; i < n3; ++i) {
            int n5 = (int)Math.round((double)i / d2);
            for (int j = 0; j < n4; ++j) {
                int n6 = (int)Math.round((double)j / d3);
                fArray[i][j] = this.imageSamples[n5][n6];
            }
        }
        return fArray;
    }

    float[][] getScaleMatrixBL() throws ErrorException {
        if (!this.parametersSet) {
            throw new ErrorException("Parameters not set.");
        }
        int n = this.imageSamples.length;
        int n2 = this.imageSamples[0].length;
        double d = 1.0E-10;
        int n3 = (int)((double)n * this.scaleVertical + d);
        int n4 = (int)((double)n2 * this.scaleHorizontal + d);
        float[][] fArray = new float[n3][n4];
        double d2 = ((double)n3 - 1.0) / ((double)n - 1.0);
        double d3 = ((double)n4 - 1.0) / ((double)n2 - 1.0);
        for (int i = 0; i < n3; ++i) {
            double d4 = (double)i / d2;
            int n5 = (int)d4;
            int n6 = Math.min(n5 + 1, n - 1);
            double d5 = d4 - (double)n5;
            for (int j = 0; j < n4; ++j) {
                double d6 = (double)j / d3;
                int n7 = (int)d6;
                int n8 = Math.min(n7 + 1, n2 - 1);
                double d7 = d6 - (double)n7;
                float f = this.imageSamples[n5][n7];
                float f2 = this.imageSamples[n6][n7];
                float f3 = this.imageSamples[n6][n8];
                float f4 = this.imageSamples[n5][n8];
                short s = (short)((1.0 - d5) * (1.0 - d7) * (double)f + d5 * (1.0 - d7) * (double)f2 + d5 * d7 * (double)f3 + (1.0 - d5) * d7 * (double)f4);
                fArray[i][j] = s;
            }
        }
        return fArray;
    }
}

