/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

import GiciException.WarningException;
import GiciMatrix.MatrixAlgebra;
import java.util.concurrent.Callable;

public class SingleRowElementaryReversibleMatrix
implements Callable<SingleRowElementaryReversibleMatrix> {
    int called = 0;
    final int N;
    float[][] A;
    float[][] SERMs;
    float[][] P;

    private void triangularElementaryReversibleMatrix() throws WarningException {
        int n;
        int n2;
        float[][][] fArray = new float[this.N - 1][this.N][this.N];
        float[][][] fArray2 = new float[this.N - 1][this.N][this.N];
        this.SERMs[0][this.N - 1] = 1.0f;
        for (int i = 0; i < this.N - 1; ++i) {
            float f;
            fArray[i] = MatrixAlgebra.identityC(this.N);
            fArray2[i] = MatrixAlgebra.identityC(this.N);
            n2 = -1;
            float f2 = Float.POSITIVE_INFINITY;
            int n3 = 0;
            while (i + n3 < this.N) {
                float f3;
                if (!(Math.abs(this.A[i + n3][this.N - 1]) < Float.MIN_VALUE) && (f3 = Math.abs((this.A[i + n3][i] - 1.0f) / this.A[i + n3][this.N - 1])) < f2) {
                    f2 = f3;
                    n2 = n3;
                }
                ++n3;
            }
            if (n2 < 0) {
                throw new WarningException("Non-singular matrix");
            }
            float[] fArray3 = this.A[i];
            this.A[i] = this.A[i + n2];
            this.A[i + n2] = fArray3;
            fArray3 = fArray[i][i];
            fArray[i][i] = fArray[i][i + n2];
            fArray[i][i + n2] = fArray3;
            this.SERMs[0][i] = f = (this.A[i][i] - 1.0f) / this.A[i][this.N - 1];
            for (n = 0; n < this.N; ++n) {
                this.A[n][i] = this.A[n][i] - f * this.A[n][this.N - 1];
            }
            for (n = i + 1; n < this.N; ++n) {
                fArray2[i][n][i] = -this.A[n][i];
                this.A[n][i] = 0.0f;
                for (int j = i + 1; j < this.N; ++j) {
                    this.A[n][j] = this.A[n][j] + fArray2[i][n][i] * this.A[i][j];
                }
            }
        }
        float[][] fArray4 = fArray2[this.N - 2];
        this.P = MatrixAlgebra.identityC(this.N);
        for (n2 = this.N - 3; n2 >= 0; --n2) {
            this.P = MatrixAlgebra.multiplicationCC(this.P, fArray[n2 + 1]);
            fArray4 = MatrixAlgebra.multiplicationCC(fArray4, MatrixAlgebra.multiplicationCC(this.P, MatrixAlgebra.multiplicationCC(fArray2[n2], MatrixAlgebra.transposeC(this.P))));
        }
        this.P = MatrixAlgebra.transposeC(MatrixAlgebra.multiplicationCC(this.P, fArray[0]));
        float[][] fArray5 = fArray4;
        for (int i = 0; i < this.N - 1; ++i) {
            for (int j = i + 1; j < this.N; ++j) {
                fArray5[j][i] = -fArray5[j][i];
                for (n = 0; n < i; ++n) {
                    float[] fArray6 = fArray5[j];
                    int n4 = n;
                    fArray6[n4] = fArray6[n4] + fArray5[i][n] * fArray5[j][i];
                }
            }
        }
        this.A = MatrixAlgebra.multiplicationCC(fArray5, this.A);
    }

    private void singleRowElementaryReversibleMatrix() {
        for (int i = 1; i <= this.N; ++i) {
            int n;
            this.A[i - 1][i - 1] = 1.0f;
            for (n = 0; n < this.N; ++n) {
                this.SERMs[i][n] = this.A[i - 1][n];
            }
            for (n = 0; n < this.N; ++n) {
                if (n == i - 1) continue;
                for (int j = i - 1; j < this.N; ++j) {
                    float[] fArray = this.A[j];
                    int n2 = n;
                    fArray[n2] = fArray[n2] - this.SERMs[i][n] * this.A[j][i - 1];
                }
            }
        }
    }

    public SingleRowElementaryReversibleMatrix(float[][] fArray) {
        assert (fArray.length == fArray[0].length);
        this.A = MatrixAlgebra.copy(fArray);
        this.N = this.A.length;
        this.SERMs = new float[this.N + 1][this.N];
    }

    public float[][] getSingleRowElementarySteps() {
        assert (this.called > 0);
        return this.SERMs;
    }

    public int[] getPermutation() {
        assert (this.called > 0);
        int[] nArray = new int[this.N];
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.N; ++j) {
                if (this.P[i][j] != 1.0f) continue;
                nArray[i] = j;
            }
        }
        return nArray;
    }

    public float[][] getPermutationMatrix() {
        assert (this.called > 0);
        return this.P;
    }

    @Override
    public SingleRowElementaryReversibleMatrix call() throws Exception {
        assert (this.called == 0);
        ++this.called;
        this.triangularElementaryReversibleMatrix();
        this.singleRowElementaryReversibleMatrix();
        this.A = null;
        return this;
    }
}

