/*
 * Decompiled with CFR 0.152.
 */
package GiciTransform;

public class ZeroMean {
    private int dimension;
    private boolean forward;
    private boolean meansCorrect = false;
    private boolean reversible;
    private final float[][][] image;
    private float[] means;

    public ZeroMean(float[][][] fArray, int n, boolean bl) {
        this.image = fArray;
        this.dimension = n;
        this.forward = true;
        this.reversible = bl;
        assert (n >= 0 && n <= 2);
    }

    public ZeroMean(float[][][] fArray, int n, float[] fArray2) {
        this.image = fArray;
        this.dimension = n;
        this.forward = false;
        this.means = fArray2;
        this.reversible = true;
        assert (n >= 0 && n <= 2);
    }

    private void calculateMeans() {
        int n;
        if (this.meansCorrect) {
            return;
        }
        this.meansCorrect = true;
        if (!this.forward) {
            for (int i = 0; i < this.means.length; ++i) {
                this.means[i] = -this.means[i];
            }
            return;
        }
        double[] dArray = null;
        switch (this.dimension) {
            case 0: {
                int n2;
                int n3;
                dArray = new double[this.image.length];
                this.means = new float[this.image.length];
                for (n = 0; n < this.image.length; ++n) {
                    for (n3 = 0; n3 < this.image[n].length; ++n3) {
                        for (n2 = 0; n2 < this.image[n][n3].length; ++n2) {
                            int n4 = n;
                            dArray[n4] = dArray[n4] + (double)this.image[n][n3][n2];
                        }
                    }
                }
                for (n = 0; n < dArray.length; ++n) {
                    this.means[n] = (float)(dArray[n] / (double)(this.image[0].length * this.image[0][0].length));
                }
                break;
            }
            case 1: {
                int n2;
                int n3;
                dArray = new double[this.image[0].length];
                this.means = new float[this.image[0].length];
                for (n = 0; n < this.image.length; ++n) {
                    for (n3 = 0; n3 < this.image[n].length; ++n3) {
                        for (n2 = 0; n2 < this.image[n][n3].length; ++n2) {
                            int n5 = n3;
                            dArray[n5] = dArray[n5] + (double)this.image[n][n3][n2];
                        }
                    }
                }
                for (n = 0; n < dArray.length; ++n) {
                    this.means[n] = (float)(dArray[n] / (double)(this.image.length * this.image[0][0].length));
                }
                break;
            }
            case 2: {
                int n2;
                int n3;
                dArray = new double[this.image[0][0].length];
                this.means = new float[this.image[0][0].length];
                for (n = 0; n < this.image.length; ++n) {
                    for (n3 = 0; n3 < this.image[n].length; ++n3) {
                        for (n2 = 0; n2 < this.image[n][n3].length; ++n2) {
                            int n6 = n2;
                            dArray[n6] = dArray[n6] + (double)this.image[n][n3][n2];
                        }
                    }
                }
                for (n = 0; n < dArray.length; ++n) {
                    this.means[n] = (float)(dArray[n] / (double)(this.image.length * this.image[0].length));
                }
                break;
            }
        }
        if (this.reversible) {
            for (n = 0; n < dArray.length; ++n) {
                this.means[n] = Math.round(this.means[n]);
            }
        }
    }

    public float[][][] applyMeans() {
        this.calculateMeans();
        float[][][] fArray = new float[this.image.length][this.image[0].length][this.image[0][0].length];
        switch (this.dimension) {
            case 0: {
                for (int i = 0; i < this.image.length; ++i) {
                    for (int j = 0; j < this.image[i].length; ++j) {
                        for (int k = 0; k < this.image[i][j].length; ++k) {
                            fArray[i][j][k] = this.image[i][j][k] - this.means[i];
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.image.length; ++i) {
                    for (int j = 0; j < this.image[i].length; ++j) {
                        for (int k = 0; k < this.image[i][j].length; ++k) {
                            fArray[i][j][k] = this.image[i][j][k] - this.means[j];
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.image.length; ++i) {
                    for (int j = 0; j < this.image[i].length; ++j) {
                        for (int k = 0; k < this.image[i][j].length; ++k) {
                            fArray[i][j][k] = this.image[i][j][k] - this.means[k];
                        }
                    }
                }
                break;
            }
        }
        return fArray;
    }

    public void applyMeansInPlace() {
        this.calculateMeans();
        switch (this.dimension) {
            case 0: {
                for (int i = 0; i < this.image.length; ++i) {
                    for (int j = 0; j < this.image[i].length; ++j) {
                        int n = 0;
                        while (n < this.image[i][j].length) {
                            float[] fArray = this.image[i][j];
                            int n2 = n++;
                            fArray[n2] = fArray[n2] - this.means[i];
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.image.length; ++i) {
                    for (int j = 0; j < this.image[i].length; ++j) {
                        int n = 0;
                        while (n < this.image[i][j].length) {
                            float[] fArray = this.image[i][j];
                            int n3 = n++;
                            fArray[n3] = fArray[n3] - this.means[j];
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.image.length; ++i) {
                    for (int j = 0; j < this.image[i].length; ++j) {
                        for (int k = 0; k < this.image[i][j].length; ++k) {
                            float[] fArray = this.image[i][j];
                            int n = k;
                            fArray[n] = fArray[n] - this.means[k];
                        }
                    }
                }
                break;
            }
        }
    }

    public float[] getMeans() {
        assert (this.forward);
        this.calculateMeans();
        return this.means;
    }
}

