/*
 * Decompiled with CFR 0.152.
 */
package Speck;

import GiciFile.LoadFile;
import GiciTransform.ForwardWaveletTransform;
import Speck.SpeckCoding.ArgsParser;
import Speck.SpeckCoding.SpeckCoding2D;

public class SpeckCode {
    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        ArgsParser argsParser = null;
        try {
            argsParser = new ArgsParser(stringArray);
        }
        catch (Exception exception) {
            System.out.println("ARGUMENTS ERROR: " + exception.getMessage());
            System.exit(1);
        }
        String string = argsParser.getImageFile();
        LoadFile loadFile = null;
        try {
            if (string.endsWith(".raw")) {
                object2 = argsParser.getImageGeometry();
                if (object2[0] <= 0 || object2[1] <= 0 || object2[2] <= 0) {
                    throw new Exception("Image dimensions in \".raw\" data files must be positive (\"-h\" displays help).");
                }
                if (object2[3] < 0 || object2[3] > 7) {
                    throw new Exception("Image type in \".raw\" data must be between 0 to 7 (\"-h\" displays help).");
                }
                if (object2[4] != 0 && object2[4] != 1) {
                    throw new Exception("Image Endian specification in \".raw\" data must be between 0 or 1 (\"-h\" displays help).");
                }
                if (object2[5] != 0 && object2[5] != 1) {
                    throw new Exception("Image RGB specification in \".raw\" data must be between 0 or 1 (\"-h\" displays help).");
                }
                loadFile = new LoadFile(string, object2[0], object2[1], object2[2], object2[3], object2[4], object2[5] != 0);
            } else {
                loadFile = new LoadFile(string);
            }
        }
        catch (Exception exception) {
            System.err.println("IMAGE LOADING ERROR: " + exception.getMessage());
            System.exit(2);
        }
        object2 = argsParser.getFileName();
        int[] nArray = argsParser.getWTTypes();
        int[] nArray2 = argsParser.getWTLevels();
        int n = argsParser.getMethod();
        int n2 = argsParser.getMinThr();
        int n3 = argsParser.getQType();
        float[][][] fArray = null;
        try {
            object = new ForwardWaveletTransform(loadFile.getImage());
            ((ForwardWaveletTransform)object).setParameters(nArray, nArray2);
            fArray = ((ForwardWaveletTransform)object).run();
        }
        catch (Exception exception) {
            System.out.println("DISCRETE WAVELET TRANSFORM FAILED: " + exception.getMessage());
            System.exit(3);
        }
        try {
            object = new SpeckCoding2D(SpeckCode.floatToInt(fArray, n3));
            ((SpeckCoding2D)object).setParameters(nArray2[0], (String)object2, n, n2);
            ((SpeckCoding2D)object).run();
        }
        catch (Exception exception) {
            System.out.println("CODIFICATION FAILED: " + exception.getMessage());
            System.exit(4);
        }
    }

    private static int[][][] floatToInt(float[][][] fArray, int n) {
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        int n4 = fArray[0][0].length;
        int[][][] nArray = new int[n2][n3][n4];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n4; ++k) {
                    nArray[i][j][k] = Math.round(fArray[i][j][k]);
                }
            }
        }
        return nArray;
    }
}

