/*
 * Decompiled with CFR 0.152.
 */
package Speck;

import GiciAnalysis.ImageCompare;
import GiciFile.LoadFile;
import GiciFile.SaveFile;
import GiciTransform.InverseWaveletTransform;
import Speck.Speck;
import Speck.SpeckDecoding.ArgsParser;
import Speck.SpeckDecoding.SpeckDecoding2D;

public class SpeckDecode {
    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        ArgsParser argsParser = null;
        try {
            argsParser = new ArgsParser(stringArray);
        }
        catch (Exception exception) {
            System.out.println("ARGUMENTS ERROR: " + exception.getMessage());
            System.exit(1);
        }
        int[] nArray = argsParser.getWTLevels();
        int[] nArray2 = argsParser.getWTTypes();
        int n = argsParser.getMinThr();
        Object var5_6 = null;
        int[][][] nArray3 = null;
        try {
            object3 = new SpeckDecoding2D();
            ((SpeckDecoding2D)object3).setParameters(n, argsParser.getFileName());
            ((SpeckDecoding2D)object3).run();
            nArray3 = ((Speck)object3).getImage();
        }
        catch (Exception exception) {
            System.out.println("An exception ocurred in the decode process: " + exception.getMessage());
            System.exit(1);
        }
        object3 = null;
        try {
            object2 = new InverseWaveletTransform(SpeckDecode.integerToFloat(nArray3));
            ((InverseWaveletTransform)object2).setParameters(nArray2, nArray);
            object3 = ((InverseWaveletTransform)object2).run();
            object2 = null;
        }
        catch (Exception exception) {
            System.out.println("DISCRETE WAVELET TRANSFORM ERROR: " + exception.getMessage());
            System.exit(4);
        }
        object2 = argsParser.getCompareImage();
        if (object2 != null) {
            object = null;
            try {
                Object[] objectArray;
                if (((String)object2).endsWith(".raw")) {
                    objectArray = argsParser.getImageGeometry();
                    if (objectArray[0] <= 0 || objectArray[1] <= 0 || objectArray[2] <= 0) {
                        throw new Exception("Image dimensions in \".raw\" data files must be positive (\"-h\" displays help).");
                    }
                    if (objectArray[3] < 0 || objectArray[3] > 7) {
                        throw new Exception("Image type in \".raw\" data must be between 0 to 7 (\"-h\" displays help).");
                    }
                    if (objectArray[4] != 0 && objectArray[4] != 1) {
                        throw new Exception("Image Endian specification in \".raw\" data must be between 0 or 1 (\"-h\" displays help).");
                    }
                    if (objectArray[5] != 0 && objectArray[5] != 1) {
                        throw new Exception("Image RGB specification in \".raw\" data must be between 0 or 1 (\"-h\" displays help).");
                    }
                    object = new LoadFile((String)object2, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5] != 0);
                } else {
                    object = new LoadFile((String)object2);
                }
                objectArray = ((LoadFile)object).getTypes();
                boolean bl = true;
                for (int i = 1; i < ((Object)object3).length; ++i) {
                    if (objectArray[i - 1] == objectArray[i]) continue;
                    bl = false;
                }
                if (bl) {
                    int[] nArray4 = new int[]{16};
                    if (objectArray[0] == Byte.TYPE) {
                        nArray4[0] = 8;
                    } else if (objectArray[0] == Integer.TYPE) {
                        nArray4[0] = 32;
                    } else if (objectArray[0] == Character.TYPE || objectArray[0] == Short.TYPE) {
                        nArray4[0] = 16;
                    } else {
                        System.out.println("Wrong image type");
                        System.exit(1);
                    }
                    ImageCompare imageCompare = new ImageCompare(((LoadFile)object).getImage(), (float[][][])object3, nArray4);
                    float f = imageCompare.getTotalMSE();
                    float f2 = imageCompare.getTotalPSNR();
                    float f3 = imageCompare.getTotalSNR();
                    System.out.print(f2 + " " + f + "\n");
                } else {
                    System.err.println("IMAGE COMPARE ERROR: Sample type of all image components must be the same.");
                }
            }
            catch (Exception exception) {
                System.err.println("IMAGE COMPARE ERROR: " + exception.getMessage());
            }
        }
        if ((object = argsParser.getOutFile()) != null) {
            try {
                if (((String)object).endsWith(".raw")) {
                    SaveFile.SaveFileRaw((float[][][])object3, (String)object, argsParser.getImageGeometry()[3], 0);
                } else if (((String)object).endsWith(".pgm")) {
                    SaveFile.SaveFileFormat((float[][][])object3, (String)object, 0);
                } else {
                    System.out.println("The image type is not avaible to save.");
                }
            }
            catch (Exception exception) {
                System.err.println("IMAGE SAVING ERROR: " + exception.getMessage());
            }
        }
    }

    private static float[][][] integerToFloat(int[][][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        int n3 = nArray[0][0].length;
        float[][][] fArray = new float[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    fArray[i][j][k] = nArray[i][j][k];
                }
            }
        }
        return fArray;
    }
}

