/*
 * Decompiled with CFR 0.152.
 */
package Speck.SpeckDecoding;

import GiciBitStream.BitInputStream;
import Speck.Speck;
import Speck.SpeckVector;
import java.io.FileInputStream;
import java.io.IOException;

public class SpeckDecoding2D
extends Speck {
    protected int minThreshold = 0;
    protected int SetIlevels = 0;
    protected int maxThresholdPow = 0;
    protected BitInputStream input = null;

    public void setParameters(int n, String string) throws IOException {
        this.minThreshold = n;
        FileInputStream fileInputStream = new FileInputStream(string);
        this.input = new BitInputStream(fileInputStream);
        this.xSize = (int)this.input.readUBits(16);
        this.ySize = (int)this.input.readUBits(16);
        this.zSize = (int)this.input.readUBits(16);
        this.WTlevels = (int)this.input.readUBits(4);
        this.method = (int)this.input.readUBits(2);
        this.maxThresholdPow = (int)this.input.readUBits(5);
        this.SetIlevels = this.WTlevels;
        this.image = new int[this.zSize][this.ySize][this.xSize];
    }

    public void run() throws IOException {
        int n;
        int n2 = this.ySize;
        int n3 = 0;
        SpeckVector.SpeckSet speckSet = new SpeckVector.SpeckSet(0, 0);
        SpeckVector speckVector = new SpeckVector();
        this.SetSizes = (int)(Math.log(this.ySize) / Math.log(2.0));
        this.LIS = new SpeckVector.SpeckDynamV();
        this.LSP = new SpeckVector();
        this.SetI = new SpeckVector[this.WTlevels];
        for (n = 0; n < this.WTlevels; ++n) {
            this.SetI[n] = new SpeckVector();
        }
        speckSet.SetSize(this.xSize, this.ySize);
        for (n = 0; n < this.WTlevels; ++n) {
            speckVector = this.QuadriSect(speckSet);
            speckSet = speckVector.PopSet();
            for (int i = 0; i < 3; ++i) {
                this.SetI[this.WTlevels - n - 1].AddSet(speckVector.PopSet());
            }
        }
        this.LIS.AddDynSet(speckSet);
        try {
            this.maxThreshold = (int)Math.pow(2.0, this.maxThresholdPow);
            while (this.maxThreshold > this.minThreshold) {
                n3 = this.LSP.getLength();
                this.Sorting();
                this.Refinement(n3);
                this.maxThreshold >>= 1;
            }
        }
        catch (Exception exception) {
            this.input.close();
        }
    }

    public void Sorting() throws IOException {
        SpeckVector speckVector = this.LIS.top;
        int n = this.LIS.GetDynLength();
        for (int i = 0; i < n; ++i) {
            int n2 = speckVector.getLength();
            for (int j = 0; j < n2; ++j) {
                SpeckVector.SpeckSet speckSet = speckVector.PopSet();
                this.ProcessS(speckSet);
            }
            speckVector = speckVector.next;
        }
        if (this.SetIlevels > 0) {
            this.ProcessI();
        }
    }

    public void ProcessS(SpeckVector.SpeckSet speckSet) throws IOException {
        int n = (int)this.input.readUBits(1);
        if (n == 1) {
            if (speckSet.GetSizeX() == 1 && speckSet.GetSizeY() == 1) {
                n = (int)this.input.readUBits(1);
                this.image[0][speckSet.GetSetY()][speckSet.GetSetX()] = n == 1 ? this.maxThreshold + this.maxThreshold / 2 : -this.maxThreshold - this.maxThreshold / 2;
                this.LSP.AddSet(speckSet);
            } else {
                this.CodeS(speckSet);
            }
        } else {
            this.LIS.AddDynSet(speckSet);
        }
    }

    public void CodeS(SpeckVector.SpeckSet speckSet) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        SpeckVector speckVector = null;
        SpeckVector speckVector2 = null;
        SpeckVector.SpeckSet speckSet2 = null;
        speckVector = new SpeckVector();
        speckVector2 = new SpeckVector();
        speckSet2 = new SpeckVector.SpeckSet();
        speckVector = this.QuadriSect(speckSet);
        int n4 = speckVector.getLength();
        for (n = 0; n < n4; ++n) {
            speckSet2 = speckVector.PopSet();
            if (this.method != 2 || n != 3 || n3 != 3) {
                n2 = (int)this.input.readUBits(1);
            }
            if (this.method == 2 && n == 3 && n3 == 3) {
                n2 = 1;
            }
            if (n2 == 1) {
                if (speckSet2.GetSizeX() == 1 && speckSet2.GetSizeY() == 1) {
                    n2 = (int)this.input.readUBits(1);
                    this.image[0][speckSet2.GetSetY()][speckSet2.GetSetX()] = n2 == 1 ? this.maxThreshold + this.maxThreshold / 2 : -this.maxThreshold - this.maxThreshold / 2;
                    this.LSP.AddSet(speckSet2);
                    continue;
                }
                if (this.method != 1) {
                    this.CodeS(speckSet2);
                    continue;
                }
                speckVector2.AddSet(speckSet2);
                continue;
            }
            ++n3;
            this.LIS.AddDynSet(speckSet2);
        }
        if (this.method == 1) {
            n = speckVector2.getLength();
            for (int i = 0; i < n; ++i) {
                speckSet2 = speckVector2.PopSet();
                this.CodeS(speckSet2);
            }
        }
    }

    public void ProcessI() throws IOException {
        int n = (int)this.input.readUBits(1);
        if (n == 1) {
            this.CodeI();
        }
    }

    public void CodeI() throws IOException {
        int n = 0;
        --this.SetIlevels;
        while (this.SetI[n].getLength() != 3) {
            ++n;
        }
        for (int i = 0; i < 3; ++i) {
            SpeckVector.SpeckSet speckSet = this.SetI[n].PopSet();
            this.ProcessS(speckSet);
        }
        this.ProcessI();
    }

    public void Refinement(int n) throws IOException {
        int n2 = 0;
        SpeckVector.SpeckSet speckSet = null;
        speckSet = new SpeckVector.SpeckSet();
        speckSet = this.LSP.top;
        for (int i = 0; i < n; ++i) {
            boolean bl = true;
            int n3 = (int)this.input.readUBits(1);
            n2 = this.image[0][speckSet.GetSetY()][speckSet.GetSetX()];
            if (n2 < 0) {
                bl = false;
                n2 = Math.abs(n2);
            }
            if (n3 == 1) {
                n2 += this.maxThreshold / 2;
                if (!bl) {
                    n2 = -n2;
                }
                this.image[0][speckSet.GetSetY()][speckSet.GetSetX()] = n2;
            } else {
                n2 = this.maxThreshold == 1 ? --n2 : (n2 -= this.maxThreshold / 2);
                if (!bl) {
                    n2 = -n2;
                }
                this.image[0][speckSet.GetSetY()][speckSet.GetSetX()] = n2;
            }
            speckSet = speckSet.NextSet();
        }
    }

    protected SpeckVector QuadriSect(SpeckVector.SpeckSet speckSet) {
        SpeckVector speckVector = null;
        speckVector = new SpeckVector();
        int n = speckSet.GetSizeX();
        int n2 = speckSet.GetSizeY();
        int n3 = speckSet.GetSetX();
        int n4 = speckSet.GetSetY();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n > 1 && n2 > 1) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    n5 = n / 2;
                    n6 = n2 / 2;
                    SpeckVector.SpeckSet speckSet2 = new SpeckVector.SpeckSet();
                    speckSet2.SetX(n3 + n5 * i);
                    speckSet2.SetY(n4 + n6 * j);
                    if (n % 2 == 1 && n7 > 1) {
                        ++n5;
                    }
                    if (n2 % 2 == 1 && (n7 == 1 || n7 == 3)) {
                        ++n6;
                    }
                    speckSet2.SetSize(n5, n6);
                    speckVector.AddSet(speckSet2);
                    ++n7;
                }
            }
        } else {
            if (n == 1) {
                n5 = 0;
                n6 = 1;
            } else {
                n5 = 1;
                n6 = 0;
            }
            for (int i = 0; i < n * n2; ++i) {
                SpeckVector.SpeckSet speckSet3 = new SpeckVector.SpeckSet();
                speckSet3.SetX(n3 + n5 * i);
                speckSet3.SetY(n4 + n6 * i);
                speckSet3.SetSize(1, 1);
                speckVector.AddSet(speckSet3);
            }
        }
        return speckVector;
    }
}

