/*
 * Decompiled with CFR 0.152.
 */
package Spiht.SpihtCoding;

import Building.LineBuilding;
import GiciBitStream.BitOutputStream;
import List.SpihtVector;
import Spiht.Spiht;
import java.io.FileOutputStream;
import java.io.IOException;

public class SpihtCoding1D
extends Spiht {
    protected int line = 0;
    protected SpihtVector LIC = null;
    protected SpihtVector LIS = null;
    protected SpihtVector LSC = null;
    protected BitOutputStream bos = null;
    protected long[][] table = null;
    protected long[][] errors = null;
    protected long[][] accessPoints = null;
    protected int[] imageRecovered = null;
    protected boolean rate = false;

    public SpihtCoding1D() {
        this.image = null;
        this.size = 0;
        this.line = 0;
    }

    public SpihtCoding1D(int[][][] nArray, int n, String string, boolean bl, long l) throws IOException {
        this.image = nArray;
        nArray = null;
        this.size = 0;
        this.line = 0;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.bos = new BitOutputStream(fileOutputStream, l);
        this.zSize = this.image.length;
        this.ySize = this.image[0].length;
        this.xSize = this.image[0][0].length;
        this.levels = n;
        this.method = 0;
        this.bos.writeUBits(this.xSize, 16);
        this.bos.writeUBits(this.ySize, 16);
        this.bos.writeUBits(n, 4);
        this.bos.writeUBits(this.method, 1);
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, n);
        this.limitParentX = this.xSize / 2;
        this.limitGrandParentX = this.xSize / 4;
    }

    @Override
    public void openOutputBitstream(String string, long l) throws IOException {
        if (this.bos != null) {
            throw new IOException("ERROR: The output bitstream is already open.");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.bos = new BitOutputStream(fileOutputStream, l);
    }

    @Override
    public void writeInitialHeader() throws IOException {
        if (this.bos == null) {
            throw new IOException("ERROR: The output bitstream is closed. Initial header is not written.");
        }
        this.bos.writeUBits(this.xSize, 16);
        this.bos.writeUBits(this.ySize, 16);
        this.bos.writeUBits(this.levels, 4);
        this.bos.writeUBits(this.method, 1);
    }

    @Override
    public void calculateSubbandLimits() throws Exception {
        if (this.xSize == 0) {
            throw new Exception("ERROR: The size of the image is not correct");
        }
        if (this.levels == 0) {
            throw new Exception("ERROR: The number of levels of the image is not correct");
        }
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, this.levels);
        this.limitParentX = this.xSize / 2;
        this.limitGrandParentX = this.xSize / 4;
    }

    @Override
    public void code(int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        this.rate = false;
        System.out.println("YSize: " + this.ySize + " XSize: " + this.xSize);
        this.line = 0;
        while (this.line < this.ySize) {
            n2 = 0;
            n3 = 0;
            this.LIC = new SpihtVector(this.xSize, 10, 1, false);
            this.LSC = new SpihtVector(this.xSize + this.xSize / 2, 10, 1, false);
            this.LIS = new SpihtVector(this.xSize, 10, 1, true);
            this.maxThreshold = this.initialTh();
            n3 = (int)(Math.log(this.maxThreshold) / Math.log(2.0));
            this.bos.writeUBits(n3, 5);
            this.listInitialize();
            while (this.maxThreshold > n) {
                n2 = this.LSC.size();
                try {
                    this.sort(this.maxThreshold);
                }
                catch (IOException iOException) {
                    this.bos.close();
                    throw new IOException(iOException.getMessage());
                }
                if (n2 != 0) {
                    try {
                        this.refinement(this.maxThreshold, n2);
                    }
                    catch (IOException iOException) {
                        this.bos.close();
                        System.out.println("Exception in code process: " + iOException.getMessage());
                        iOException.printStackTrace();
                        System.exit(0);
                    }
                }
                this.maxThreshold >>= 1;
            }
            ++this.line;
        }
        this.bos.close();
    }

    @Override
    public void codeRated(int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = null;
        this.size = 0;
        this.rate = true;
        this.table = new long[this.ySize][];
        this.errors = new long[this.ySize][];
        this.accessPoints = new long[this.ySize][];
        this.line = 0;
        while (this.line < this.ySize) {
            int n5;
            n4 = 0;
            n2 = 0;
            n3 = 0;
            this.LIC = new SpihtVector(this.xSize + this.xSize / 4, 10, 1, false);
            this.LSC = new SpihtVector(this.xSize + this.xSize / 4, 10, 1, false);
            this.LIS = new SpihtVector(this.xSize + this.xSize / 4, 10, 1, true);
            this.maxThreshold = this.initialTh();
            n3 = (int)(Math.log(this.maxThreshold) / Math.log(2.0));
            this.bos.writeUBits(n3, 5);
            nArray = new int[this.xSize];
            this.imageRecovered = new int[this.xSize];
            for (n5 = 0; n5 < this.xSize; ++n5) {
                nArray[n5] = this.image[0][this.line][n5];
                this.imageRecovered[n5] = 0;
            }
            this.table[this.line] = new long[n3 * 2 + 1];
            this.errors[this.line] = new long[n3 * 2 + 2];
            this.accessPoints[this.line] = new long[n3 * 2 + 2];
            this.accessPoints[this.line][n4] = this.size;
            this.listInitialize();
            this.errors[this.line][0] = this.computeSquareError(nArray, this.imageRecovered);
            while (this.maxThreshold > n) {
                n2 = this.LSC.size();
                try {
                    this.sort(this.maxThreshold);
                }
                catch (IOException iOException) {
                    this.bos.close();
                    throw new IOException(iOException.getMessage());
                }
                this.errors[this.line][n4 + 1] = this.computeSquareError(nArray, this.imageRecovered);
                this.table[this.line][n4] = this.errors[this.line][n4] - this.errors[this.line][n4 + 1];
                this.accessPoints[this.line][++n4] = this.size;
                if (n2 != 0) {
                    try {
                        this.refinement(this.maxThreshold, n2);
                    }
                    catch (IOException iOException) {
                        this.bos.close();
                        throw new IOException(iOException.getMessage());
                    }
                    this.errors[this.line][n4 + 1] = this.computeSquareError(nArray, this.imageRecovered);
                    this.table[this.line][n4] = this.errors[this.line][n4] - this.errors[this.line][n4 + 1];
                    this.accessPoints[this.line][++n4] = this.size;
                }
                this.maxThreshold >>= 1;
            }
            if (this.errors[this.line][this.errors[this.line].length - 1] != 0L) {
                System.out.println("No se ha recuperado bien");
                System.exit(0);
            }
            n5 = 0;
            for (int i = 0; i < this.table[this.line].length; ++i) {
                n5 = (int)((long)n5 + this.table[this.line][i]);
            }
            if ((long)n5 != this.errors[this.line][0]) {
                System.out.println("Suma: " + this.errors[this.line][0] + " Total: " + n5);
                System.exit(0);
            }
            ++this.line;
        }
        this.bos.close();
    }

    @Override
    public void codeBuilding(int n) throws Exception {
        boolean bl = false;
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, this.levels) * this.ySize;
        this.limitParentX = this.xSize / 2 * this.ySize;
        this.limitGrandParentX = this.xSize / 4 * this.ySize;
        try {
            LineBuilding lineBuilding = new LineBuilding(this.image, this.levels);
            this.image = lineBuilding.obtainReorganizedImage();
        }
        catch (Exception exception) {
            System.out.println("Reorganization LB error: " + exception.getMessage());
            exception.printStackTrace();
            System.exit(0);
        }
        this.xSize *= this.ySize;
        this.ySize = 1;
        this.code(n);
        this.image = null;
    }

    @Override
    public void codeInterleaved(int n) throws Exception {
        int n2 = 0;
        boolean bl = false;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        boolean bl2 = false;
        int[] nArray = null;
        int[] nArray2 = null;
        Object var9_9 = null;
        nArray = new int[this.ySize];
        nArray2 = new int[this.ySize];
        this.line = 0;
        while (this.line < this.ySize) {
            nArray[this.line] = this.initialTh();
            nArray2[this.line] = (int)(Math.log(nArray[this.line]) / Math.log(2.0));
            if (n4 < nArray2[this.line]) {
                n4 = nArray2[this.line];
            }
            if (n3 > nArray2[this.line]) {
                n3 = nArray2[this.line];
            }
            ++this.line;
        }
        this.line = 0;
        SpihtVector[] spihtVectorArray = new SpihtVector[this.ySize];
        SpihtVector[] spihtVectorArray2 = new SpihtVector[this.ySize];
        SpihtVector[] spihtVectorArray3 = new SpihtVector[this.ySize];
        this.LIC = new SpihtVector(this.xSize + this.xSize / 4, 10, 1, false);
        this.LIS = new SpihtVector(this.xSize + this.xSize / 4, 10, 1, true);
        this.listInitialize();
        System.out.println("maxBPE: " + n4);
        System.out.println("minBPE: " + n3);
        this.bos.writeUBits(n4, 5);
        this.bos.writeUBits(n3, 5);
        for (int i = 0; i < this.ySize; ++i) {
            if (n4 != n3) {
                this.bos.writeUBits(nArray2[i] - n3, BitOutputStream.minBits(n4 - n3));
                this.size += BitOutputStream.minBits(n4 - n3);
            }
            spihtVectorArray[i] = this.LIS.cloneObject();
            spihtVectorArray2[i] = this.LIC.cloneObject();
            spihtVectorArray3[i] = new SpihtVector(this.xSize + this.xSize / 4, 10, 1, false);
        }
        this.LIS = null;
        this.LIC = null;
        while (n4 != n3) {
            this.line = 0;
            while (this.line < this.ySize) {
                if (nArray2[this.line] > n3) {
                    this.LIS = spihtVectorArray[this.line];
                    this.LIC = spihtVectorArray2[this.line];
                    this.LSC = spihtVectorArray3[this.line];
                    this.maxThreshold = nArray[this.line];
                    try {
                        n2 = this.LSC.size();
                        this.sort(this.maxThreshold);
                        if (n2 != 0) {
                            this.refinement(this.maxThreshold, n2);
                        }
                    }
                    catch (IOException iOException) {
                        this.bos.close();
                        throw new Exception(iOException.getMessage());
                    }
                    nArray[this.line] = this.maxThreshold >> 1;
                    int n5 = this.line;
                    nArray2[n5] = nArray2[n5] - 1;
                    spihtVectorArray[this.line] = this.LIS;
                    spihtVectorArray2[this.line] = this.LIC;
                    spihtVectorArray3[this.line] = this.LSC;
                    this.LIS = null;
                    this.LSC = null;
                    this.LIC = null;
                }
                ++this.line;
            }
            --n4;
        }
        nArray2 = null;
        this.maxThreshold = 1;
        while (this.maxThreshold != 0) {
            this.line = 0;
            while (this.line < this.ySize) {
                this.LIS = spihtVectorArray[this.line];
                this.LIC = spihtVectorArray2[this.line];
                this.LSC = spihtVectorArray3[this.line];
                this.maxThreshold = nArray[this.line];
                try {
                    n2 = this.LSC.size();
                    this.sort(this.maxThreshold);
                    if (n2 != 0) {
                        this.refinement(this.maxThreshold, n2);
                    }
                }
                catch (IOException iOException) {
                    this.bos.close();
                    throw new Exception(iOException.getMessage());
                }
                this.maxThreshold >>= 1;
                nArray[this.line] = this.maxThreshold;
                spihtVectorArray[this.line] = this.LIS;
                spihtVectorArray2[this.line] = this.LIC;
                spihtVectorArray3[this.line] = this.LSC;
                this.LIS = null;
                this.LSC = null;
                this.LIC = null;
                ++this.line;
            }
        }
        this.bos.close();
    }

    protected void sort(int n) throws Exception {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = this.LIC.size();
        int[] nArray = new int[n5];
        int n6 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = this.getSample(this.LIC.getX(n3), this.line, 0);
            if (Math.abs(n2) >= n) {
                this.bos.writeMulti(1);
                ++n4;
                this.LSC.addElement(this.LIC.getX(n3));
                nArray[n6] = n3;
                ++n6;
                if (n2 < 0) {
                    this.bos.writeMulti(0);
                    if (this.rate) {
                        this.imageRecovered[this.LIC.getX((int)n3)] = -(n + (n >> 1));
                    }
                } else {
                    this.bos.writeMulti(1);
                    if (this.rate) {
                        this.imageRecovered[this.LIC.getX((int)n3)] = n + (n >> 1);
                    }
                }
                ++n4;
                continue;
            }
            this.bos.writeMulti(0);
            ++n4;
        }
        this.LIC.removeCollectionOfElements(nArray, n6);
        for (n6 = 0; n6 < this.LIS.size(); ++n6) {
            int n7;
            if (!this.LIS.getType(n6)) {
                if (this.significativeDescendent(this.LIS.getX(n6), true)) {
                    this.bos.writeMulti(1);
                    ++n4;
                    for (n7 = 1; n7 <= 2; ++n7) {
                        n3 = this.children(this.LIS.getX(n6), n7);
                        n2 = this.getSample(n3, this.line, 0);
                        if (Math.abs(n2) >= n) {
                            this.bos.writeMulti(1);
                            ++n4;
                            this.LSC.addElement(n3);
                            if (n2 < 0) {
                                if (this.rate) {
                                    this.imageRecovered[n3] = -(n + (n >> 1));
                                }
                                this.bos.writeMulti(0);
                                ++n4;
                                continue;
                            }
                            if (this.rate) {
                                this.imageRecovered[n3] = n + (n >> 1);
                            }
                            this.bos.writeMulti(1);
                            ++n4;
                            continue;
                        }
                        this.LIC.addElement(n3);
                        this.bos.writeMulti(0);
                        ++n4;
                    }
                    if (this.isGrandParent(this.LIS.getX(n6))) {
                        if (this.method == 1) {
                            this.LIS.addElement(this.LIS.getX(n6), true);
                            this.LIS.removeElement(n6);
                            --n6;
                            continue;
                        }
                        if (this.method != 0) continue;
                        if (this.significativeDescendent(this.LIS.getX(n6), false)) {
                            this.bos.writeMulti(1);
                            ++n4;
                            for (n7 = 1; n7 <= 2; ++n7) {
                                n3 = this.children(this.LIS.getX(n6), n7);
                                this.LIS.addElement(n3, false);
                            }
                            this.LIS.removeElement(n6);
                            --n6;
                            continue;
                        }
                        this.bos.writeMulti(0);
                        ++n4;
                        this.LIS.setType(n6, true);
                        continue;
                    }
                    this.LIS.removeElement(n6);
                    --n6;
                    continue;
                }
                this.bos.writeMulti(0);
                ++n4;
                continue;
            }
            if (this.significativeDescendent(this.LIS.getX(n6), false)) {
                this.bos.writeMulti(1);
                ++n4;
                for (n7 = 1; n7 <= 2; ++n7) {
                    n3 = this.children(this.LIS.getX(n6), n7);
                    this.LIS.addElement(n3, false);
                }
                this.LIS.removeElement(n6);
                --n6;
                continue;
            }
            this.bos.writeMulti(0);
            ++n4;
        }
        this.size += n4;
    }

    protected void refinement(int n, int n2) throws Exception {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            int n4;
            int n5;
            int n6 = Math.abs(this.getSample(this.LSC.getX(i), this.line, 0));
            if ((n & n6) != 0) {
                n5 = 1;
                if (this.rate) {
                    n4 = this.imageRecovered[this.LSC.getX(i)];
                    bl = false;
                    if (n4 < 0) {
                        bl = true;
                        n4 = -n4;
                    }
                    n4 += n >> 1;
                    if (bl) {
                        n4 = -n4;
                    }
                    this.imageRecovered[this.LSC.getX((int)i)] = n4;
                }
            } else {
                n5 = 0;
                if (this.rate) {
                    n4 = this.imageRecovered[this.LSC.getX(i)];
                    bl = false;
                    if (n4 < 0) {
                        bl = true;
                        n4 = -n4;
                    }
                    n4 = n == 1 ? --n4 : (n4 -= n >> 1);
                    if (bl) {
                        n4 = -n4;
                    }
                    this.imageRecovered[this.LSC.getX((int)i)] = n4;
                }
            }
            this.bos.writeMulti(n5);
            ++n3;
        }
        this.size += n3;
    }

    protected boolean significativeDescendent(int n, boolean bl) {
        if (this.isParent(n)) {
            int n2 = this.children(n, 1);
            int n3 = this.children(n, 2);
            if (bl) {
                if (Math.abs(this.getSample(n2, this.line, 0)) >= this.maxThreshold) {
                    return true;
                }
                if (Math.abs(this.getSample(n3, this.line, 0)) >= this.maxThreshold) {
                    return true;
                }
            }
            if (this.significativeDescendent(n2, true)) {
                return true;
            }
            if (this.significativeDescendent(n3, true)) {
                return true;
            }
        }
        return false;
    }

    protected int initialTh() {
        int n = Math.abs(this.image[0][this.line][0]);
        for (int i = 0; i < this.xSize; ++i) {
            int n2 = Math.abs(this.image[0][this.line][i]);
            if (n2 <= n) continue;
            n = n2;
        }
        return (int)Math.pow(2.0, (int)(Math.log(n) / Math.log(2.0)));
    }

    protected void listInitialize() {
        for (int i = 0; i < this.limitResidualBandX; ++i) {
            this.LIC.addElement(i);
            if (!this.isParent(i)) continue;
            this.LIS.addElement(i, false);
        }
    }

    protected long computeSquareError(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            long l2 = nArray[i] - nArray2[i];
            l += l2 * l2;
        }
        return l;
    }

    @Override
    public long[][] getTable() {
        return this.table;
    }

    @Override
    public long[][] getAccessPoints() {
        return this.accessPoints;
    }
}

