/*
 * Decompiled with CFR 0.152.
 */
package Spiht;

import GiciAnalysis.ImageCompare;
import GiciFile.LoadFile;
import GiciFile.SaveFile;
import GiciImageExtension.ImageDeExtension;
import GiciTransform.InverseWaveletTransform;
import Spiht.Spiht;
import Spiht.SpihtDecoding.ArgsParser;
import Spiht.SpihtDecoding.SpihtDecoding1D;
import Spiht.SpihtDecoding.SpihtDecoding2D;
import Spiht.SpihtDecoding.SpihtDecoding3D;
import java.io.IOException;

public class SpihtDecode {
    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        Class[] classArray;
        int n4;
        ArgsParser argsParser = null;
        try {
            argsParser = new ArgsParser(stringArray);
        }
        catch (Exception exception) {
            System.out.println("ARGUMENTS ERROR: " + exception.getMessage());
            System.exit(1);
        }
        int n5 = argsParser.getDimension();
        int[] nArray = argsParser.getWTLevels();
        int[] nArray2 = argsParser.getWTTypes();
        float[][][] fArray = null;
        try {
            Object object;
            int[][][] nArray3 = null;
            try {
                if (n5 == 1) {
                    object = new SpihtDecoding1D(argsParser.getFileName());
                } else if (n5 == 2) {
                    object = new SpihtDecoding2D(argsParser.getFileName());
                } else if (n5 == 3) {
                    object = new SpihtDecoding3D(argsParser.getFileName());
                } else {
                    throw new Exception("The dimension specified is not avaible");
                }
                if (argsParser.getBuilding()) {
                    ((Spiht)object).decodeBuilding();
                } else if (argsParser.getInterleaved()) {
                    ((Spiht)object).decodeInterleaved();
                } else if (argsParser.getRateDistortion() != null) {
                    ((Spiht)object).decodeRated(argsParser.getRateDistortion());
                } else {
                    ((Spiht)object).decode();
                }
                nArray3 = ((Spiht)object).getImage();
            }
            catch (IOException iOException) {
                System.out.println("An Input/Output exception ocurred in the " + n5 + "D decode process: " + iOException.getMessage());
                System.exit(2);
            }
            catch (Exception exception) {
                System.out.println("An exception ocurred in the " + n5 + "D decode process: " + exception.getMessage());
                System.exit(3);
            }
            try {
                object = new int[1];
                n4 = nArray3.length;
                object[0] = 2;
                classArray = new InverseWaveletTransform(SpihtDecode.integerToFloat(nArray3));
                if (n5 == 1) {
                    classArray.setParameters(nArray2, nArray, (int[])object);
                } else {
                    if (n4 > 1) {
                        n3 = nArray2[0];
                        n2 = nArray[0];
                        nArray = new int[n4];
                        nArray2 = new int[n4];
                        for (n = 0; n < n4; ++n) {
                            nArray2[n] = n3;
                            nArray[n] = n2;
                        }
                    }
                    classArray.setParameters(nArray2, nArray);
                }
                fArray = classArray.run();
            }
            catch (Exception exception) {
                System.out.println("DISCRETE WAVELET TRANSFORM ERROR: " + exception.getMessage());
                System.exit(4);
            }
        }
        catch (Exception exception) {
            System.out.println("DECODER PROCESS ERROR: " + exception.getMessage());
            System.exit(5);
        }
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < ((void)fArray[i]).length; ++j) {
                for (n4 = 0; n4 < ((void)fArray[i][j]).length; ++n4) {
                    if (fArray[i][j][n4] < 0.0f) {
                        fArray[i][j][n4] = 0.0f;
                    }
                    if (!(fArray[i][j][n4] > 255.0f)) continue;
                    fArray[i][j][n4] = 255.0f;
                }
            }
        }
        String string = argsParser.getCompareImage();
        if (string != null) {
            try {
                LoadFile loadFile = null;
                if (string.endsWith(".raw")) {
                    classArray = (Class[])argsParser.getImageGeometry();
                    if (classArray[0] <= 0 || classArray[1] <= 0 || classArray[2] <= 0) {
                        throw new Exception("Image dimensions in \".raw\" data files must be positive (\"-h\" displays help).");
                    }
                    if (classArray[3] < 0 || classArray[3] > 7) {
                        throw new Exception("Image type in \".raw\" data must be between 0 to 7 (\"-h\" displays help).");
                    }
                    if (classArray[4] != false && classArray[4] != true) {
                        throw new Exception("Image Endian specification in \".raw\" data must be between 0 or 1 (\"-h\" displays help).");
                    }
                    if (classArray[5] != false && classArray[5] != true) {
                        throw new Exception("Image RGB specification in \".raw\" data must be between 0 or 1 (\"-h\" displays help).");
                    }
                    loadFile = new LoadFile(string, (int)classArray[0], (int)classArray[1], (int)classArray[2], (int)classArray[3], (int)classArray[4], classArray[5] != false);
                } else {
                    loadFile = new LoadFile(string);
                }
                float[][][] fArray2 = loadFile.getImage();
                try {
                    classArray = new ImageDeExtension(fArray);
                    classArray.setParameters(fArray2[0][0].length, fArray2[0].length, fArray2.length);
                    fArray = classArray.run();
                }
                catch (Exception exception) {
                    System.out.println("IMAGE DEEXTENSION ERROR: " + exception.getMessage());
                    System.exit(4);
                }
                classArray = loadFile.getTypes();
                n3 = 1;
                for (n2 = 1; n2 < fArray.length; ++n2) {
                    if (classArray[n2 - 1] == classArray[n2]) continue;
                    n3 = 0;
                }
                if (n3 != 0) {
                    int[] nArray4 = new int[fArray.length];
                    nArray4[0] = 16;
                    if (classArray[0] == Byte.TYPE) {
                        nArray4[0] = 8;
                    } else if (classArray[0] == Integer.TYPE) {
                        nArray4[0] = 32;
                    } else if (classArray[0] == Character.TYPE || classArray[0] == Short.TYPE) {
                        nArray4[0] = 16;
                    } else {
                        System.out.println("Wrong image type");
                        System.exit(1);
                    }
                    for (n = 1; n < fArray.length; ++n) {
                        nArray4[n] = nArray4[0];
                    }
                    ImageCompare imageCompare = new ImageCompare(fArray2, fArray, nArray4);
                    float f = imageCompare.getTotalMSE();
                    float f2 = imageCompare.getTotalPSNR();
                    float f3 = imageCompare.getTotalSNR();
                    System.out.print(f2 + " " + f + "\n");
                } else {
                    System.err.println("IMAGE COMPARE ERROR: Sample type of all image components must be the same.");
                }
            }
            catch (Exception exception) {
                System.err.println("IMAGE COMPARE ERROR: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        for (n4 = 0; n4 < fArray.length; ++n4) {
            for (int i = 0; i < ((void)fArray[n4]).length; ++i) {
                for (n3 = 0; n3 < ((void)fArray[n4][i]).length; ++n3) {
                    if (fArray[n4][i][n3] < 0.0f) {
                        fArray[n4][i][n3] = 0.0f;
                    }
                    if (!(fArray[n4][i][n3] > 255.0f)) continue;
                    fArray[n4][i][n3] = 255.0f;
                }
            }
        }
        String string2 = argsParser.getOutFile();
        if (string2 != null) {
            try {
                if (string.endsWith(".raw")) {
                    SaveFile.SaveFileRaw(fArray, string2, 1, 0);
                } else if (string.endsWith(".pgm")) {
                    SaveFile.SaveFileFormat(fArray, string2, 0);
                } else {
                    System.out.println("The image type is not avaible to save.");
                }
            }
            catch (Exception exception) {
                System.err.println("IMAGE SAVING ERROR: " + exception.getMessage());
            }
        }
    }

    private static float[][][] integerToFloat(int[][][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        int n3 = nArray[0][0].length;
        float[][][] fArray = new float[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    fArray[i][j][k] = nArray[i][j][k];
                }
            }
        }
        return fArray;
    }
}

