/*
 * Decompiled with CFR 0.152.
 */
package Spiht.SpihtDecoding;

import Building.LineBuilding;
import GiciBitStream.BitInputStream;
import GiciBitStream.BitOutputStream;
import List.SpihtVector;
import Spiht.Spiht;
import java.io.FileInputStream;
import java.io.IOException;

public class SpihtDecoding1D
extends Spiht {
    protected int line = 0;
    protected SpihtVector LIC = null;
    protected SpihtVector LIS = null;
    protected SpihtVector LSC = null;
    protected BitInputStream bis;
    protected int positionInLSC = 0;
    protected int numberReadBits = 0;
    protected String[] ratedList = new String[]{"rd1tp", "rd2tp", "rdch"};

    public SpihtDecoding1D(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.bis = new BitInputStream(fileInputStream);
        this.xSize = (int)this.bis.readUBits(16);
        this.ySize = (int)this.bis.readUBits(16);
        this.levels = (int)this.bis.readUBits(4);
        this.method = (int)this.bis.readUBits(1);
        this.numberReadBits = 37;
        this.image = new int[1][this.ySize][this.xSize];
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, this.levels);
        this.limitParentX = this.xSize / 2;
        this.limitGrandParentX = this.xSize / 4;
    }

    @Override
    public void decode() throws Exception {
        int n = 0;
        this.line = 0;
        while (this.line < this.ySize) {
            int n2 = 0;
            try {
                this.LIC = new SpihtVector(this.xSize + this.xSize / 2, 10, 1, false);
                this.LSC = new SpihtVector(this.xSize + this.xSize / 2, 10, 1, false);
                this.LIS = new SpihtVector(this.xSize + this.xSize / 2, 10, 1, true);
                this.readThreshold();
                this.listInitialize();
                while (this.maxThreshold > n) {
                    n2 = this.LSC.size();
                    try {
                        this.sort(this.maxThreshold);
                    }
                    catch (IOException iOException) {
                        this.bis.close();
                        throw new IOException(iOException.getMessage());
                    }
                    if (n2 != 0) {
                        try {
                            this.refinement(this.maxThreshold, n2);
                        }
                        catch (IOException iOException) {
                            this.bis.close();
                            throw new IOException(iOException.getMessage());
                        }
                    }
                    this.maxThreshold >>= 1;
                }
            }
            catch (IOException iOException) {
                this.bis.close();
            }
            ++this.line;
        }
        this.bis.close();
    }

    @Override
    public void decodeRated(String string) throws Exception {
        int n;
        boolean bl = false;
        int n2 = 0;
        int n3 = -1;
        for (n = 0; n < this.ratedList.length; ++n) {
            if (!this.ratedList[n].equals(string)) continue;
            n3 = n;
            break;
        }
        if (n3 == -1) {
            throw new Exception("The rate mode " + string + " is not avaible");
        }
        int n4 = (int)Math.ceil(Math.log(this.ySize) / Math.log(2.0));
        SpihtVector[] spihtVectorArray = new SpihtVector[this.ySize];
        SpihtVector[] spihtVectorArray2 = new SpihtVector[this.ySize];
        SpihtVector[] spihtVectorArray3 = new SpihtVector[this.ySize];
        this.LIC = new SpihtVector(this.xSize + this.xSize / 4, 10, 1, false);
        this.LIS = new SpihtVector(this.xSize + this.xSize / 4, 10, 1, true);
        this.listInitialize();
        for (n = 0; n < this.ySize; ++n) {
            spihtVectorArray[n] = this.LIS.cloneObject();
            spihtVectorArray2[n] = this.LIC.cloneObject();
            spihtVectorArray3[n] = new SpihtVector(this.xSize + this.xSize / 4, 10, 1, false);
        }
        int[] nArray = new int[this.ySize];
        int[] nArray2 = new int[this.ySize];
        int[] nArray3 = new int[this.ySize];
        for (n = 0; n < this.ySize; ++n) {
            nArray[n] = 0;
            nArray2[n] = 0;
            nArray3[n] = 0;
        }
        this.positionInLSC = 0;
        try {
            while (true) {
                this.line = (int)this.bis.readUBits(n4);
                if (n3 == 2) {
                    n2 = 1;
                    while ((int)this.bis.readUBits(1) != 1) {
                        ++n2;
                    }
                }
                this.LIS = spihtVectorArray[this.line];
                this.LIC = spihtVectorArray2[this.line];
                this.LSC = spihtVectorArray3[this.line];
                this.positionInLSC = nArray[this.line];
                if (nArray3[this.line] == 0) {
                    this.readThreshold();
                } else {
                    this.maxThreshold = nArray2[this.line];
                }
                if (n3 == 0) {
                    this.positionInLSC = this.LSC.size();
                    this.sort(this.maxThreshold);
                    if (this.positionInLSC != 0) {
                        this.refinement(this.maxThreshold, this.positionInLSC);
                    }
                    this.maxThreshold >>= 1;
                    int n5 = this.line;
                    nArray3[n5] = nArray3[n5] + 1;
                }
                if (n3 == 1) {
                    if (nArray3[this.line] == 0 || nArray3[this.line] % 2 != 0) {
                        this.positionInLSC = this.LSC.size();
                        this.sort(this.maxThreshold);
                        if (nArray3[this.line] == 0) {
                            this.maxThreshold >>= 1;
                        }
                    } else {
                        if (this.positionInLSC != 0) {
                            this.refinement(this.maxThreshold, this.positionInLSC);
                        }
                        this.maxThreshold >>= 1;
                    }
                    int n6 = this.line;
                    nArray3[n6] = nArray3[n6] + 1;
                }
                if (n3 == 2) {
                    for (n = 0; n < n2; ++n) {
                        if (nArray3[this.line] == 0 || nArray3[this.line] % 2 != 0) {
                            this.positionInLSC = this.LSC.size();
                            this.sort(this.maxThreshold);
                            if (nArray3[this.line] == 0) {
                                this.maxThreshold >>= 1;
                            }
                        } else {
                            if (this.positionInLSC != 0) {
                                this.refinement(this.maxThreshold, this.positionInLSC);
                            }
                            this.maxThreshold >>= 1;
                        }
                        int n7 = this.line;
                        nArray3[n7] = nArray3[n7] + 1;
                    }
                }
                nArray2[this.line] = this.maxThreshold;
                spihtVectorArray[this.line] = this.LIS;
                spihtVectorArray2[this.line] = this.LIC;
                spihtVectorArray3[this.line] = this.LSC;
                this.LIS = null;
                this.LIC = null;
                this.LSC = null;
                nArray[this.line] = this.positionInLSC;
            }
        }
        catch (IOException iOException) {
            this.bis.close();
            return;
        }
    }

    @Override
    public void decodeBuilding() throws Exception {
        this.limitResidualBandX = this.xSize / (int)Math.pow(2.0, this.levels) * this.ySize;
        this.limitParentX = this.xSize / 2 * this.ySize;
        this.limitGrandParentX = this.xSize / 4 * this.ySize;
        int n = this.xSize;
        int n2 = this.ySize;
        this.xSize *= this.ySize;
        this.ySize = 1;
        this.image = new int[1][this.ySize][this.xSize];
        this.decode();
        LineBuilding lineBuilding = new LineBuilding(n, n2, this.levels);
        this.image = lineBuilding.obtainOriginalImage(this.image);
    }

    @Override
    public void decodeInterleaved() throws Exception {
        this.positionInLSC = 0;
        int n = 0;
        int[] nArray = new int[this.ySize];
        int[] nArray2 = new int[this.ySize];
        int[] nArray3 = new int[this.ySize];
        SpihtVector[] spihtVectorArray = new SpihtVector[this.ySize];
        SpihtVector[] spihtVectorArray2 = new SpihtVector[this.ySize];
        SpihtVector[] spihtVectorArray3 = new SpihtVector[this.ySize];
        this.LIC = new SpihtVector(this.xSize + this.xSize / 4, 10, 1, false);
        this.LIS = new SpihtVector(this.xSize + this.xSize / 4, 10, 1, true);
        this.listInitialize();
        try {
            int n2 = (int)this.bis.readUBits(5);
            int n3 = (int)this.bis.readUBits(5);
            for (int i = 0; i < this.ySize; ++i) {
                nArray2[i] = n2 != n3 ? n3 + (int)this.bis.readUBits(BitOutputStream.minBits(n2 - n3)) : n3;
                nArray[i] = (int)Math.pow(2.0, nArray2[i]);
                spihtVectorArray[i] = this.LIS.cloneObject();
                spihtVectorArray2[i] = this.LIC.cloneObject();
                spihtVectorArray3[i] = new SpihtVector(this.xSize + this.xSize / 4, 10, 1, false);
            }
            this.LIS = null;
            this.LIC = null;
            while (n < this.ySize - 1) {
                n = 0;
                this.line = 0;
                while (this.line < this.ySize) {
                    if (nArray2[this.line] > n3) {
                        this.LIS = spihtVectorArray[this.line];
                        this.LIC = spihtVectorArray2[this.line];
                        this.LSC = spihtVectorArray3[this.line];
                        this.maxThreshold = nArray[this.line];
                        this.positionInLSC = nArray3[this.line];
                        this.positionInLSC = this.LSC.size();
                        this.sort(this.maxThreshold);
                        if (this.positionInLSC != 0) {
                            this.refinement(this.maxThreshold, this.positionInLSC);
                        }
                        nArray[this.line] = this.maxThreshold >> 1;
                        nArray3[this.line] = this.positionInLSC;
                        int n4 = this.line;
                        nArray2[n4] = nArray2[n4] - 1;
                        spihtVectorArray[this.line] = this.LIS;
                        spihtVectorArray2[this.line] = this.LIC;
                        spihtVectorArray3[this.line] = this.LSC;
                        this.LIS = null;
                        this.LSC = null;
                        this.LIC = null;
                    } else if (nArray2[this.line] == n3) {
                        ++n;
                    }
                    ++this.line;
                }
            }
            nArray2 = null;
            this.maxThreshold = 1;
            while (this.maxThreshold != 0) {
                n = 0;
                this.line = 0;
                while (this.line < this.ySize) {
                    this.LIS = spihtVectorArray[this.line];
                    this.LIC = spihtVectorArray2[this.line];
                    this.LSC = spihtVectorArray3[this.line];
                    this.maxThreshold = nArray[this.line];
                    this.positionInLSC = nArray3[this.line];
                    this.positionInLSC = this.LSC.size();
                    this.sort(this.maxThreshold);
                    if (this.positionInLSC != 0) {
                        this.refinement(this.maxThreshold, this.positionInLSC);
                    }
                    this.maxThreshold >>= 1;
                    nArray[this.line] = this.maxThreshold;
                    nArray3[this.line] = this.positionInLSC;
                    spihtVectorArray[this.line] = this.LIS;
                    spihtVectorArray2[this.line] = this.LIC;
                    spihtVectorArray3[this.line] = this.LSC;
                    this.LIS = null;
                    this.LSC = null;
                    this.LIC = null;
                    ++this.line;
                }
            }
        }
        catch (IOException iOException) {
            this.bis.close();
        }
        this.bis.close();
    }

    public void decodeRefinementPass() throws IOException {
        if (this.maxThreshold == 0) {
            this.refinement(1, this.positionInLSC);
        } else {
            this.refinement(this.maxThreshold << 1, this.positionInLSC);
        }
    }

    public void decodeSortingPass() throws Exception {
        if (this.maxThreshold != 0) {
            this.positionInLSC = this.LSC.size();
            this.sort(this.maxThreshold);
            this.maxThreshold >>= 1;
        }
    }

    protected void sort(int n) throws Exception {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.LIC.size();
        int[] nArray = new int[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = this.bis.readMulti();
            ++n4;
            if (n2 != 1) continue;
            n2 = this.bis.readMulti();
            ++n4;
            if (n2 == 1) {
                this.setSample(this.LIC.getX(n3), this.line, 0, n + n / 2);
            } else {
                this.setSample(this.LIC.getX(n3), this.line, 0, -n - n / 2);
            }
            this.LSC.addElement(this.LIC.getX(n3));
            nArray[n5] = n3;
            ++n5;
        }
        this.LIC.removeCollectionOfElements(nArray, n5);
        for (n5 = 0; n5 < this.LIS.size(); ++n5) {
            int n7;
            if (!this.LIS.getType(n5)) {
                n2 = this.bis.readMulti();
                ++n4;
                if (n2 != 1) continue;
                for (n7 = 1; n7 <= 2; ++n7) {
                    n3 = this.children(this.LIS.getX(n5), n7);
                    n2 = this.bis.readMulti();
                    ++n4;
                    if (n2 == 1) {
                        this.LSC.addElement(n3);
                        n2 = this.bis.readMulti();
                        ++n4;
                        if (n2 == 1) {
                            this.setSample(n3, this.line, 0, n + n / 2);
                            continue;
                        }
                        this.setSample(n3, this.line, 0, -n - n / 2);
                        continue;
                    }
                    this.LIC.addElement(n3);
                }
                if (this.isGrandParent(this.LIS.getX(n5))) {
                    if (this.method == 1) {
                        this.LIS.addElement(this.LIS.getX(n5), true);
                        this.LIS.removeElement(n5);
                        --n5;
                        continue;
                    }
                    if (this.method != 0) continue;
                    n2 = this.bis.readMulti();
                    ++n4;
                    if (n2 == 1) {
                        for (n7 = 1; n7 <= 2; ++n7) {
                            n3 = this.children(this.LIS.getX(n5), n7);
                            this.LIS.addElement(n3, false);
                        }
                        this.LIS.removeElement(n5);
                        --n5;
                        continue;
                    }
                    this.LIS.setType(n5, true);
                    continue;
                }
                this.LIS.removeElement(n5);
                --n5;
                continue;
            }
            n2 = this.bis.readMulti();
            ++n4;
            if (n2 != 1) continue;
            for (n7 = 1; n7 <= 2; ++n7) {
                n3 = this.children(this.LIS.getX(n5), n7);
                this.LIS.addElement(n3, false);
            }
            this.LIS.removeElement(n5);
            --n5;
        }
        this.numberReadBits += n4;
    }

    protected void refinement(int n, int n2) throws IOException {
        int n3 = 0;
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.getSample(this.LSC.getX(i), this.line, 0);
            if (n4 < 0) {
                bl = false;
                n4 = Math.abs(n4);
            }
            int n5 = this.bis.readMulti();
            ++n3;
            if (n5 == 1) {
                n4 += n / 2;
                if (!bl) {
                    n4 = -n4;
                }
                this.setSample(this.LSC.getX(i), this.line, 0, n4);
            } else {
                n4 = n == 1 ? --n4 : (n4 -= n / 2);
                if (!bl) {
                    n4 = -n4;
                }
                this.setSample(this.LSC.getX(i), this.line, 0, n4);
            }
            bl = true;
        }
        this.numberReadBits += n3;
    }

    protected void listInitialize() {
        for (int i = 0; i < this.limitResidualBandX; ++i) {
            this.LIC.addElement(i);
            if (!this.isParent(i)) continue;
            this.LIS.addElement(i, false);
        }
    }

    public void readThreshold() throws IOException {
        this.maxThreshold = (int)Math.pow(2.0, (int)this.bis.readUBits(5));
    }

    public BitInputStream getInputStream() {
        return this.bis;
    }

    public int getNumberReadBits() {
        return this.numberReadBits;
    }
}

