/*
 * Decompiled with CFR 0.152.
 */
package BitAllocation;

public class ConvexHull {
    long[] lengths = null;
    long[] errors = null;
    int firstPoint;
    int numPoints;
    int[] CHFeasiblePoints = null;
    double[] CHSlopes = null;

    public ConvexHull(long[] lArray, long[] lArray2) {
        this.lengths = lArray;
        this.errors = lArray2;
        this.numPoints = this.numPoints;
        this.firstPoint = 0;
        this.numPoints = lArray.length <= lArray2.length ? lArray.length : lArray2.length;
    }

    public void setParameters(int n, int n2) throws Exception {
        this.firstPoint = n;
        this.numPoints = n2;
        if (n < 0 || n >= this.lengths.length || n >= this.errors.length) {
            throw new Exception("First point to consider in convex hull algorithm must be greater than 0 and less than array lengths.");
        }
        if (n2 <= 1) {
            throw new Exception("Number of points to consider in convell hull algorithm is too smaller.");
        }
        if (n + n2 > this.lengths.length || n + n2 > this.errors.length) {
            throw new Exception("Number of points to consider in convell hull algorithm is too much bigger.");
        }
    }

    public void run() {
        int n;
        int n2;
        int[] nArray = new int[this.numPoints + 1];
        double[] dArray = new double[this.numPoints + 1];
        long[] lArray = new long[this.numPoints + 1];
        long[] lArray2 = new long[this.numPoints + 1];
        lArray[0] = 0L;
        lArray2[0] = 0L;
        for (n2 = this.firstPoint; n2 < this.firstPoint + this.numPoints; ++n2) {
            lArray2[0] = lArray2[0] + this.errors[n2];
        }
        for (n2 = this.firstPoint; n2 < this.firstPoint + this.numPoints; ++n2) {
            lArray[n2 - this.firstPoint + 1] = lArray[n2 - this.firstPoint] + this.lengths[n2];
            lArray2[n2 - this.firstPoint + 1] = lArray2[n2 - this.firstPoint] - this.errors[n2];
        }
        n2 = 0;
        dArray[n2] = 3.4028234663852886E38;
        nArray[n2++] = 0;
        for (n = 1; n <= this.numPoints; ++n) {
            double d = lArray2[nArray[n2 - 1]] - lArray2[n];
            double d2 = lArray[n] - lArray[nArray[n2 - 1]];
            if (!(d > 0.0)) continue;
            while (d >= dArray[n2 - 1] * d2) {
                d = lArray2[nArray[--n2 - 1]] - lArray2[n];
                d2 = lArray[n] - lArray[nArray[n2 - 1]];
            }
            dArray[n2] = d / d2;
            nArray[n2++] = n;
        }
        this.CHFeasiblePoints = new int[n2 - 1];
        this.CHSlopes = new double[n2 - 1];
        for (n = 1; n < n2; ++n) {
            this.CHFeasiblePoints[n - 1] = nArray[n] + this.firstPoint - 1;
            this.CHSlopes[n - 1] = dArray[n];
        }
    }

    public int[] getFeasiblePoints() {
        return this.CHFeasiblePoints;
    }

    public double[] getSlopes() {
        return this.CHSlopes;
    }
}

