/*
 * Decompiled with CFR 0.152.
 */
package BitAllocation;

import BitAllocation.ConvexHull;
import GiciBitStream.BitInputStream;
import GiciBitStream.BitOutputStream;
import GiciBitStream.BitRandomAccessFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class SpihtBitAllocation {
    protected static final int xBits = 16;
    protected static final int yBits = 16;
    protected static final int zBits = 16;
    protected static final int levelsBits = 4;
    protected static final int methodBits = 1;
    protected static final int thresholdBits = 5;
    protected BitOutputStream bos = null;
    protected BitRandomAccessFile bis = null;
    protected long[][] table = null;
    protected double[][] rateTable = null;
    protected long[][] accessPoints = null;
    protected int[] order = null;
    protected int[][] feasiblePoints = null;
    protected String[] ratedList = new String[]{"rd1tp", "rd2tp", "rdch"};
    protected int rateMode = -1;
    protected int dimension = 0;

    public SpihtBitAllocation(String string) throws Exception {
        for (int i = 0; i < this.ratedList.length; ++i) {
            if (!this.ratedList[i].equals(string)) continue;
            this.rateMode = i;
            break;
        }
        if (this.rateMode == -1) {
            throw new Exception("The specified Rate Distortion algorithm " + string + " are not avaible.");
        }
    }

    protected void generateRateTable() throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.table.length;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        long[] lArray = null;
        System.out.println("Rate Table Begin");
        if (this.table == null) {
            throw new Exception("The Distortion table is null.");
        }
        if (this.accessPoints == null) {
            throw new Exception("The Access Points table is null.");
        }
        if (this.dimension <= 0 || this.dimension >= 3) {
            throw new Exception("The dimension attribute is not correct.");
        }
        n2 = (int)Math.ceil(Math.log(n4) / Math.log(2.0));
        this.rateTable = new double[this.table.length][];
        for (int i = 0; i < n4; ++i) {
            n5 = 0;
            n6 = 1;
            n = this.table[i].length;
            if (this.rateMode == 0) {
                this.rateTable[i] = new double[(n - 1 >> 1) + 1];
                lArray = new long[(n - 1 >> 1) + 2];
                lArray[0] = this.accessPoints[i][0];
            } else {
                this.rateTable[i] = new double[n];
            }
            for (int j = 0; j < n; ++j) {
                if (this.rateMode == 1 || j == 0) {
                    d2 = this.table[i][j];
                    d3 = this.accessPoints[i][j + 1] - this.accessPoints[i][j];
                    d = d2 / d3;
                    if (this.rateMode == 0) {
                        lArray[n6] = this.accessPoints[i][j + 1];
                        ++n6;
                    }
                } else {
                    d2 = this.table[i][j] + this.table[i][j + 1];
                    d3 = this.accessPoints[i][j + 1] - this.accessPoints[i][j];
                    lArray[n6] = this.accessPoints[i][j + 1];
                    ++n6;
                    d = d2 / (d3 += (double)(this.accessPoints[i][++j + 1] - this.accessPoints[i][j]));
                }
                if (d <= 0.0) {
                    if (this.rateMode == 0) {
                        this.rateTable[i][n5] = -1.0;
                        ++n5;
                        d2 = this.table[i][++j] + this.table[i][j + 1];
                        d3 += (double)(this.accessPoints[i][j + 1] - this.accessPoints[i][j]);
                        lArray[n6] = this.accessPoints[i][j + 1];
                        ++n6;
                        d = d2 / (d3 += (double)(this.accessPoints[i][++j + 1] - this.accessPoints[i][j]));
                    } else {
                        this.rateTable[i][n5] = -1.0;
                        ++n5;
                        d2 = this.table[i][++j];
                        d = d2 / (d3 += (double)(this.accessPoints[i][j + 1] - this.accessPoints[i][j]));
                    }
                    ++n3;
                }
                this.rateTable[i][n5] = d;
                ++n3;
                ++n5;
            }
            if (this.rateMode != 0) continue;
            this.accessPoints[i] = lArray;
        }
        System.out.println("Rate Table Ends: " + n3);
    }

    protected void generateOrder() throws Exception {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.rateTable.length;
        double d = 0.0;
        double d2 = 0.0;
        int[] nArray = new int[n4];
        System.out.println("Generate Order Begin");
        if (this.rateTable == null) {
            throw new Exception("The rate table is null");
        }
        for (n = 0; n < n4; ++n) {
            n2 += this.rateTable[n].length;
            nArray[n] = 0;
        }
        this.order = new int[n2];
        for (n = 0; n < n2; ++n) {
            int n5;
            int n6;
            for (n6 = 0; n6 < n4; ++n6) {
                n5 = this.rateTable[n6].length;
                if (n5 <= nArray[n6]) continue;
                d = this.rateTable[n6][nArray[n6]];
                n3 = n6;
                break;
            }
            for (n6 = 0; n6 < n4; ++n6) {
                try {
                    n5 = this.rateTable[n6].length;
                    if (n5 <= nArray[n6]) continue;
                    d2 = this.rateTable[n6][nArray[n6]];
                    if (d2 == -1.0) {
                        d2 = this.rateTable[n6][nArray[n6] + 1];
                    }
                    if (!(d < d2)) continue;
                    d = d2;
                    n3 = n6;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.print(" Final de linea: " + nArray[n6] + " Size: " + n);
                    System.exit(0);
                }
            }
            if (this.rateTable[n3][nArray[n3]] == -1.0) {
                int n7 = n3;
                nArray[n7] = nArray[n7] + 1;
                this.order[n] = n3;
                ++n;
            }
            int n8 = n3;
            nArray[n8] = nArray[n8] + 1;
            this.order[n] = n3;
        }
        System.out.println("Generate Order Ends");
    }

    protected void generateConvexHullRateTable() throws Exception {
        int n;
        int n2;
        boolean bl = false;
        long[] lArray = null;
        double[] dArray = null;
        int n3 = this.table.length;
        if (this.table == null) {
            throw new Exception("The distortions table is null");
        }
        if (this.accessPoints == null) {
            throw new Exception("The access points array is null");
        }
        this.feasiblePoints = new int[n3][];
        this.rateTable = new double[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = this.table[n2].length;
            long[] lArray2 = new long[n4];
            long[] lArray3 = new long[n4];
            for (n = 0; n < n4; ++n) {
                lArray2[n] = this.table[n2][n];
                lArray3[n] = this.accessPoints[n2][n + 1] - this.accessPoints[n2][n];
            }
            ConvexHull convexHull = new ConvexHull(lArray3, lArray2);
            convexHull.run();
            this.feasiblePoints[n2] = convexHull.getFeasiblePoints();
            dArray = convexHull.getSlopes();
            n = n4 - 1;
            this.rateTable[n2] = dArray;
            lArray = new long[this.feasiblePoints[n2].length + 1];
            for (int i = 0; i < this.feasiblePoints[n2].length; ++i) {
                lArray[i + 1] = this.accessPoints[n2][this.feasiblePoints[n2][i] + 1];
            }
            lArray[0] = this.accessPoints[n2][0];
            this.accessPoints[n2] = lArray;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < this.rateTable[n2].length; ++n) {
                if (!(this.rateTable[n2][n] <= 0.0)) continue;
                System.out.println("Line: " + n2 + " Threshold: " + n);
                System.exit(0);
            }
        }
    }

    public void generateRatedOutputStream(String string, long l) throws Exception {
        int n;
        int n2;
        String string2 = string + "_" + this.ratedList[this.rateMode];
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if (this.rateMode == 2) {
            bl = true;
            this.rateMode = 1;
        }
        if (bl) {
            this.generateConvexHullRateTable();
        } else {
            this.generateRateTable();
        }
        this.generateOrder();
        FileInputStream fileInputStream = new FileInputStream(string);
        BitInputStream bitInputStream = new BitInputStream(fileInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        this.bos = l != 0L ? new BitOutputStream(fileOutputStream, l) : new BitOutputStream(fileOutputStream);
        int n5 = (int)bitInputStream.readUBits(16);
        this.bos.writeUBits(n5, 16);
        if (this.dimension == 1) {
            n2 = (int)bitInputStream.readUBits(16);
            this.bos.writeUBits(n2, 16);
            n4 = 37;
        } else {
            n = (int)bitInputStream.readUBits(16);
            this.bos.writeUBits(n, 16);
            n2 = (int)bitInputStream.readUBits(16);
            this.bos.writeUBits(n2, 16);
            n4 = 53;
        }
        n = (int)bitInputStream.readUBits(4);
        this.bos.writeUBits(n, 4);
        int n6 = (int)bitInputStream.readUBits(1);
        this.bos.writeUBits(n6, 1);
        fileInputStream.close();
        bitInputStream.close();
        File file = new File(string);
        this.bis = new BitRandomAccessFile(file, "r");
        int n7 = this.order.length;
        int n8 = (int)Math.ceil(Math.log(n2) / Math.log(2.0));
        int[] nArray = new int[n2];
        System.out.println("Comienza la escritura del fichero rated: " + n7);
        for (int i = 0; i < n7; ++i) {
            n3 = this.order[i];
            long l2 = this.accessPoints[n3][nArray[n3]] + (long)n4 + (long)((n3 + 1) * 5);
            long l3 = this.accessPoints[n3][nArray[n3] + 1] + (long)n4 + (long)((n3 + 1) * 5);
            if (nArray[n3] == 0) {
                l2 -= 5L;
            }
            this.bos.writeUBits(n3, n8);
            if (bl) {
                int n9 = nArray[n3] == 0 ? this.feasiblePoints[n3][0] + 1 : this.feasiblePoints[n3][nArray[n3]] - this.feasiblePoints[n3][nArray[n3] - 1];
                --n9;
                while (n9 != 0) {
                    this.bos.writeUBits(0L, 1);
                    --n9;
                }
                this.bos.writeUBits(1L, 1);
            }
            this.copyStream(l2, l3);
            int n10 = n3;
            nArray[n10] = nArray[n10] + 1;
        }
        this.bos.close();
        this.bis.close();
    }

    protected void copyStream(long l, long l2) throws IOException {
        this.bis.positionInBits(l);
        for (long i = l; i < l2; ++i) {
            int n = (int)this.bis.readUBits(1);
            this.bos.writeUBits(n, 1);
        }
    }

    public long[][] getDistortionTable() {
        return this.table;
    }

    public double[][] getRateTable() {
        return this.rateTable;
    }

    public int[] getLineOrder() {
        return this.order;
    }

    public long[][] getAccessPoints() {
        return this.accessPoints;
    }

    public int[][] getFeasiblePoints() {
        return this.feasiblePoints;
    }

    public void setDimension(int n) {
        this.dimension = n;
    }

    public void setDistortionTable(long[][] lArray) {
        this.table = lArray;
    }

    public void setAccessPoints(long[][] lArray) {
        this.accessPoints = lArray;
    }
}

