/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

public class ChiSquare {
    private static double BIGX = 20.0;
    static double CHI_EPSILON = 1.0E-8;
    static double CHI_MAX = 99999.0;

    public static double getSignificanceLevel(int n, double d) {
        double d2;
        double d3 = 0.0;
        double d4 = d;
        int n2 = n;
        boolean bl = n2 % 2 == 0;
        double d5 = 0.5723649429247001;
        double d6 = 0.5641895835477563;
        if (n <= 0) {
            return -1.0;
        }
        if (d4 <= 0.0 || n2 < 1) {
            return 1.0;
        }
        double d7 = 0.5 * d4;
        if (n2 > 1) {
            d3 = ChiSquare.ex(-d7);
        }
        double d8 = d2 = bl ? d3 : 2.0 * ChiSquare.poz(-Math.sqrt(d4));
        if (n2 > 2) {
            double d9;
            d4 = 0.5 * ((double)n2 - 1.0);
            double d10 = d9 = bl ? 1.0 : 0.5;
            if (d7 > BIGX) {
                double d11 = bl ? 0.0 : d5;
                double d12 = Math.log(d7);
                while (d9 <= d4) {
                    d11 = Math.log(d9) + d11;
                    d2 += ChiSquare.ex(d12 * d9 - d7 - d11);
                    d9 += 1.0;
                }
                return d2;
            }
            double d13 = bl ? 1.0 : d6 / Math.sqrt(d7);
            double d14 = 0.0;
            while (d9 <= d4) {
                d14 += (d13 *= d7 / d9);
                d9 += 1.0;
            }
            return d14 * d3 + d2;
        }
        return d2;
    }

    public static double getCriticalValue(int n, double d) {
        double d2 = d;
        double d3 = n;
        double d4 = 0.0;
        double d5 = CHI_MAX;
        if (n <= 0) {
            throw new IllegalArgumentException("Degrees of freedom cannot be <= 0");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Significance level = " + d + " not in [0,1]");
        }
        if (d2 <= 0.0) {
            return d5;
        }
        if (d2 >= 1.0) {
            return 0.0;
        }
        double d6 = d3 / Math.sqrt(d2);
        while (d5 - d4 > CHI_EPSILON) {
            if (ChiSquare.getSignificanceLevel((int)Math.round(d3), d6) < d2) {
                d5 = d6;
            } else {
                d4 = d6;
            }
            d6 = (d5 + d4) * 0.5;
        }
        return d6;
    }

    private static double ex(double d) {
        return d < -BIGX ? 0.0 : Math.exp(d);
    }

    private static double poz(double d) {
        double d2;
        double d3 = 6.0;
        if (d == 0.0) {
            d2 = 0.0;
        } else {
            double d4 = 0.5 * Math.abs(d);
            if (d4 >= d3 * 0.5) {
                d2 = 1.0;
            } else if (d4 < 1.0) {
                double d5 = d4 * d4;
                d2 = ((((((((1.24818987E-4 * d5 - 0.001075204047) * d5 + 0.005198775019) * d5 - 0.019198292004) * d5 + 0.059054035642) * d5 - 0.151968751364) * d5 + 0.319152932694) * d5 - 0.5319230073) * d5 + 0.797884560593) * d4 * 2.0;
            } else {
                d2 = (((((((((((((-4.5255659E-5 * (d4 -= 2.0) + 1.5252929E-4) * d4 - 1.9538132E-5) * d4 - 6.76904986E-4) * d4 + 0.001390604284) * d4 - 7.9462082E-4) * d4 - 0.002034254874) * d4 + 0.006549791214) * d4 - 0.010557625006) * d4 + 0.011630447319) * d4 - 0.009279453341) * d4 + 0.005353579108) * d4 - 0.002141268741) * d4 + 5.35310849E-4) * d4 + 0.999936657524;
            }
        }
        return d > 0.0 ? (d2 + 1.0) * 0.5 : (1.0 - d2) * 0.5;
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        ChiSquare chiSquare = new ChiSquare();
        int n2 = 4;
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 1.0}, {1.0, 0.1, 0.7518}, {1.0, 2.0, 0.1573}, {1.0, 3.0, 0.0833}, {1.0, 10.0, 0.0016}, {1.0, 100.0, 0.0}, {255.0, 0.0, 1.0}, {255.0, 10.0, 1.0}, {255.0, 200.0, 0.9954}, {255.0, 250.0, 0.5766}, {255.0, 300.0, 0.0277}, {255.0, 500.0, 0.0}, {255.0, 10000.0, 0.0}, {65535.0, 0.0, 1.0}, {65535.0, 100.0, 1.0}, {65535.0, 1000.0, 1.0}, {65535.0, 10000.0, 1.0}, {65535.0, 20000.0, 1.0}, {65535.0, 30000.0, 1.0}, {65535.0, 40000.0, 1.0}, {65535.0, 50000.0, 1.0}, {65535.0, 60000.0, 1.0}, {65535.0, 65000.0, 0.9306}, {65535.0, 65500.0, 0.5378}, {65535.0, 65900.0, 0.1567}, {65535.0, 70000.0, 0.0}};
        System.out.println("** Testing " + dArrayArray.length + " significance level calculation examples...");
        for (int i = 0; i < dArrayArray.length; ++i) {
            n = (int)Math.round(dArrayArray[i][0]);
            double d = dArrayArray[i][1];
            double d2 = dArrayArray[i][2];
            if (ChiSquare.compareValues(ChiSquare.getSignificanceLevel(n, d), d2, n2)) continue;
            throw new Exception("Wrong significance level calculation for\n\rdof = " + n + ",\n\rvalue = " + d + ",\n\robtained = " + ChiSquare.getSignificanceLevel(n, d) + ",\n\rexpected = " + d2);
        }
        System.out.println("Ok!");
        n2 = 0;
        double[][] dArrayArray2 = new double[][]{{1.0, 0.99, 2.0E-4}, {1.0, 0.95, 0.0039}, {1.0, 0.5, 0.4549}, {1.0, 0.05, 3.841}, {1.0, 0.01, 6.635}, {255.0, 0.99, 205.0}, {255.0, 0.95, 219.0}, {255.0, 0.5, 254.0}, {255.0, 0.05, 293.0}, {255.0, 0.01, 310.0}, {65535.0, 0.99, 64696.0}, {65535.0, 0.95, 64941.0}, {65535.0, 0.5, 65534.0}, {65535.0, 0.05, 66132.0}, {65535.0, 0.01, 66380.0}};
        System.out.println("** Testing " + dArrayArray2.length + " critical value calculation examples...");
        for (n = 0; n < dArrayArray2.length; ++n) {
            int n3 = (int)Math.round(dArrayArray2[n][0]);
            double d = dArrayArray2[n][1];
            double d3 = dArrayArray2[n][2];
            if (ChiSquare.compareValues(ChiSquare.getCriticalValue(n3, d), d3, n2)) continue;
            throw new Exception("Wrong critical value calculation for\n\rdof = " + n3 + ",\n\rsignificance = " + d + ",\n\robtained = " + ChiSquare.getCriticalValue(n3, d) + ",\n\rexpected = " + d3);
        }
        System.out.println("Ok!");
    }

    private static boolean compareValues(double d, double d2, int n) {
        double d3 = Math.pow(10.0, n);
        return Math.round(d * d3) == Math.round(d2 * d3);
    }
}

