/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;

public class HungarianAlgorithm {
    private final int count;
    private final WeightFunction wf;
    private final boolean maximize;
    private int[] mateStoT;
    private int[] mateTtoS;
    private float[] u;
    private float[] v;

    public static WeightFunction getPrecomputedWeightFunction(int n, WeightFunction weightFunction) {
        final float[][] fArray = new float[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[i][j] = weightFunction.weight(i, j);
            }
        }
        return new WeightFunction(){

            @Override
            public float weight(int n, int n2) {
                return fArray[n][n2];
            }
        };
    }

    public HungarianAlgorithm(int n, final float[][] fArray, boolean bl) {
        this.count = n;
        this.maximize = bl;
        this.wf = bl ? new WeightFunction(){

            @Override
            public final float weight(int n, int n2) {
                return fArray[n][n2];
            }
        } : new WeightFunction(){

            @Override
            public final float weight(int n, int n2) {
                return -fArray[n][n2];
            }
        };
    }

    public HungarianAlgorithm(int n, final WeightFunction weightFunction, boolean bl) {
        this.count = n;
        this.maximize = bl;
        this.wf = bl ? weightFunction : new WeightFunction(){

            @Override
            public final float weight(int n, int n2) {
                return -weightFunction.weight(n, n2);
            }
        };
    }

    public HungarianAlgorithm(int n, WeightFunction weightFunction) {
        this(n, weightFunction, true);
    }

    public void solve() {
        int n;
        this.mateStoT = new int[this.count];
        this.mateTtoS = new int[this.count];
        Arrays.fill(this.mateStoT, -1);
        Arrays.fill(this.mateTtoS, -1);
        this.u = new float[this.count];
        this.v = new float[this.count];
        for (n = 0; n < this.count; ++n) {
            float f = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < this.count; ++i) {
                f = Math.max(f, this.wf.weight(n, i));
            }
            this.u[n] = f;
            this.v[n] = 0.0f;
        }
        n = this.count;
        while (n > 0) {
            float[] fArray = new float[this.count];
            int[] nArray = new int[this.count];
            boolean[] blArray = new boolean[this.count];
            Arrays.fill(blArray, false);
            Arrays.fill(nArray, -1);
            Arrays.fill(fArray, Float.POSITIVE_INFINITY);
            boolean bl = false;
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (int i = 0; i < this.count; ++i) {
                if (this.mateStoT[i] >= 0) continue;
                treeSet.add(i);
            }
            do {
                int n2;
                int n3;
                assert (treeSet.size() > 0);
                Iterator iterator = treeSet.iterator();
                int n4 = (Integer)iterator.next();
                iterator.remove();
                blArray[n4] = true;
                for (n3 = 0; n3 < this.count && !bl; ++n3) {
                    float f;
                    float f2;
                    float f3;
                    if (this.mateStoT[n4] == n3 || !((f3 = Math.max(f2 = this.u[n4] + this.v[n3] - (f = this.wf.weight(n4, n3)), 0.0f)) < fArray[n3])) continue;
                    fArray[n3] = f2;
                    nArray[n3] = n4;
                    if (!(fArray[n3] <= 0.0f)) continue;
                    if (this.mateTtoS[n3] < 0) {
                        this.augment(this.mateStoT, this.mateTtoS, nArray, n3);
                        bl = true;
                        --n;
                        continue;
                    }
                    treeSet.add(this.mateTtoS[n3]);
                }
                if (bl || treeSet.size() != 0) continue;
                float f = Float.POSITIVE_INFINITY;
                for (n4 = 0; n4 < this.count; ++n4) {
                    if (!(fArray[n4] > 0.0f)) continue;
                    f = Math.min(f, fArray[n4]);
                }
                for (n4 = 0; n4 < this.count; ++n4) {
                    if (!blArray[n4]) continue;
                    int n5 = n4;
                    this.u[n5] = this.u[n5] - f;
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                n3 = 0;
                int n6 = -1;
                for (n2 = 0; n2 < this.count; ++n2) {
                    if (fArray[n2] <= 0.0f) {
                        int n7 = n2;
                        this.v[n7] = this.v[n7] + f;
                        continue;
                    }
                    int n8 = n2;
                    fArray[n8] = fArray[n8] - f;
                    if (!(fArray[n2] <= 0.0f)) continue;
                    if (this.mateTtoS[n2] < 0) {
                        n6 = n2++;
                        n3 = 1;
                        break;
                    }
                    arrayList.add(this.mateTtoS[n2]);
                }
                while (n2 < this.count) {
                    if (fArray[n2] <= 0.0f) {
                        int n9 = n2;
                        this.v[n9] = this.v[n9] + f;
                    } else {
                        int n10 = n2;
                        fArray[n10] = fArray[n10] - f;
                    }
                    ++n2;
                }
                if (n3 == 0) {
                    treeSet.addAll(arrayList);
                    continue;
                }
                this.augment(this.mateStoT, this.mateTtoS, nArray, n6);
                bl = true;
                --n;
            } while (!bl);
        }
    }

    private void augment(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2;
        do {
            int n3;
            nArray2[n] = n3 = nArray3[n];
            n2 = nArray[n3];
            nArray[n3] = n;
            if (n2 < 0) continue;
            n = n2;
        } while (n2 >= 0);
    }

    public int[] getMateTtoS() {
        return this.mateTtoS;
    }

    public int[] getMateStoT() {
        return this.mateStoT;
    }

    public float getScore() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < this.count; ++i) {
            f += this.wf.weight(i, this.mateStoT[i]);
            f2 += this.wf.weight(this.mateTtoS[i], i);
            f3 += this.u[i] + this.v[i];
        }
        float f4 = Math.abs(f - f2);
        float f5 = Math.abs(f2 - f3);
        float f6 = 0.001f;
        assert (f4 <= Math.abs(f) * f6);
        assert (f4 <= Math.abs(f2) * f6);
        assert (f5 <= Math.abs(f2) * f6);
        assert (f5 <= Math.abs(f3) * f6);
        return this.maximize ? f : -f;
    }

    public float getScoreWithDummyLastInputs(int n) {
        float f = 0.0f;
        for (int i = 0; i < this.count - n; ++i) {
            f += this.wf.weight(i, this.mateStoT[i]);
        }
        return this.maximize ? f : -f;
    }

    public static interface WeightFunction {
        public float weight(int var1, int var2);
    }
}

