/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import GiciException.WarningException;

public class ImageCompare {
    float[] mae = null;
    float totalMAE;
    float[] pae = null;
    float totalPAE;
    float[] mse = null;
    float totalMSE;
    float[] rmse = null;
    float totalRMSE;
    float[] me = null;
    float totalME;
    float[] snr = null;
    float totalSNR;
    float[] psnr = null;
    float totalPSNR;
    boolean[] equal;
    boolean totalEQUAL;

    public ImageCompare(float[][][] fArray, float[][][] fArray2, int[] nArray) throws WarningException {
        int n;
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        int n4 = fArray[0][0].length;
        int n5 = fArray2.length;
        int n6 = fArray2[0].length;
        int n7 = fArray2[0][0].length;
        if (n2 != n5 || n3 != n6 || n4 != n7) {
            throw new WarningException("Image sizes must be the same to perform comparisons.");
        }
        this.mae = new float[n2];
        this.pae = new float[n2];
        this.mse = new float[n2];
        this.rmse = new float[n2];
        this.me = new float[n2];
        this.snr = new float[n2];
        this.psnr = new float[n2];
        this.equal = new boolean[n2];
        this.totalMAE = 0.0f;
        this.totalPAE = -1.0f;
        this.totalMSE = 0.0f;
        this.totalRMSE = 0.0f;
        this.totalME = 0.0f;
        this.totalSNR = 0.0f;
        this.totalPSNR = 0.0f;
        this.totalEQUAL = true;
        for (n = 0; n < n2; ++n) {
            this.mae[n] = 0.0f;
            this.pae[n] = -1.0f;
            this.mse[n] = 0.0f;
            this.rmse[n] = 0.0f;
            this.me[n] = 0.0f;
            this.snr[n] = 0.0f;
            this.psnr[n] = 0.0f;
            this.equal[n] = false;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    double d5 = 0.0;
                    d5 = fArray[n][i][j] - fArray2[n][i][j];
                    d3 += d5;
                    d5 = Math.abs(d5);
                    d += d5;
                    if (d5 > (double)this.pae[n]) {
                        this.pae[n] = (float)d5;
                    }
                    d2 += d5 * d5;
                    d4 += (double)(fArray[n][i][j] * fArray[n][i][j]);
                }
            }
            this.totalMAE += (float)d;
            this.totalME += (float)d3;
            if (this.pae[n] > this.totalPAE) {
                this.totalPAE = this.pae[n];
            }
            this.totalMSE += (float)d2;
            this.mae[n] = (float)(d / ((double)n3 * (double)n4));
            this.me[n] = (float)(d3 / ((double)n3 * (double)n4));
            this.mse[n] = (float)(d2 / ((double)n3 * (double)n4));
            this.rmse[n] = (float)Math.sqrt(this.mse[n]);
            this.snr[n] = 10.0f * (float)Math.log(d4 / ((double)n3 * (double)n4) / (double)this.mse[n]) / (float)Math.log(10.0);
            float f = (float)Math.pow(2.0, nArray[n]) - 1.0f;
            this.psnr[n] = 10.0f * (float)(Math.log(f * f / this.mse[n]) / (double)((float)Math.log(10.0)));
            boolean bl = this.equal[n] = this.mae[n] == 0.0f;
            if (this.equal[n]) continue;
            this.totalEQUAL = false;
        }
        this.totalMAE /= (float)(n2 * n3 * n4);
        this.totalMSE /= (float)(n2 * n3 * n4);
        this.totalRMSE = (float)Math.sqrt(this.totalMSE);
        this.totalME /= (float)(n2 * n3 * n4);
        for (n = 0; n < n2; ++n) {
            this.totalSNR += this.snr[n];
            this.totalPSNR += this.psnr[n];
        }
        this.totalSNR /= (float)n2;
        this.totalPSNR /= (float)n2;
    }

    public float[] getMAE() {
        return this.mae;
    }

    public float getTotalMAE() {
        return this.totalMAE;
    }

    public float[] getPAE() {
        return this.pae;
    }

    public float getTotalPAE() {
        return this.totalPAE;
    }

    public float[] getMSE() {
        return this.mse;
    }

    public float getTotalMSE() {
        return this.totalMSE;
    }

    public float[] getRMSE() {
        return this.rmse;
    }

    public float getTotalRMSE() {
        return this.totalRMSE;
    }

    public float[] getME() {
        return this.me;
    }

    public float getTotalME() {
        return this.totalME;
    }

    public float[] getSNR() {
        return this.snr;
    }

    public float getTotalSNR() {
        return this.totalSNR;
    }

    public float[] getPSNR() {
        return this.psnr;
    }

    public float getTotalPSNR() {
        return this.totalPSNR;
    }

    public boolean[] getEQUAL() {
        return this.equal;
    }

    public boolean getTotalEQUAL() {
        return this.totalEQUAL;
    }
}

