/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import GiciAnalysis.ParkMillerPRNG;
import GiciMatrix.MatrixAlgebra;
import GiciParallel.ParallelMap;
import java.util.Random;

public class ImageCovariance {
    protected ImageCovariance() {
        throw new UnsupportedOperationException();
    }

    public static float[][] generateCovarianceMatrix(float[][][] fArray, int n, float f, float f2) {
        assert (n >= 0 && n < 3);
        assert (fArray.length > 0 && fArray[0].length > 0 && fArray[0][0].length > 0);
        assert (f > 0.0f && f <= 1.0f);
        assert (f2 > 0.0f && f2 <= 1.0f);
        float[][] fArray2 = null;
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        int n4 = fArray[0][0].length;
        switch (n) {
            case 0: {
                int n5;
                int n6;
                fArray2 = MatrixAlgebra.identityUT(n2);
                ParkMillerPRNG parkMillerPRNG = new ParkMillerPRNG(13L);
                int n7 = (int)((float)(n3 * n4) * f);
                int n8 = (int)((float)(n3 * n4) * f2);
                int n9 = Math.max(n7, n8);
                assert (n3 * n4 > 1);
                n7 = n9 = Math.max(n9, 2);
                n8 = n9;
                int[] nArray = new int[n9];
                int[] nArray2 = new int[n9];
                for (n6 = 0; n6 < nArray.length; ++n6) {
                    nArray[n6] = ((Random)parkMillerPRNG).nextInt(n3);
                    nArray2[n6] = ((Random)parkMillerPRNG).nextInt(n4);
                }
                double[] dArray = new double[n2];
                n6 = 0;
                while (n6 < n2) {
                    for (n5 = 0; n5 < n7; ++n5) {
                        int n10 = n6;
                        dArray[n10] = dArray[n10] + (double)fArray[n6][nArray[n5]][nArray2[n5]];
                    }
                    int n11 = n6++;
                    dArray[n11] = dArray[n11] / (double)n7;
                }
                for (n6 = 0; n6 < n2; ++n6) {
                    for (n5 = n6; n5 < n2; ++n5) {
                        double d = 0.0;
                        for (int i = 0; i < n8; ++i) {
                            d += ((double)fArray[n6][nArray[i]][nArray2[i]] - dArray[n6]) * ((double)fArray[n5][nArray[i]][nArray2[i]] - dArray[n5]);
                        }
                        double d2 = d / (double)(n8 - 1);
                        assert (d2 >= 0.0 || n6 != n5);
                        fArray2[n6][n5 - n6] = (float)d2;
                    }
                }
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
        return fArray2;
    }

    public static float[][] generateCovarianceMatrix(final float[][][] fArray, int n) {
        float[][] fArray2;
        assert (n >= 0 && n < 3);
        assert (fArray.length > 0);
        assert (fArray[0].length > 0);
        assert (fArray[0][0].length > 0);
        int n2 = fArray.length;
        final int n3 = fArray[0].length;
        final int n4 = fArray[0][0].length;
        switch (n) {
            case 0: {
                fArray2 = MatrixAlgebra.identityUT(n2);
                final int n5 = n3 * n4;
                assert (n5 > 0);
                final double[] dArray = new double[n2];
                int n6 = 0;
                while (n6 < n2) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n4; ++j) {
                            int n7 = n6;
                            dArray[n7] = dArray[n7] + (double)fArray[n6][i][j];
                        }
                    }
                    int n8 = n6++;
                    dArray[n8] = dArray[n8] / (double)n5;
                }
                ParallelMap.map(new ParallelMap.UpperDiagonalIterator(n2), new ParallelMap.MapInterface<int[]>(){

                    @Override
                    public void apply(int[] nArray) {
                        double d = 0.0;
                        int n = nArray[0];
                        int n2 = nArray[1];
                        for (int i = 0; i < n3; ++i) {
                            for (int j = 0; j < n4; ++j) {
                                d += ((double)fArray[n][i][j] - dArray[n]) * ((double)fArray[n2][i][j] - dArray[n2]);
                            }
                        }
                        double d2 = d / (double)(n5 - 1);
                        fArray2[n][n2 - n] = (float)d2;
                    }
                });
                break;
            }
            case 1: {
                fArray2 = MatrixAlgebra.identityUT(n3);
                int n9 = n2 * n4;
                for (int i = 0; i < n3; ++i) {
                    for (int j = i; j < n3; ++j) {
                        float f;
                        double d = 0.0;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        for (int k = 0; k < n2; ++k) {
                            for (int i2 = 0; i2 < n4; ++i2) {
                                d += (double)(fArray[k][i][i2] * fArray[k][j][i2]);
                                d2 += (double)fArray[k][i][i2];
                                d3 += (double)fArray[k][j][i2];
                            }
                        }
                        assert (false);
                        fArray2[i][j - i] = f = (float)(d / (double)(n9 - 1) - d2 / (double)(n9 - 1) * (d3 / (double)(n9 - 1)));
                    }
                }
                break;
            }
            case 2: {
                fArray2 = MatrixAlgebra.identityUT(n4);
                int n10 = n2 * n3;
                for (int i = 0; i < n4; ++i) {
                    for (int j = i; j < n4; ++j) {
                        float f;
                        double d = 0.0;
                        double d4 = 0.0;
                        double d5 = 0.0;
                        for (int k = 0; k < n2; ++k) {
                            for (int i3 = 0; i3 < n3; ++i3) {
                                d += (double)(fArray[k][i3][i] * fArray[k][i3][j]);
                                d4 += (double)fArray[k][i3][i];
                                d5 += (double)fArray[k][i3][j];
                            }
                        }
                        assert (false);
                        fArray2[i][j - i] = f = (float)(d / (double)(n10 - 1) - d4 / (double)(n10 - 1) * (d5 / (double)(n10 - 1)));
                    }
                }
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
        return fArray2;
    }

    public static float[][] generateCorrelationMatrixFromCovarianceMatrix(float[][] fArray) {
        int n;
        float[][] fArray2 = MatrixAlgebra.copy(fArray);
        float[] fArray3 = new float[fArray2.length];
        for (n = 0; n < fArray2.length; ++n) {
            fArray3[n] = (float)Math.sqrt(fArray2[n][0]);
            assert (!Float.isNaN(fArray3[n]));
        }
        for (n = 0; n < fArray2.length; ++n) {
            for (int i = 1; i < fArray2[n].length; ++i) {
                if (Math.abs(fArray3[n] * fArray3[n + i]) > Float.MIN_VALUE) {
                    float[] fArray4 = fArray2[n];
                    int n2 = i;
                    fArray4[n2] = fArray4[n2] / (fArray3[n] * fArray3[n + i]);
                }
                assert (!Float.isNaN(fArray2[n][i]));
            }
        }
        fArray3 = null;
        for (n = 0; n < fArray2.length; ++n) {
            fArray2[n][0] = 1.0f;
        }
        return fArray2;
    }
}

