/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import java.util.HashMap;
import java.util.Iterator;

public class ImageStatistical {
    double[][] minMax = null;
    double[] totalMinMax = null;
    double[] average = null;
    double totalAverage = 0.0;
    double[] centerRange = null;
    double totalCenterRange = 0.0;
    int[][] countedValues = null;
    double[] energy = null;
    double totalEnergy = 0.0;
    double[] variance = null;
    double totalVariance = 0.0;
    int[][] hist = null;
    int[] totalHist = null;
    double[] entropy = null;
    double totalEntropy = 0.0;
    double[] morans = null;
    double totalMorans = 0.0;

    public ImageStatistical(float[][][] fArray) {
        int n;
        int n2;
        int n3;
        int n4 = fArray.length;
        int n5 = fArray[0].length;
        int n6 = fArray[0][0].length;
        this.minMax = new double[n4][2];
        this.average = new double[n4];
        this.centerRange = new double[n4];
        this.totalMinMax = new double[2];
        this.countedValues = new int[n4][256];
        this.energy = new double[n4];
        this.variance = new double[n4];
        this.morans = new double[n4];
        this.totalMinMax[0] = Double.POSITIVE_INFINITY;
        this.totalMinMax[1] = Double.NEGATIVE_INFINITY;
        for (n3 = 0; n3 < n4; ++n3) {
            this.minMax[n3][0] = Double.POSITIVE_INFINITY;
            this.minMax[n3][1] = Double.NEGATIVE_INFINITY;
            this.average[n3] = 0.0;
            this.energy[n3] = 0.0;
            this.variance[n3] = 0.0;
            this.morans[n3] = 0.0;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n7;
            for (n2 = 0; n2 < n5; ++n2) {
                for (n7 = 0; n7 < n6; ++n7) {
                    int n8 = n3;
                    this.energy[n8] = this.energy[n8] + (double)(fArray[n3][n2][n7] * fArray[n3][n2][n7]);
                    if (Math.abs(fArray[n3][n2][n7]) < 256.0f) {
                        int[] nArray = this.countedValues[n3];
                        int n9 = (int)Math.abs(fArray[n3][n2][n7]);
                        nArray[n9] = nArray[n9] + 1;
                    }
                    if ((double)fArray[n3][n2][n7] < this.minMax[n3][0]) {
                        this.minMax[n3][0] = fArray[n3][n2][n7];
                        if ((double)fArray[n3][n2][n7] < this.totalMinMax[0]) {
                            this.totalMinMax[0] = fArray[n3][n2][n7];
                        }
                    }
                    if ((double)fArray[n3][n2][n7] > this.minMax[n3][1]) {
                        this.minMax[n3][1] = fArray[n3][n2][n7];
                        if ((double)fArray[n3][n2][n7] > this.totalMinMax[1]) {
                            this.totalMinMax[1] = fArray[n3][n2][n7];
                        }
                    }
                    int n10 = n3;
                    this.average[n10] = this.average[n10] + (double)fArray[n3][n2][n7];
                }
            }
            int n11 = n3;
            this.average[n11] = this.average[n11] / (double)(n6 * n5);
            n2 = 8;
            n7 = 5;
            int n12 = 3;
            n = (n6 - 1) * (n5 - 1) * n2 + (2 * (n6 - 2) + 2 * (n5 - 2)) * n7 + 4 * n12;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n6; ++j) {
                    int n13 = n3;
                    this.variance[n13] = this.variance[n13] + ((double)fArray[n3][i][j] - this.average[n3]) * ((double)fArray[n3][i][j] - this.average[n3]);
                    double d = 0.0;
                    double d2 = (double)fArray[n3][i][j] - this.average[n3];
                    if (j > 0) {
                        d += d2 * ((double)fArray[n3][i][j - 1] - this.average[n3]);
                    }
                    if (j < n6 - 1) {
                        d += d2 * ((double)fArray[n3][i][j + 1] - this.average[n3]);
                    }
                    if (i > 0) {
                        d += d2 * ((double)fArray[n3][i - 1][j] - this.average[n3]);
                    }
                    if (i < n5 - 1) {
                        d += d2 * ((double)fArray[n3][i + 1][j] - this.average[n3]);
                    }
                    if (j > 0 && i > 0) {
                        d += d2 * ((double)fArray[n3][i - 1][j - 1] - this.average[n3]);
                    }
                    if (j < n6 - 1 && i > 0) {
                        d += d2 * ((double)fArray[n3][i - 1][j + 1] - this.average[n3]);
                    }
                    if (j < n6 - 1 && i < n5 - 1) {
                        d += d2 * ((double)fArray[n3][i + 1][j + 1] - this.average[n3]);
                    }
                    if (j > 0 && i < n5 - 1) {
                        d += d2 * ((double)fArray[n3][i + 1][j - 1] - this.average[n3]);
                    }
                    int n14 = n3;
                    this.morans[n14] = this.morans[n14] + d;
                }
            }
            int n15 = n3;
            this.morans[n15] = this.morans[n15] * (double)(n6 * n5);
            int n16 = n3;
            this.morans[n16] = this.morans[n16] / (double)n;
            if (this.variance[n3] != 0.0) {
                int n17 = n3;
                this.morans[n17] = this.morans[n17] / this.variance[n3];
            } else {
                this.morans[n3] = 1.0;
            }
            int n18 = n3;
            this.variance[n18] = this.variance[n18] / (double)(fArray[n3].length * fArray[n3][0].length);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.centerRange[n3] = (this.minMax[n3][0] + this.minMax[n3][1]) / 2.0;
        }
        this.totalAverage = 0.0;
        this.totalCenterRange = 0.0;
        this.totalMorans = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            this.totalAverage += this.average[n3];
            this.totalCenterRange += this.centerRange[n3];
            this.totalEnergy += this.energy[n3];
            this.totalMorans += this.morans[n3];
        }
        this.totalAverage /= (double)n4;
        this.totalCenterRange /= (double)n4;
        this.totalMorans /= (double)n4;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        this.entropy = new double[n4];
        n2 = 0;
        while (n2 < n4) {
            HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
            for (int i = 0; i < n5; ++i) {
                for (n = 0; n < n6; ++n) {
                    this.totalVariance += ((double)fArray[n2][i][n] - this.totalAverage) * ((double)fArray[n2][i][n] - this.totalAverage);
                    int n19 = (int)fArray[n2][i][n];
                    if (hashMap2.containsKey(n19)) {
                        hashMap2.put(n19, (Integer)hashMap2.get(n19) + 1);
                    } else {
                        hashMap2.put(n19, 1);
                    }
                    if (hashMap.containsKey(n19)) {
                        hashMap.put(n19, (Integer)hashMap.get(n19) + 1);
                        continue;
                    }
                    hashMap.put(n19, 1);
                }
            }
            this.entropy[n2] = 0.0;
            Iterator iterator = hashMap2.keySet().iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                double d = (double)((Integer)hashMap2.get(n)).intValue() / (double)(n5 * n6);
                if (!(d > 0.0)) continue;
                int n20 = n2;
                this.entropy[n20] = this.entropy[n20] - d * Math.log(d);
            }
            int n21 = n2++;
            this.entropy[n21] = this.entropy[n21] / Math.log(2.0);
        }
        this.totalVariance /= (double)(fArray.length * fArray[0].length * fArray[0][0].length);
        this.totalEntropy = 0.0;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n22 = (Integer)iterator.next();
            double d = (double)((Integer)hashMap.get(n22)).intValue() / (double)(n4 * n5 * n6);
            if (!(d > 0.0)) continue;
            this.totalEntropy -= d * Math.log(d);
        }
        this.totalEntropy /= Math.log(2.0);
    }

    public ImageStatistical(int[][][] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = nArray.length;
        int n7 = nArray[0].length;
        int n8 = nArray[0][0].length;
        this.minMax = new double[n6][2];
        this.countedValues = new int[n6][256];
        this.average = new double[n6];
        this.centerRange = new double[n6];
        this.totalMinMax = new double[2];
        double[] dArray = new double[n6];
        double d = 0.0;
        this.totalMinMax[0] = Double.POSITIVE_INFINITY;
        this.totalMinMax[1] = Double.NEGATIVE_INFINITY;
        for (n5 = 0; n5 < n6; ++n5) {
            this.minMax[n5][0] = Double.POSITIVE_INFINITY;
            this.minMax[n5][1] = Double.NEGATIVE_INFINITY;
            this.average[n5] = 0.0;
            dArray[n5] = 0.0;
        }
        for (n5 = 0; n5 < n6; ++n5) {
            for (n4 = 0; n4 < n7; ++n4) {
                for (n3 = 0; n3 < n8; ++n3) {
                    int n9 = n5;
                    this.energy[n9] = this.energy[n9] + (double)(nArray[n5][n4][n3] * nArray[n5][n4][n3]);
                    int[] nArray2 = this.countedValues[n5];
                    int n10 = nArray[n5][n4][n3];
                    nArray2[n10] = nArray2[n10] + 1;
                    if ((double)nArray[n5][n4][n3] < this.minMax[n5][0]) {
                        this.minMax[n5][0] = nArray[n5][n4][n3];
                        if ((double)nArray[n5][n4][n3] < this.totalMinMax[0]) {
                            this.totalMinMax[0] = nArray[n5][n4][n3];
                        }
                    }
                    if ((double)nArray[n5][n4][n3] > this.minMax[n5][1]) {
                        this.minMax[n5][1] = nArray[n5][n4][n3];
                        if ((double)nArray[n5][n4][n3] > this.totalMinMax[1]) {
                            this.totalMinMax[1] = nArray[n5][n4][n3];
                        }
                    }
                    int n11 = n5;
                    this.average[n11] = this.average[n11] + (double)(nArray[n5][n4][n3] / (n8 * n7));
                }
            }
            int n12 = n5;
            dArray[n12] = dArray[n12] / (double)(nArray[n5].length * nArray[n5][0].length);
            d += dArray[n5];
            n4 = 8;
            n3 = 5;
            n2 = 3;
            n = (n8 - 1) * (n7 - 1) * n4 + (2 * (n8 - 2) + 2 * (n7 - 2)) * n3 + 4 * n2;
            for (int i = 0; i < n7; ++i) {
                for (int j = 0; j < n8; ++j) {
                    this.variance[n5] = ((double)nArray[n5][i][j] - dArray[n5]) * ((double)nArray[n5][i][j] - dArray[n5]);
                    double d2 = 0.0;
                    double d3 = (double)nArray[n5][i][j] - this.average[n5];
                    if (j > 0) {
                        d2 += d3 * ((double)nArray[n5][i][j - 1] - this.average[n5]);
                    }
                    if (j < n8 - 1) {
                        d2 += d3 * ((double)nArray[n5][i][j + 1] - this.average[n5]);
                    }
                    if (i > 0) {
                        d2 += d3 * ((double)nArray[n5][i - 1][j] - this.average[n5]);
                    }
                    if (i < n7 - 1) {
                        d2 += d3 * ((double)nArray[n5][i + 1][j] - this.average[n5]);
                    }
                    if (j > 0 && i > 0) {
                        d2 += d3 * ((double)nArray[n5][i - 1][j - 1] - this.average[n5]);
                    }
                    if (j < n8 - 1 && i > 0) {
                        d2 += d3 * ((double)nArray[n5][i - 1][j + 1] - this.average[n5]);
                    }
                    if (j < n8 - 1 && i < n7 - 1) {
                        d2 += d3 * ((double)nArray[n5][i + 1][j + 1] - this.average[n5]);
                    }
                    if (j > 0 && i < n7 - 1) {
                        d2 += d3 * ((double)nArray[n5][i + 1][j - 1] - this.average[n5]);
                    }
                    int n13 = n5;
                    this.morans[n13] = this.morans[n13] + d2;
                }
            }
            int n14 = n5;
            this.morans[n14] = this.morans[n14] * (double)(n8 * n7);
            int n15 = n5;
            this.morans[n15] = this.morans[n15] / (double)n;
            int n16 = n5;
            this.morans[n16] = this.morans[n16] / this.variance[n5];
            int n17 = n5;
            this.variance[n17] = this.variance[n17] / (double)(nArray[n5].length * nArray[n5][0].length);
        }
        d /= (double)n6;
        this.hist = new int[n6][];
        this.totalHist = new int[(int)this.totalMinMax[1] - (int)this.totalMinMax[0] + 1];
        n5 = (int)this.totalMinMax[0];
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = (int)this.minMax[n4][0];
            this.hist[n4] = new int[(int)this.minMax[n4][1] - (int)this.minMax[n4][0] + 1];
            for (n2 = 0; n2 < this.hist[n4].length; ++n2) {
                this.hist[n4][n2] = 0;
            }
            this.centerRange[n4] = (this.minMax[n4][0] + this.minMax[n4][1]) / 2.0;
            for (n2 = 0; n2 < n7; ++n2) {
                for (n = 0; n < n8; ++n) {
                    this.totalVariance = ((double)nArray[n4][n2][n] - d) * ((double)nArray[n4][n2][n] - d);
                    int[] nArray3 = this.hist[n4];
                    int n18 = nArray[n4][n2][n] - n3;
                    nArray3[n18] = nArray3[n18] + 1;
                    int n19 = nArray[n4][n2][n] - n5;
                    this.totalHist[n19] = this.totalHist[n19] + 1;
                }
            }
        }
        this.entropy = new double[n6];
        n4 = 0;
        while (n4 < n6) {
            this.entropy[n4] = 0.0;
            for (n3 = 0; n3 < this.hist[n4].length; ++n3) {
                double d4 = (double)this.hist[n4][n3] / (double)(n7 * n8);
                if (!(d4 > 0.0)) continue;
                int n20 = n4;
                this.entropy[n20] = this.entropy[n20] - d4 * Math.log(d4);
            }
            int n21 = n4++;
            this.entropy[n21] = this.entropy[n21] / Math.log(2.0);
        }
        this.totalEntropy = 0.0;
        for (n4 = 0; n4 < this.totalHist.length; ++n4) {
            double d5 = (double)this.totalHist[n4] / (double)(n6 * n7 * n8);
            if (!(d5 > 0.0)) continue;
            this.totalEntropy -= d5 * Math.log(d5);
        }
        this.totalEntropy /= Math.log(2.0);
        this.totalAverage = 0.0;
        this.totalCenterRange = 0.0;
        for (n4 = 0; n4 < n6; ++n4) {
            this.totalAverage += this.average[n4];
            this.totalCenterRange += this.centerRange[n4];
            this.totalEnergy += this.energy[n4];
            this.totalMorans += this.morans[n4];
        }
        this.totalAverage /= (double)n6;
        this.totalCenterRange /= (double)n6;
        this.totalMorans /= (double)n6;
        this.totalVariance /= (double)(nArray.length * nArray[0].length * nArray[0][0].length);
    }

    public int[][] getcountedValues() {
        return this.countedValues;
    }

    public double[][] getMinMax() {
        return this.minMax;
    }

    public double[] getTotalMinMax() {
        return this.totalMinMax;
    }

    public double[] getAverage() {
        return this.average;
    }

    public double getTotalAverage() {
        return this.totalAverage;
    }

    public double[] getCenterRange() {
        return this.centerRange;
    }

    public double getTotalCenterRange() {
        return this.totalCenterRange;
    }

    public double[] getEnergy() {
        return this.energy;
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public double[] getVariance() {
        return this.variance;
    }

    public double getTotalVariance() {
        return (float)this.totalVariance;
    }

    public double[] getEntropy() {
        return this.entropy;
    }

    public double getTotalEntropy() {
        return this.totalEntropy;
    }

    public double[] getMoransMeasure() {
        return this.morans;
    }

    public double getTotalMoransMeasure() {
        return this.totalMorans;
    }
}

