/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import GiciAnalysis.VectorDistance;
import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.concurrent.Callable;

public strictfp class IsoData
implements Callable<int[]> {
    final float[][] points;
    final int numberOfPoints;
    final int dimension;
    final VectorDistance metric;
    int iterationsRemaining;
    final int desiredClusters;
    final int maximumPairToBeMerged;
    final int minimumSamplesPerCluster;
    final float deviationToSplit;
    final float distanceToMerge;
    Integer[][] neighborClusters;
    int clusters;
    int[] pointToCluster;
    float[][] clusterCenters;

    public IsoData(float[][] fArray, VectorDistance vectorDistance) {
        this(fArray, vectorDistance, 2);
    }

    public IsoData(float[][] fArray, VectorDistance vectorDistance, int n) {
        this(fArray, vectorDistance, n, 100, 0, Float.POSITIVE_INFINITY, 0, 0.0f);
    }

    public IsoData(float[][] fArray, VectorDistance vectorDistance, int n, int n2) {
        this(fArray, vectorDistance, n, n2, 0, Float.POSITIVE_INFINITY, 0, 0.0f);
    }

    public IsoData(float[][] fArray, VectorDistance vectorDistance, int n, int n2, int n3, float f, int n4, float f2) {
        int n5;
        this.iterationsRemaining = n2;
        this.desiredClusters = n;
        this.maximumPairToBeMerged = n4;
        this.minimumSamplesPerCluster = n3;
        this.deviationToSplit = f;
        this.distanceToMerge = f2;
        this.metric = vectorDistance;
        this.points = fArray;
        this.numberOfPoints = this.points.length;
        assert (this.numberOfPoints > 0);
        this.dimension = this.points[0].length;
        assert (this.dimension > 0);
        assert (this.minimumSamplesPerCluster * this.desiredClusters <= this.numberOfPoints);
        this.pointToCluster = new int[this.numberOfPoints];
        this.clusters = this.desiredClusters;
        this.clusterCenters = new float[2 * this.clusters][this.dimension];
        Random random = new Random(13L);
        for (n5 = 0; n5 < this.clusters; ++n5) {
            int n6 = random.nextInt(this.points.length);
            for (int i = 0; i < this.dimension; ++i) {
                this.clusterCenters[n5][i] = this.points[n6][i];
            }
        }
        this.neighborClusters = new Integer[this.clusters][this.clusters];
        for (int i = 0; i < this.clusters; ++i) {
            for (n5 = 0; n5 < this.clusters; ++n5) {
                this.neighborClusters[i][n5] = n5;
            }
        }
    }

    private void iterationReclassifyPoints() {
        int n;
        int n2;
        float[][] fArray = new float[this.clusters][this.clusters];
        for (n2 = 0; n2 < this.clusters; ++n2) {
            for (n = n2; n < this.clusters; ++n) {
                float f = this.metric.distance(this.clusterCenters[n2], this.clusterCenters[n]) / 2.0f;
                fArray[n2][n] = f;
                fArray[n][n2] = f;
                assert (!Float.isNaN(fArray[n2][n]));
            }
        }
        ClossestToCentroid clossestToCentroid = new ClossestToCentroid(fArray);
        for (n2 = 0; n2 < this.clusters; ++n2) {
            clossestToCentroid.setCentroid(n2);
            Arrays.sort(this.neighborClusters[n2], clossestToCentroid);
        }
        int[] nArray = new int[this.clusters];
        for (n2 = 0; n2 < this.numberOfPoints; ++n2) {
            float f = Float.POSITIVE_INFINITY;
            int n3 = -1;
            for (n = 0; n < this.clusters; ++n) {
                nArray[n] = 0;
            }
            int n4 = this.pointToCluster[n2];
            Integer[] integerArray = this.neighborClusters[n4];
            for (int i = 0; i < this.clusters; ++i) {
                n = integerArray[i];
                if (nArray[n] != 0) continue;
                float f2 = this.metric.distance(this.clusterCenters[n], this.points[n2]);
                assert (!Float.isNaN(f2));
                if (!(f >= f2)) continue;
                f = f2;
                n3 = n;
                for (int j = i + 1; j < this.clusters; ++j) {
                    int n5 = integerArray[j];
                    if (!(fArray[n3][n5] > f)) continue;
                    nArray[n5] = 1;
                }
            }
            this.pointToCluster[n2] = n3;
            assert (n3 >= 0);
        }
    }

    private int[] iterationCleanUp() {
        int n;
        int n2;
        int[] nArray = new int[this.clusters];
        int[] nArray2 = new int[this.clusters];
        int n3 = 0;
        for (n2 = 0; n2 < this.clusters; ++n2) {
            nArray2[n2] = n2;
        }
        for (n2 = 0; n2 < this.numberOfPoints; ++n2) {
            int n4 = this.pointToCluster[n2];
            nArray[n4] = nArray[n4] + 1;
        }
        for (n2 = 0; n2 < this.clusters - n3; ++n2) {
            if (nArray[n2] >= this.minimumSamplesPerCluster) continue;
            nArray2[n2] = -1;
            nArray2[this.clusters - n3 - 1] = n2;
            nArray[n2] = nArray[this.clusters - n3 - 1];
            nArray[this.clusters - n3 - 1] = 0;
            ++n3;
            --n2;
        }
        for (n2 = 0; n2 < this.numberOfPoints; ++n2) {
            this.pointToCluster[n2] = nArray2[this.pointToCluster[n2]];
        }
        this.clusters -= n3;
        for (n2 = 0; n2 < this.clusters; ++n2) {
            if (nArray[n2] == 0) continue;
            for (n = 0; n < this.dimension; ++n) {
                this.clusterCenters[n2][n] = 0.0f;
            }
        }
        for (n2 = 0; n2 < this.numberOfPoints; ++n2) {
            for (n = 0; n < this.dimension; ++n) {
                if (this.pointToCluster[n2] < 0) continue;
                float[] fArray = this.clusterCenters[this.pointToCluster[n2]];
                int n5 = n;
                fArray[n5] = fArray[n5] + this.points[n2][n];
            }
        }
        for (n2 = 0; n2 < this.clusters; ++n2) {
            if (nArray[n2] == 0) continue;
            n = 0;
            while (n < this.dimension) {
                float[] fArray = this.clusterCenters[n2];
                int n6 = n++;
                fArray[n6] = fArray[n6] / (float)nArray[n2];
            }
        }
        return nArray;
    }

    private boolean iteration() {
        this.iterationReclassifyPoints();
        int[] nArray = this.iterationCleanUp();
        if (this.clusters < 4 * this.desiredClusters / 5) {
            int n;
            int n2;
            float[] fArray = new float[this.clusters];
            float f = 0.0f;
            int n3 = 0;
            for (n2 = 0; n2 < this.clusters; ++n2) {
                fArray[n2] = 0.0f;
            }
            for (n2 = 0; n2 < this.numberOfPoints; ++n2) {
                if (this.pointToCluster[n2] < 0) continue;
                int n4 = this.pointToCluster[n2];
                fArray[n4] = fArray[n4] + this.metric.distance(this.clusterCenters[this.pointToCluster[n2]], this.points[n2]);
            }
            for (n2 = 0; n2 < this.clusters; ++n2) {
                f += fArray[n2];
                n3 += nArray[n2];
                int n5 = n2;
                fArray[n5] = fArray[n5] / (float)nArray[n2];
            }
            f /= (float)n3;
            float[][] fArray2 = new float[this.clusters][this.dimension];
            for (n2 = 0; n2 < this.numberOfPoints; ++n2) {
                if (this.pointToCluster[n2] < 0) continue;
                for (n = 0; n < this.dimension; ++n) {
                    float[] fArray3 = fArray2[this.pointToCluster[n2]];
                    int n6 = n;
                    fArray3[n6] = fArray3[n6] + (this.clusterCenters[this.pointToCluster[n2]][n] - this.points[n2][n]) * (this.clusterCenters[this.pointToCluster[n2]][n] - this.points[n2][n]);
                }
            }
            int n7 = 0;
            for (n2 = 0; n2 < this.clusters; ++n2) {
                float f2 = Float.NEGATIVE_INFINITY;
                int n8 = -1;
                for (n = 0; n < this.dimension; ++n) {
                    if (!(fArray2[n2][n] > f2)) continue;
                    f2 = fArray2[n2][n];
                    n8 = n;
                }
                float f3 = (float)Math.sqrt(fArray2[n2][n8] / (float)nArray[n2]);
                if (f3 > this.deviationToSplit && fArray[n2] > f && nArray[n2] > 2 * this.minimumSamplesPerCluster) {
                    System.arraycopy(this.clusterCenters[n2], 0, this.clusterCenters[this.clusters + n7], 0, this.clusterCenters[n2].length);
                    float f4 = 0.9f;
                    float[] fArray4 = this.clusterCenters[n2];
                    int n9 = n;
                    fArray4[n9] = fArray4[n9] + f4 * f3;
                    float[] fArray5 = this.clusterCenters[this.clusters + n7];
                    int n10 = n;
                    fArray5[n10] = fArray5[n10] - f4 * f3;
                    ++n7;
                }
                this.clusters += n7;
            }
            return true;
        }
        if (3 * this.clusters > 4 * this.desiredClusters) {
            Object object;
            int n;
            PriorityQueue<QueueElement> priorityQueue = new PriorityQueue<QueueElement>(2, new CompareQueueElements());
            for (n = 0; n < this.clusters; ++n) {
                for (int i = 0; i < this.clusters; ++i) {
                    if (n >= i) continue;
                    object = new QueueElement(n, i, this.metric.distance(this.clusterCenters[n], this.clusterCenters[i]));
                    priorityQueue.offer((QueueElement)object);
                }
            }
            object = new boolean[this.clusters];
            int[] nArray2 = new int[this.clusters];
            int n11 = 0;
            for (n = 0; n < this.clusters; ++n) {
                nArray2[n] = n;
            }
            for (n = 0; n < this.maximumPairToBeMerged; ++n) {
                QueueElement queueElement = priorityQueue.poll();
                if (object[queueElement.a] || object[queueElement.b] || queueElement.weight >= this.distanceToMerge) continue;
                object[queueElement.a] = true;
                object[queueElement.b] = true;
                nArray2[queueElement.b] = queueElement.a;
                ++n11;
            }
            for (n = 0; n < this.numberOfPoints; ++n) {
                if (this.pointToCluster[n] < 0) continue;
                this.pointToCluster[n] = nArray2[this.pointToCluster[n]];
            }
            this.clusters -= n11;
            return false;
        }
        return true;
    }

    @Override
    public int[] call() throws Exception {
        int n = 0;
        while (this.iterationsRemaining > 0) {
            int n2;
            float[][] fArrayArray = new float[this.clusters][];
            for (n2 = 0; n2 < this.clusters; ++n2) {
                fArrayArray[n2] = Arrays.copyOf(this.clusterCenters[n2], this.dimension);
            }
            n2 = this.clusters;
            if (this.iteration()) {
                --this.iterationsRemaining;
            }
            ++n;
            if (n2 != this.clusters) {
                n = 0;
            } else {
                block2: for (int i = 0; i < this.clusters; ++i) {
                    for (int j = 0; j < this.dimension; ++j) {
                        if (!(Math.abs(fArrayArray[i][j] - this.clusterCenters[i][j]) > 1.0E-4f)) continue;
                        n = 0;
                        break block2;
                    }
                }
            }
            if (n <= 2) continue;
            break;
        }
        return this.pointToCluster;
    }

    strictfp class ClossestToCentroid
    implements Comparator<Integer> {
        final float[][] distances;
        int origin;

        public ClossestToCentroid(float[][] fArray) {
            this.distances = fArray;
        }

        public void setCentroid(int n) {
            this.origin = n;
        }

        @Override
        public int compare(Integer n, Integer n2) {
            if (this.distances[n][this.origin] > this.distances[n2][this.origin]) {
                return 1;
            }
            if (this.distances[n][this.origin] < this.distances[n2][this.origin]) {
                return -1;
            }
            return 0;
        }
    }

    private strictfp class CompareQueueElements
    implements Comparator<QueueElement> {
        private CompareQueueElements() {
        }

        @Override
        public int compare(QueueElement queueElement, QueueElement queueElement2) {
            float f = queueElement.weight;
            float f2 = queueElement2.weight;
            if (f < f2) {
                return -1;
            }
            if (f > f2) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    private strictfp class QueueElement {
        public final float weight;
        public final int a;
        public final int b;

        public QueueElement(int n, int n2, float f) {
            this.a = n;
            this.b = n2;
            this.weight = f;
        }
    }
}

