/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import java.util.Arrays;

public class OrthogonalityTest {
    private static float stableAccumulation(double[] dArray) {
        double[] dArray2 = Arrays.copyOfRange(dArray, 0, dArray.length);
        if (dArray2.length == 0) {
            return Float.NaN;
        }
        int n = dArray2.length;
        while (n > 1) {
            for (int i = 0; i < n / 2; ++i) {
                dArray2[i] = dArray2[i * 2] + dArray2[i * 2 + 1];
            }
            if (n % 2 != 0) {
                dArray2[n / 2] = dArray2[n - 1];
            }
            n = n / 2 + n % 2;
        }
        return (float)dArray2[0];
    }

    private static float columnDotProduct(float[][] fArray, int n, int n2) {
        double[] dArray = new double[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            dArray[i] = fArray[i][n] * fArray[i][n2];
        }
        return OrthogonalityTest.stableAccumulation(dArray);
    }

    private static float rowDotProduct(float[][] fArray, int n, int n2) {
        assert (fArray[n].length == fArray[n2].length);
        double[] dArray = new double[fArray[n].length];
        for (int i = 0; i < fArray[n].length; ++i) {
            dArray[i] = fArray[n][i] * fArray[n2][i];
        }
        return OrthogonalityTest.stableAccumulation(dArray);
    }

    public static float[] test(float[][] fArray) {
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.NEGATIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        float f5 = Float.POSITIVE_INFINITY;
        float f6 = Float.NEGATIVE_INFINITY;
        float f7 = Float.POSITIVE_INFINITY;
        float f8 = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = i; j < fArray.length; ++j) {
                float f9 = OrthogonalityTest.columnDotProduct(fArray, i, j);
                float f10 = OrthogonalityTest.rowDotProduct(fArray, i, j);
                if (i == j) {
                    f3 = Math.min(f3, f10);
                    f4 = Math.max(f4, f10);
                    f7 = Math.min(f7, f9);
                    f8 = Math.max(f8, f9);
                    continue;
                }
                f = Math.min(f, f10);
                f2 = Math.max(f2, f10);
                f5 = Math.min(f5, f9);
                f6 = Math.max(f6, f9);
            }
        }
        float[] fArray2 = new float[]{f, f2, f3, f4, f5, f6, f7, f8};
        return fArray2;
    }
}

