/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import GiciAnalysis.ImageCovariance;
import GiciMatrix.MatrixAlgebra;
import GiciTransform.KarhunenLoeveTransform;
import GiciTransform.LinearTransform;
import GiciTransform.ZeroMean;
import java.util.concurrent.Callable;

public class RXAlgorithm
implements Callable<float[][]> {
    final float[][][] image;
    final int sizeX;
    final int sizeY;
    final int sizeZ;

    public RXAlgorithm(float[][][] fArray) {
        this.image = fArray;
        this.sizeZ = fArray.length;
        this.sizeY = fArray[0].length;
        this.sizeX = fArray[0][0].length;
    }

    @Override
    public float[][] call() throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        float[][][] fArray = new float[this.sizeZ][this.sizeY][this.sizeX];
        Object object = new float[this.sizeZ];
        for (n4 = 0; n4 < this.sizeZ; ++n4) {
            for (n3 = 0; n3 < this.sizeY; ++n3) {
                for (n2 = 0; n2 < this.sizeX; ++n2) {
                    int n5 = n4;
                    object[n5] = object[n5] + this.image[n4][n3][n2];
                }
            }
        }
        n4 = 0;
        while (n4 < this.sizeZ) {
            int n6 = n4++;
            object[n6] = object[n6] / (float)(this.sizeX * this.sizeY);
        }
        for (n4 = 0; n4 < this.sizeZ; ++n4) {
            for (n3 = 0; n3 < this.sizeY; ++n3) {
                for (n2 = 0; n2 < this.sizeX; ++n2) {
                    fArray[n4][n3][n2] = object[n4];
                }
            }
        }
        object = new float[this.sizeZ][this.sizeY][];
        for (n4 = 0; n4 < this.sizeZ; ++n4) {
            for (n3 = 0; n3 < this.sizeY; ++n3) {
                object[n4][n3] = new float[this.sizeX];
                for (n2 = 0; n2 < this.sizeX; ++n2) {
                    object[n4][n3][n2] = this.image[n4][n3][n2] - fArray[n4][n3][n2];
                }
                fArray[n4][n3] = null;
            }
        }
        fArray = null;
        float[][] fArray2 = ImageCovariance.generateCovarianceMatrix(this.image, 0);
        float[][][] fArray3 = KarhunenLoeveTransform.generateTransform(fArray2);
        LinearTransform linearTransform = new LinearTransform(MatrixAlgebra.transposeC(fArray3[0]), 0);
        linearTransform.transformInPlace((float[][][])object);
        Object object2 = new float[fArray3[1].length];
        for (n = 0; n < this.sizeZ; ++n) {
            object2[n] = fArray3[1][n][n];
        }
        MatrixAlgebra.printVector(object2);
        object2 = new float[this.sizeY][this.sizeX];
        for (n = 0; n < this.sizeY; ++n) {
            for (int i = 0; i < this.sizeX; ++i) {
                float f = 0.0f;
                for (int j = 0; j < this.sizeZ; ++j) {
                    void var11_14 = object[j][n][i];
                    void var12_15 = var11_14 * var11_14 / fArray3[1][j][j];
                    if (Float.isNaN((float)var12_15)) continue;
                    f += var12_15;
                }
                object2[n][i] = (float)Math.sqrt(f);
                assert (!Float.isNaN((float)object2[n][i]));
            }
        }
        return object2;
    }

    public float[][] callold() throws Exception {
        int n;
        int n2;
        int n3;
        ZeroMean zeroMean = new ZeroMean(this.image, 0, false);
        float[][][] fArray = zeroMean.applyMeans();
        float[][][] fArray2 = new float[this.sizeZ][this.sizeY][this.sizeX];
        Object object = new float[this.sizeZ];
        for (n3 = 0; n3 < this.sizeZ; ++n3) {
            for (n2 = 0; n2 < this.sizeY; ++n2) {
                for (n = 0; n < this.sizeX; ++n) {
                    int n4 = n3;
                    object[n4] = object[n4] + this.image[n3][n2][n];
                }
            }
        }
        n3 = 0;
        while (n3 < this.sizeZ) {
            int n5 = n3++;
            object[n5] = object[n5] / (float)(this.sizeX * this.sizeY);
        }
        for (n3 = 0; n3 < this.sizeZ; ++n3) {
            for (n2 = 0; n2 < this.sizeY; ++n2) {
                for (n = 0; n < this.sizeX; ++n) {
                    fArray2[n3][n2][n] = object[n3];
                }
            }
        }
        object = KarhunenLoeveTransform.toCompleteMirrorFill(ImageCovariance.generateCovarianceMatrix(fArray, 0));
        assert (Math.abs(MatrixAlgebra.determinant((float[][])object)) > 1.0E-4f);
        float[][] fArray3 = MatrixAlgebra.inverseC((float[][])object);
        float[][] fArray4 = new float[this.sizeY][this.sizeX];
        for (n2 = 0; n2 < this.sizeY; ++n2) {
            for (n = 0; n < this.sizeX; ++n) {
                float[][] fArray5 = new float[this.sizeZ][1];
                for (int i = 0; i < this.sizeZ; ++i) {
                    fArray5[i][0] = this.image[i][n2][n] - fArray2[i][n2][n];
                }
                float[][] fArray6 = MatrixAlgebra.transposeC(fArray5);
                float[][] fArray7 = MatrixAlgebra.multiplicationCC(fArray6, MatrixAlgebra.multiplicationCC(fArray3, fArray5));
                assert (fArray7.length == 1 && fArray7[0].length == 1);
                fArray4[n2][n] = (float)Math.sqrt(fArray7[0][0]);
            }
        }
        return fArray4;
    }
}

