/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import java.util.concurrent.Callable;

public class SpectralMetrics
implements Callable<SpectralMetrics> {
    boolean called = false;
    final float[][][] image1;
    final float[][][] image2;
    final int sizeX;
    final int sizeY;
    final int sizeZ;
    double maximumSpectralSimilarity;
    double maximumSpectralAngle;
    double maximumSpectralInformationDivergence;
    double minimumPearsonsCorrelation;
    double wangIndexLambda;
    double wangIndexStack;
    double wangIndexBoth;
    double eskiciogluCubeFidelity;
    double eskiciogluSpectralFidelity;
    double eskiciogluStackFidelity;
    double biasError;

    public SpectralMetrics(float[][][] fArray, float[][][] fArray2) {
        this.image1 = fArray;
        this.image2 = fArray2;
        assert (fArray.length == fArray2.length);
        assert (fArray[0].length == fArray2[0].length);
        assert (fArray[0][0].length == fArray2[0][0].length);
        this.sizeZ = fArray.length;
        this.sizeY = fArray[0].length;
        this.sizeX = fArray[0][0].length;
    }

    private double WangQ(double d, double d2, double d3, double d4, double d5) {
        return 4.0 * d5 * d * d2 / ((d3 + d4) * (d * d + d2 * d2));
    }

    @Override
    public SpectralMetrics call() throws Exception {
        int n;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        int n2;
        int n3;
        this.maximumSpectralSimilarity = Double.NEGATIVE_INFINITY;
        this.minimumPearsonsCorrelation = Double.POSITIVE_INFINITY;
        this.maximumSpectralAngle = Double.NEGATIVE_INFINITY;
        this.maximumSpectralInformationDivergence = Double.NEGATIVE_INFINITY;
        double[] dArray = new double[this.sizeZ];
        for (n3 = 0; n3 < this.sizeX; ++n3) {
            for (n2 = 0; n2 < this.sizeY; ++n2) {
                double d9;
                d8 = 0.0;
                int n4 = 0;
                while (n4 < this.sizeZ) {
                    d7 = this.image1[n4][n2][n3] - this.image2[n4][n2][n3];
                    d8 += d7 * d7;
                    int n5 = n4++;
                    dArray[n5] = dArray[n5] + d7;
                }
                d8 /= (double)this.sizeZ;
                d6 = 0.0;
                d5 = 0.0;
                for (int i = 0; i < this.sizeZ; ++i) {
                    d6 += (double)this.image1[i][n2][n3];
                    d5 += (double)this.image2[i][n2][n3];
                }
                d6 /= (double)this.sizeZ;
                d5 /= (double)this.sizeZ;
                d4 = 0.0;
                d3 = 0.0;
                d2 = 0.0;
                for (int i = 0; i < this.sizeZ; ++i) {
                    d4 += ((double)this.image1[i][n2][n3] - d6) * ((double)this.image1[i][n2][n3] - d6);
                    d3 += ((double)this.image2[i][n2][n3] - d5) * ((double)this.image2[i][n2][n3] - d5);
                    d2 += ((double)this.image1[i][n2][n3] - d6) * ((double)this.image2[i][n2][n3] - d5);
                }
                if (!Double.isNaN(d2 /= (double)(this.sizeZ - 1) * Math.sqrt(d4 /= (double)this.sizeZ - 1.0) * Math.sqrt(d3 /= (double)this.sizeZ - 1.0))) {
                    this.minimumPearsonsCorrelation = Math.min(this.minimumPearsonsCorrelation, d2);
                    double d10 = 1.0 - d2 * d2;
                    d9 = Math.sqrt(d8 + d10 * d10);
                    this.maximumSpectralSimilarity = Math.max(this.maximumSpectralSimilarity, d9);
                }
                double d11 = 0.0;
                d9 = 0.0;
                double d12 = 0.0;
                for (int i = 0; i < this.sizeZ; ++i) {
                    d11 += (double)(this.image1[i][n2][n3] * this.image2[i][n2][n3]);
                    d9 += (double)(this.image1[i][n2][n3] * this.image1[i][n2][n3]);
                    d12 += (double)(this.image2[i][n2][n3] * this.image2[i][n2][n3]);
                }
                double d13 = d11 / Math.sqrt(d9 * d12);
                if (Math.abs(d13) > 1.0) {
                    d13 = Math.signum(d13);
                }
                this.maximumSpectralAngle = Math.max(this.maximumSpectralAngle, Math.acos(d13));
                double d14 = 0.0;
                double d15 = 0.0;
                for (int i = 0; i < this.sizeZ; ++i) {
                    d14 += (double)Math.abs(this.image1[i][n2][n3]);
                    d15 += (double)Math.abs(this.image2[i][n2][n3]);
                }
                double d16 = 0.0;
                for (int i = 0; i < this.sizeZ; ++i) {
                    double d17 = (double)this.image1[i][n2][n3] / d14;
                    double d18 = (double)this.image2[i][n2][n3] / d15;
                    d16 += (d17 - d18) * (Math.log(d17) - Math.log(d18));
                }
                this.maximumSpectralInformationDivergence = Math.max(this.maximumSpectralInformationDivergence, d16);
            }
        }
        this.biasError = Double.NEGATIVE_INFINITY;
        for (n3 = 0; n3 < this.sizeZ; ++n3) {
            this.biasError = Math.max(this.biasError, dArray[n3] / (double)(this.sizeX * this.sizeY));
        }
        this.wangIndexLambda = Double.POSITIVE_INFINITY;
        for (n3 = 0; n3 < this.sizeX; ++n3) {
            for (n2 = 0; n2 < this.sizeY; ++n2) {
                int n6;
                d8 = 0.0;
                d6 = 0.0;
                d5 = 0.0;
                d4 = 0.0;
                d3 = 0.0;
                for (n6 = 0; n6 < this.sizeZ; ++n6) {
                    d8 += (double)this.image1[n6][n2][n3];
                    d6 += (double)this.image2[n6][n2][n3];
                }
                d8 /= (double)this.sizeZ;
                d6 /= (double)this.sizeZ;
                for (n6 = 0; n6 < this.sizeZ; ++n6) {
                    d5 += ((double)this.image1[n6][n2][n3] - d8) * ((double)this.image1[n6][n2][n3] - d8);
                    d4 += ((double)this.image2[n6][n2][n3] - d6) * ((double)this.image2[n6][n2][n3] - d6);
                    d3 += ((double)this.image1[n6][n2][n3] - d8) * ((double)this.image2[n6][n2][n3] - d6);
                }
                d2 = this.WangQ(d8, d6, d5 /= (double)this.sizeZ - 1.0, d4 /= (double)this.sizeZ - 1.0, d3 /= (double)this.sizeZ - 1.0);
                if (Double.isNaN(d2)) continue;
                this.wangIndexLambda = Math.min(this.wangIndexLambda, d2);
            }
        }
        this.wangIndexStack = Double.POSITIVE_INFINITY;
        for (n3 = 0; n3 < this.sizeZ; ++n3) {
            int n7;
            double d19 = 0.0;
            double d20 = 0.0;
            d7 = 0.0;
            double d21 = 0.0;
            d = 0.0;
            for (n7 = 0; n7 < this.sizeX; ++n7) {
                for (int i = 0; i < this.sizeY; ++i) {
                    d19 += (double)this.image1[n3][i][n7];
                    d20 += (double)this.image2[n3][i][n7];
                }
            }
            d19 /= (double)this.sizeX * (double)this.sizeY;
            d20 /= (double)this.sizeX * (double)this.sizeY;
            for (n7 = 0; n7 < this.sizeX; ++n7) {
                for (int i = 0; i < this.sizeY; ++i) {
                    d7 += ((double)this.image1[n3][i][n7] - d19) * ((double)this.image1[n3][i][n7] - d19);
                    d21 += ((double)this.image2[n3][i][n7] - d20) * ((double)this.image2[n3][i][n7] - d20);
                    d += ((double)this.image1[n3][i][n7] - d19) * ((double)this.image2[n3][i][n7] - d20);
                }
            }
            double d22 = this.WangQ(d19, d20, d7 /= (double)(this.sizeX * this.sizeY) - 1.0, d21 /= (double)(this.sizeX * this.sizeY) - 1.0, d /= (double)(this.sizeX * this.sizeY) - 1.0);
            if (Double.isNaN(d22)) continue;
            this.wangIndexStack = Math.min(this.wangIndexStack, d22);
        }
        this.wangIndexBoth = this.wangIndexLambda * this.wangIndexStack;
        this.eskiciogluSpectralFidelity = Double.POSITIVE_INFINITY;
        this.eskiciogluCubeFidelity = 0.0;
        double d23 = 0.0;
        for (n = 0; n < this.sizeX; ++n) {
            for (int i = 0; i < this.sizeY; ++i) {
                d6 = 0.0;
                d5 = 0.0;
                for (int j = 0; j < this.sizeZ; ++j) {
                    d = this.image1[j][i][n] - this.image2[j][i][n];
                    d5 += d * d;
                    d6 += (double)(this.image1[j][i][n] * this.image1[j][i][n]);
                    this.eskiciogluCubeFidelity += d * d;
                    d23 += (double)(this.image1[j][i][n] * this.image1[j][i][n]);
                }
                this.eskiciogluSpectralFidelity = Math.min(this.eskiciogluSpectralFidelity, 1.0 - d5 / d6);
            }
        }
        this.eskiciogluCubeFidelity = 1.0 - this.eskiciogluCubeFidelity / d23;
        this.eskiciogluStackFidelity = Double.POSITIVE_INFINITY;
        for (n = 0; n < this.sizeZ; ++n) {
            double d24 = 0.0;
            d7 = 0.0;
            for (int i = 0; i < this.sizeX; ++i) {
                for (int j = 0; j < this.sizeY; ++j) {
                    d = this.image1[n][j][i] - this.image2[n][j][i];
                    d7 += d * d;
                    d24 += (double)(this.image1[n][j][i] * this.image1[n][j][i]);
                }
            }
            this.eskiciogluStackFidelity = Math.min(this.eskiciogluStackFidelity, 1.0 - d7 / d24);
        }
        this.called = true;
        return this;
    }

    public double getEskiciogluCubeFidelity() {
        assert (this.called);
        return this.eskiciogluCubeFidelity;
    }

    public double getEskiciogluSpectralFidelity() {
        assert (this.called);
        return this.eskiciogluSpectralFidelity;
    }

    public double getEskiciogluStackFidelity() {
        assert (this.called);
        return this.eskiciogluStackFidelity;
    }

    public double getMaximumSpectralAngle() {
        assert (this.called);
        return this.maximumSpectralAngle;
    }

    public double getMaximumSpectralInformationDivergence() {
        assert (this.called);
        return this.maximumSpectralInformationDivergence;
    }

    public double getMaximumSpectralSimilarity() {
        assert (this.called);
        return this.maximumSpectralSimilarity;
    }

    public double getMinimumPearsonsCorrelation() {
        assert (this.called);
        return this.minimumPearsonsCorrelation;
    }

    public double getWangIndexBoth() {
        assert (this.called);
        return this.wangIndexBoth;
    }

    public double getWangIndexLambda() {
        assert (this.called);
        return this.wangIndexLambda;
    }

    public double getWangIndexStack() {
        assert (this.called);
        return this.wangIndexStack;
    }

    public double getBiasError() {
        assert (this.called);
        return this.biasError;
    }
}

