/*
 * Decompiled with CFR 0.152.
 */
package GiciBitStream;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BitRandomAccessFile
extends RandomAccessFile {
    protected static final int MASK_SIZE = 8;
    protected static final int ZERO = 0;
    protected static final int ONES = -1;
    protected static final int[] BIT_MASK = new int[8];
    protected static final int[] FIELD_MASK = new int[8];
    private int bits = 0;
    private int validBits = 0;

    public BitRandomAccessFile(File file, String string) throws FileNotFoundException {
        super(file, string);
    }

    protected void fetchByte() throws IOException {
        this.bits = this.read();
        if (this.bits < 0) {
            throw new EOFException();
        }
        this.validBits = 8;
    }

    public void byteAlign() {
        this.validBits = 0;
    }

    public boolean readBitFlag() throws IOException {
        if (this.validBits == 0) {
            this.fetchByte();
        }
        return (this.bits & BIT_MASK[--this.validBits]) != 0;
    }

    public long readSBits(int n) throws IOException {
        if (n == 0) {
            return 0L;
        }
        long l = this.readBitFlag() ? -1L : 0L;
        return (l <<= --n) | this.readUBits(n);
    }

    public float readFBits(int n) throws IOException {
        if (n == 0) {
            return 0.0f;
        }
        int n2 = this.readBitFlag() ? -1 : 0;
        return (float)((long)(n2 <<= --n) | this.readUBits(n)) / 65536.0f;
    }

    public void positionInBits(long l) throws IOException {
        this.validBits = 0;
        int n = (int)(l % 8L);
        this.seek((int)(l / 8L));
        if (n != 0) {
            n = (int)this.readUBits(n);
        }
    }

    public long readUBits(int n) throws IOException {
        long l = 0L;
        while (n > 0) {
            if (this.validBits == 0) {
                this.fetchByte();
            }
            int n2 = n > this.validBits ? this.validBits : n;
            int n3 = this.bits >> this.validBits - n2 & FIELD_MASK[n2 - 1];
            this.validBits -= n2;
            n -= n2;
            l <<= n2;
            l |= (long)n3;
        }
        return l;
    }

    static {
        int n = 1;
        int n2 = 1;
        for (int i = 0; i < 8; ++i) {
            BitRandomAccessFile.BIT_MASK[i] = n;
            BitRandomAccessFile.FIELD_MASK[i] = n2;
            n <<= 1;
            n2 <<= 1;
            ++n2;
        }
    }
}

