/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder.ArithmeticCoder;

import GiciEntropyCoder.ArithmeticCoder.BinaryProbabilityMapping;
import GiciEntropyCoder.ArithmeticCoder.DumbMQCoder;
import GiciEntropyCoder.EntropyCoder;
import GiciEntropyCoder.ProbabilityTable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class ArithmeticCoder
implements EntropyCoder {
    final BinaryProbabilityMapping binaryProbabilityMapping;
    final OutputStream outputStream;
    final ByteArrayOutputStream outputByteStream;
    final DumbMQCoder dumbMQCoder;
    boolean terminated = false;

    public ArithmeticCoder(ProbabilityTable probabilityTable, OutputStream outputStream) {
        this.binaryProbabilityMapping = new BinaryProbabilityMapping(probabilityTable);
        this.outputStream = outputStream;
        this.outputByteStream = new ByteArrayOutputStream();
        this.dumbMQCoder = new DumbMQCoder(this.outputByteStream);
    }

    @Override
    public void codeSymbol(BigInteger bigInteger) throws IOException {
        boolean[] blArray = this.binaryProbabilityMapping.getBits(bigInteger);
        int[] nArray = this.binaryProbabilityMapping.getProbabilities(blArray);
        for (int i = 0; i < blArray.length; ++i) {
            this.dumbMQCoder.codeBit(blArray[i], nArray[i]);
        }
    }

    @Override
    public void terminate() throws IOException {
        assert (!this.terminated);
        this.terminated = true;
        this.dumbMQCoder.terminate();
        DataOutputStream dataOutputStream = new DataOutputStream(this.outputStream);
        dataOutputStream.writeLong(this.outputByteStream.size());
        dataOutputStream.flush();
        this.outputByteStream.writeTo(this.outputStream);
    }
}

