/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder.ArithmeticCoder;

import GiciEntropyCoder.ArithmeticCoder.BinaryProbabilityMapping;
import GiciEntropyCoder.ArithmeticCoder.DumbMQDecoder;
import GiciEntropyCoder.EntropyDecoder;
import GiciEntropyCoder.ProbabilityTable;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class ArithmeticDecoder
implements EntropyDecoder {
    final BinaryProbabilityMapping binaryProbabilityMapping;
    final DumbMQDecoder dumbMQDecoder;
    final int bitCount;
    final boolean[] bits;

    public ArithmeticDecoder(ProbabilityTable probabilityTable, InputStream inputStream) {
        this.binaryProbabilityMapping = new BinaryProbabilityMapping(probabilityTable);
        this.dumbMQDecoder = new DumbMQDecoder(new LimitedInputStream(inputStream));
        this.bitCount = this.binaryProbabilityMapping.getBitLength();
        this.bits = new boolean[this.bitCount];
    }

    @Override
    public BigInteger decodeSymbol() throws IOException {
        for (int i = 0; i < this.bitCount; ++i) {
            int n = this.binaryProbabilityMapping.getPartialProbability(this.bits, i);
            this.bits[i] = this.dumbMQDecoder.decodeBit(n);
        }
        return this.binaryProbabilityMapping.bitsToSymbol(this.bits);
    }

    class LimitedInputStream
    extends FilterInputStream {
        long sizeLimit;
        long sizeCount;

        protected LimitedInputStream(InputStream inputStream) {
            super(inputStream);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            try {
                this.sizeLimit = dataInputStream.readLong();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.sizeCount = 0L;
        }

        @Override
        public int read() throws IOException {
            if (this.sizeCount < this.sizeLimit) {
                ++this.sizeCount;
                return super.read();
            }
            return -1;
        }
    }
}

