/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder.ArithmeticCoder;

import java.io.IOException;
import java.io.OutputStream;

public class DumbMQCoder {
    SmallByteStream outputByteStream;
    private int A;
    private int C;
    private int t;
    private int Tr;
    private int L;

    public DumbMQCoder(OutputStream outputStream) {
        this.outputByteStream = new SmallByteStream(outputStream);
        this.restart();
    }

    public void codeBit(boolean bl, int n) throws IOException {
        assert (n >= 1 && n <= 44033);
        boolean bl2 = false;
        if (n > 22017) {
            bl2 = true;
            n = 44034 - n;
        }
        boolean bl3 = bl;
        int n2 = n;
        boolean bl4 = bl2;
        this.A -= n2;
        if (bl3 == bl4) {
            if (this.A >= 32768) {
                this.C += n2;
            } else {
                if (this.A < n2) {
                    this.A = n2;
                } else {
                    this.C += n2;
                }
                while (this.A < 32768) {
                    this.A <<= 1;
                    this.C <<= 1;
                    --this.t;
                    if (this.t != 0) continue;
                    this.transferByte();
                }
            }
        } else {
            if (this.A < n2) {
                this.C += n2;
            } else {
                this.A = n2;
            }
            while (this.A < 32768) {
                this.A <<= 1;
                this.C <<= 1;
                --this.t;
                if (this.t != 0) continue;
                this.transferByte();
            }
        }
    }

    private void transferByte() throws IOException {
        if (this.Tr == 255) {
            this.outputByteStream.addByte((byte)this.Tr);
            ++this.L;
            this.Tr = this.C >>> 20;
            this.C &= 0xFFFFF;
            this.t = 7;
        } else {
            if (this.C >= 0x8000000) {
                ++this.Tr;
                this.C &= 0x7FFFFFF;
            }
            if (this.L >= 0) {
                this.outputByteStream.addByte((byte)this.Tr);
            }
            ++this.L;
            if (this.Tr == 255) {
                this.Tr = this.C >>> 20;
                this.C &= 0xFFFFF;
                this.t = 7;
            } else {
                this.Tr = this.C >>> 19;
                this.C &= 0x7FFFF;
                this.t = 8;
            }
        }
    }

    private void restart() {
        this.A = 32768;
        this.C = 0;
        this.t = 12;
        this.Tr = 0;
        this.L = -1;
    }

    public void terminate() throws IOException {
        this.terminateOptimal();
        this.outputByteStream.flush();
    }

    public void terminateEasy() throws IOException {
        int n = 12 - this.t;
        this.C <<= this.t;
        while (n > 0) {
            this.transferByte();
            n -= this.t;
            this.C <<= this.t;
        }
        this.transferByte();
        if (this.t == 7) {
            this.outputByteStream.deleteEndBytes(1);
        }
    }

    private void terminateOptimal() throws IOException {
        boolean bl;
        int n = this.Tr;
        int n2 = this.t;
        int n3 = this.C;
        int n4 = this.A;
        int n5 = this.L;
        int n6 = this.outputByteStream.getNumBytes();
        this.terminateEasy();
        int n7 = this.minFlush(n, n2, n3, n4, n5, n6);
        int n8 = n6 + n7;
        if (n8 >= 1 && this.outputByteStream.getByte(n8 - 1) == 255) {
            --n8;
        }
        do {
            bl = false;
            if (n8 < 2 || this.outputByteStream.getByte(n8 - 2) != 255 || this.outputByteStream.getByte(n8 - 1) != 127) continue;
            n8 -= 2;
            bl = true;
        } while (bl);
        this.outputByteStream.deleteEndBytes(this.outputByteStream.getNumBytes() - n8);
    }

    private int minFlush(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        long l = ((long)n << 27) + ((long)n3 << n2);
        long l2 = (long)n4 << n2;
        long l3 = 0L;
        int n7 = 8;
        int n8 = 35;
        int n9 = 0;
        int n10 = 5;
        int n11 = this.outputByteStream.getNumBytes() - n6;
        if (n10 > n11) {
            n10 = n11;
        }
        if (n6 == 0 && (l >> 32 & 0xFFL) == 0L && n5 == -1) {
            l <<= 8;
            l2 <<= 8;
        }
        while (n9 < n10 && (l3 + (1L << n8) - 1L < l || l3 + (1L << n8) - 1L >= l + l2)) {
            if (++n9 > 4) continue;
            n8 -= n7;
            long l4 = this.outputByteStream.getByte(n6 + n9 - 1);
            if (l4 < 0L) {
                l4 += 256L;
            }
            l3 += l4 << n8;
            if (l4 == 255L) {
                n7 = 7;
                continue;
            }
            n7 = 8;
        }
        return n9;
    }

    final class SmallByteStream {
        OutputStream outputStream;
        final int halfSize = 32768;
        final int maxSize = 65536;
        final byte[] circularBuffer = new byte[65536];
        int start = 0;
        int used = 0;
        int totalWriten = 0;

        SmallByteStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void addByte(byte by) throws IOException {
            this.circularBuffer[(this.start + this.used) % 65536] = by;
            ++this.used;
            if (this.used == 65536) {
                this.flushHalf();
            }
        }

        public void flushHalf() throws IOException {
            int n = 32768;
            assert (n <= this.used);
            assert (this.start == 0 || this.start == 32768);
            this.outputStream.write(this.circularBuffer, this.start, n);
            this.start = (this.start + n) % 65536;
            this.used -= n;
            this.totalWriten += n;
        }

        public void flush() throws IOException {
            if (this.used > 32768) {
                this.flushHalf();
            }
            this.outputStream.write(this.circularBuffer, this.start, this.used);
            this.start = 0;
            this.used = 0;
            this.totalWriten = 0;
        }

        public void deleteEndBytes(int n) {
            assert (n <= this.used);
            this.used -= n;
        }

        public int getNumBytes() {
            return this.totalWriten + this.used;
        }

        public int getByte(int n) {
            assert (this.totalWriten <= n && n < this.totalWriten + this.used);
            return this.circularBuffer[(this.start + (n - this.totalWriten)) % 65536];
        }
    }
}

