/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder.EntropyIntegerCoder;

import GiciEntropyCoder.Interface.EntropyDecoder;
import GiciException.ParameterException;
import GiciMath.IntegerMath;
import GiciStream.BitInputStream;
import java.io.IOException;

public class EntropyIntegerDecoder
implements EntropyDecoder {
    private BitInputStream bis = null;
    private int[] accumulator;
    private int[] counter;
    private int numBitsRead;
    private final int initialCountExponent;
    private final int accumulatorInitConstant;
    private final int rescalingCounterSize;
    private final int dynamicRange;
    private final int unaryLengthLimit;
    private int[] accumulatorTable = null;

    public EntropyIntegerDecoder(BitInputStream bitInputStream, int n, int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        this.bis = bitInputStream;
        this.numBitsRead = 0;
        this.initialCountExponent = n;
        this.accumulatorInitConstant = n2;
        this.rescalingCounterSize = n3;
        this.dynamicRange = n4;
        this.unaryLengthLimit = n5;
        this.accumulatorTable = nArray;
        this.accumulator = new int[n6];
        this.counter = new int[n6];
    }

    @Override
    public void init(int n) {
        int n2 = 0;
        this.counter[n] = 1 << this.initialCountExponent;
        if (this.accumulatorInitConstant < 15) {
            n2 = this.accumulatorInitConstant;
        } else if (this.accumulatorInitConstant == 15) {
            n2 = this.accumulatorTable[n];
        } else {
            try {
                throw new ParameterException("PARAMS ERROR: ACCUMULATOR_INITIALIZATION_CONSTANT has been set to an invalid value: " + this.accumulatorInitConstant);
            }
            catch (ParameterException parameterException) {
                parameterException.printStackTrace();
            }
        }
        this.accumulator[n] = (3 * (1 << n2 + 6) - 49) * this.counter[n];
        int n3 = n;
        this.accumulator[n3] = this.accumulator[n3] >> 7;
    }

    @Override
    public void update(int n, int n2, int n3) {
        int n4 = (1 << this.rescalingCounterSize) - 1;
        if (n2 > 0) {
            if (this.counter[n3] < n4) {
                int n5 = n3;
                this.accumulator[n5] = this.accumulator[n5] + n;
                int n6 = n3;
                this.counter[n6] = this.counter[n6] + 1;
            } else {
                this.accumulator[n3] = this.accumulator[n3] + n + 1 >> 1;
                this.counter[n3] = this.counter[n3] + 1 >> 1;
            }
        }
    }

    @Override
    public int decodeSample(int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (n == 0) {
            n4 = this.bis.read(this.dynamicRange);
            this.numBitsRead += this.dynamicRange;
            return n4;
        }
        int n5 = -1;
        int n6 = IntegerMath.log2((this.accumulator[n2] + (49 * this.counter[n2] >> 7)) / this.counter[n2]);
        n6 = n6 < 0 ? 0 : n6;
        int n7 = n6 = n6 > this.dynamicRange - 2 ? this.dynamicRange - 2 : n6;
        for (n3 = 0; n3 < this.unaryLengthLimit && n5 != 1; ++n3) {
            n5 = this.bis.read(1);
        }
        this.numBitsRead += n3;
        if (n5 == 1 && n3 > 0) {
            --n3;
        }
        if (n3 < this.unaryLengthLimit) {
            int n8 = this.bis.read(n6);
            n4 = (n3 << n6) + n8;
            this.numBitsRead += n6;
        } else {
            n4 = this.bis.read(this.dynamicRange);
            this.numBitsRead += this.dynamicRange;
        }
        return n4;
    }

    @Override
    public void terminate() throws IOException {
        this.bis.close();
    }

    public void terminate(boolean bl) throws IOException {
        this.bis.close();
        if (bl) {
            System.out.println("read: " + this.numBitsRead);
        }
    }
}

