/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder.RiceCoder;

import GiciEntropyCoder.Interface.EntropyCoder;
import GiciEntropyCoder.UnaryCoder.UnaryCoder;
import GiciMath.IntegerMath;
import GiciStream.BitOutputStream;
import java.io.IOException;

public class RiceCoder
implements EntropyCoder {
    protected final BitOutputStream bos;
    protected final UnaryCoder unaryCoder;
    protected final int blockSize;
    protected final int dynamicRange;
    protected final int bitMask;
    protected final int idBits;
    protected final int numOptions;
    protected final int backupOption;
    protected int codingOption;
    protected int[] block = null;
    protected int blockCounter = 0;

    public RiceCoder(BitOutputStream bitOutputStream, int n, int n2, boolean bl) {
        this.bos = bitOutputStream;
        this.unaryCoder = new UnaryCoder(bitOutputStream);
        if (n < 1) {
            throw new RuntimeException("Block Size must be positive.");
        }
        this.blockSize = n;
        if (n2 < 1 || n2 > 32) {
            throw new RuntimeException("Dynamic Range must be between 1 and 32.");
        }
        this.dynamicRange = n2;
        this.bitMask = (int)(1L << n2) - 1;
        int n3 = IntegerMath.log2(n2 - 1) + 1;
        this.idBits = bl ? n3 : Math.max(n3, 3);
        this.numOptions = 1 << this.idBits;
        this.backupOption = this.numOptions - 1;
        this.block = new int[n];
        for (int i = 0; i < n; ++i) {
            this.block[i] = 0;
        }
    }

    @Override
    public void codeSample(int n, int n2, int n3) throws IOException {
        this.block[this.blockCounter] = n;
        ++this.blockCounter;
        if (this.blockCounter == this.blockSize) {
            this.blockCounter = 0;
            this.codeBlock(this.block);
            for (int i = 0; i < this.blockSize; ++i) {
                this.block[i] = 0;
            }
        }
    }

    public void codeBlock(int[] nArray) throws IOException {
        int[] nArray2 = this.maskBlockBits(nArray);
        this.findBestCodingOption(nArray2);
        this.bos.write(this.idBits, this.codingOption);
        if (this.codingOption == this.backupOption) {
            this.backupBlock(nArray2);
        } else {
            this.riceCodeBlock(nArray2, this.codingOption);
        }
    }

    @Override
    public void terminate() throws IOException {
        if (this.blockCounter > 0) {
            this.codeBlock(this.block);
            this.blockCounter = 0;
        }
        this.finish();
    }

    public void finish() throws IOException {
        this.bos.flush();
    }

    protected int[] maskBlockBits(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i] & this.bitMask;
        }
        return nArray2;
    }

    protected void findBestCodingOption(int[] nArray) {
        this.codingOption = this.backupOption;
        long l = nArray.length * this.dynamicRange;
        for (int i = 0; i < this.numOptions - 1; ++i) {
            long l2 = 0L;
            for (int n : nArray) {
                l2 += ((long)n & 0xFFFFFFFFL) >>> i;
            }
            long l3 = l2 + (long)((i + 1) * nArray.length);
            if (l3 >= l) continue;
            this.codingOption = i;
            l = l3;
        }
    }

    protected long sumBlock(int[] nArray) {
        long l = 0L;
        for (int n : nArray) {
            long l2 = (long)n & 0xFFFFFFFFL;
            l += l2;
        }
        return l;
    }

    protected void backupBlock(int[] nArray) throws IOException {
        for (int n : nArray) {
            this.bos.write(this.dynamicRange, n);
        }
    }

    protected void riceCodeBlock(int[] nArray, int n) throws IOException {
        int n2;
        if (n < 0 || n > 31) {
            throw new RuntimeException("K must be between 0 and 31.");
        }
        for (n2 = 0; n2 < this.blockSize; ++n2) {
            this.unaryCoder.codeSample(nArray[n2] >>> n);
        }
        for (n2 = 0; n2 < this.blockSize; ++n2) {
            this.bos.write(n, nArray[n2]);
        }
    }

    @Override
    public void init(int n) {
    }

    @Override
    public void update(int n, int n2, int n3) {
    }
}

