/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder.RiceCoder;

import GiciEntropyCoder.Interface.EntropyDecoder;
import GiciEntropyCoder.UnaryCoder.UnaryDecoder;
import GiciMath.IntegerMath;
import GiciStream.BitInputStream;
import java.io.IOException;

public class RiceDecoder
implements EntropyDecoder {
    protected final BitInputStream bis;
    protected final UnaryDecoder unaryDecoder;
    protected final int blockSize;
    protected final int dynamicRange;
    protected final int idBits;
    protected final int numOptions;
    protected final int backupOption;
    protected int codingOption;
    protected int blockCounter;
    protected int[] block;

    public RiceDecoder(BitInputStream bitInputStream, int n, int n2, boolean bl) {
        this.bis = bitInputStream;
        this.unaryDecoder = new UnaryDecoder(bitInputStream);
        if (n < 1) {
            throw new RuntimeException("Block Size must be positive.");
        }
        this.blockSize = n;
        if (n2 < 1 || n2 > 32) {
            throw new RuntimeException("Dynamic Range must be between 1 and 32.");
        }
        this.dynamicRange = n2;
        int n3 = IntegerMath.log2(n2 - 1) + 1;
        this.idBits = bl ? n3 : Math.max(n3, 3);
        this.numOptions = 1 << this.idBits;
        this.backupOption = this.numOptions - 1;
        this.block = new int[n];
        this.blockCounter = 0;
    }

    public void decodeBlock(int[] nArray) throws IOException {
        this.readId();
        if (this.codingOption == this.backupOption) {
            this.restoreBlock(nArray);
        } else {
            this.riceDecodeBlock(nArray, this.codingOption);
        }
    }

    protected void restoreBlock(int[] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.bis.read(this.dynamicRange);
        }
    }

    protected void riceDecodeBlock(int[] nArray, int n) throws IOException {
        int n2;
        int n3 = 0;
        if (n < 0 || n > 31) {
            throw new RuntimeException("K must be between 0 and 31.");
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = this.unaryDecoder.decodeSample() << n;
        }
        n2 = 0;
        while (n2 < nArray.length) {
            n3 = this.bis.read(n);
            int n4 = n2++;
            nArray[n4] = nArray[n4] | n3;
        }
    }

    void readId() throws IOException {
        this.codingOption = this.bis.read(this.idBits);
    }

    @Override
    public void init(int n) {
    }

    @Override
    public int decodeSample(int n, int n2) throws IOException {
        if (this.blockCounter == 0) {
            this.decodeBlock(this.block);
            this.blockCounter = this.blockSize;
        }
        --this.blockCounter;
        return this.block[this.blockSize - this.blockCounter - 1];
    }

    @Override
    public void update(int n, int n2, int n3) {
    }

    @Override
    public void terminate() throws IOException {
        this.bis.close();
    }
}

